/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.BaseByteToIntConverter;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.IntArgb;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class ByteBgraPre {
    public static final BytePixelGetter getter = Accessor.instance;
    public static final BytePixelSetter setter = Accessor.instance;
    public static final BytePixelAccessor accessor = Accessor.instance;
    private static ByteToBytePixelConverter ToByteBgraPreObj;

    public static ByteToBytePixelConverter ToByteBgraConverter() {
        return ToByteBgraConv.instance;
    }

    public static ByteToBytePixelConverter ToByteBgraPreConverter() {
        if (ToByteBgraPreObj == null) {
            ToByteBgraPreObj = BaseByteToByteConverter.create(accessor);
        }
        return ToByteBgraPreObj;
    }

    public static ByteToIntPixelConverter ToIntArgbConverter() {
        return ToIntArgbConv.instance;
    }

    public static ByteToIntPixelConverter ToIntArgbPreConverter() {
        return ByteBgra.ToIntArgbSameConv.premul;
    }

    public static class ToIntArgbConv
    extends BaseByteToIntConverter {
        public static final ByteToIntPixelConverter instance = new ToIntArgbConv();

        private ToIntArgbConv() {
            super(getter, IntArgb.setter);
        }

        @Override
        void doConvert(byte[] byArray, int n, int n2, int[] nArray, int n3, int n4, int n5, int n6) {
            n2 -= n5 * 4;
            n4 -= n5;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7;
                    int n8 = byArray[n++] & 0xFF;
                    int n9 = byArray[n++] & 0xFF;
                    int n10 = byArray[n++] & 0xFF;
                    if ((n7 = byArray[n++] & 0xFF) > 0 && n7 < 255) {
                        int n11 = n7 >> 1;
                        n10 = (n10 * 255 + n11) / n7;
                        n9 = (n9 * 255 + n11) / n7;
                        n8 = (n8 * 255 + n11) / n7;
                    }
                    nArray[n3++] = n7 << 24 | n10 << 16 | n9 << 8 | n8;
                }
                n3 += n4;
                n += n2;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n, int n2, IntBuffer intBuffer, int n3, int n4, int n5, int n6) {
            n2 -= n5 * 4;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = byteBuffer.get(n) & 0xFF;
                    int n8 = byteBuffer.get(n + 1) & 0xFF;
                    int n9 = byteBuffer.get(n + 2) & 0xFF;
                    int n10 = byteBuffer.get(n + 3) & 0xFF;
                    n += 4;
                    if (n10 > 0 && n10 < 255) {
                        int n11 = n10 >> 1;
                        n9 = (n9 * 255 + n11) / n10;
                        n8 = (n8 * 255 + n11) / n10;
                        n7 = (n7 * 255 + n11) / n10;
                    }
                    intBuffer.put(n3 + i, n10 << 24 | n9 << 16 | n8 << 8 | n7);
                }
                n3 += n4;
                n += n2;
            }
        }
    }

    public static class ToByteBgraConv
    extends BaseByteToByteConverter {
        public static final ByteToBytePixelConverter instance = new ToByteBgraConv();

        private ToByteBgraConv() {
            super(getter, ByteBgra.setter);
        }

        @Override
        void doConvert(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, int n6) {
            n2 -= n5 * 4;
            n4 -= n5 * 4;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7;
                    byte by = byArray[n++];
                    byte by2 = byArray[n++];
                    byte by3 = byArray[n++];
                    if ((n7 = byArray[n++] & 0xFF) > 0 && n7 < 255) {
                        int n8 = n7 >> 1;
                        by = (byte)(((by & 0xFF) * 255 + n8) / n7);
                        by2 = (byte)(((by2 & 0xFF) * 255 + n8) / n7);
                        by3 = (byte)(((by3 & 0xFF) * 255 + n8) / n7);
                    }
                    byArray2[n3++] = by;
                    byArray2[n3++] = by2;
                    byArray2[n3++] = by3;
                    byArray2[n3++] = (byte)n7;
                }
                n += n2;
                n3 += n4;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4, int n5, int n6) {
            n2 -= n5 * 4;
            n4 -= n5 * 4;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    byte by = byteBuffer.get(n);
                    byte by2 = byteBuffer.get(n + 1);
                    byte by3 = byteBuffer.get(n + 2);
                    int n7 = byteBuffer.get(n + 3) & 0xFF;
                    n += 4;
                    if (n7 > 0 && n7 < 255) {
                        int n8 = n7 >> 1;
                        by = (byte)(((by & 0xFF) * 255 + n8) / n7);
                        by2 = (byte)(((by2 & 0xFF) * 255 + n8) / n7);
                        by3 = (byte)(((by3 & 0xFF) * 255 + n8) / n7);
                    }
                    byteBuffer2.put(n3, by);
                    byteBuffer2.put(n3 + 1, by2);
                    byteBuffer2.put(n3 + 2, by3);
                    byteBuffer2.put(n3 + 3, (byte)n7);
                    n3 += 4;
                }
                n += n2;
                n3 += n4;
            }
        }
    }

    static class Accessor
    implements BytePixelAccessor {
        static final BytePixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.PREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 4;
        }

        @Override
        public int getArgb(byte[] byArray, int n) {
            return PixelUtils.PretoNonPre(this.getArgbPre(byArray, n));
        }

        @Override
        public int getArgbPre(byte[] byArray, int n) {
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
        }

        @Override
        public int getArgb(ByteBuffer byteBuffer, int n) {
            return PixelUtils.PretoNonPre(this.getArgbPre(byteBuffer, n));
        }

        @Override
        public int getArgbPre(ByteBuffer byteBuffer, int n) {
            return byteBuffer.get(n) & 0xFF | (byteBuffer.get(n + 1) & 0xFF) << 8 | (byteBuffer.get(n + 2) & 0xFF) << 16 | byteBuffer.get(n + 3) << 24;
        }

        @Override
        public void setArgb(byte[] byArray, int n, int n2) {
            this.setArgbPre(byArray, n, PixelUtils.NonPretoPre(n2));
        }

        @Override
        public void setArgbPre(byte[] byArray, int n, int n2) {
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >> 8);
            byArray[n + 2] = (byte)(n2 >> 16);
            byArray[n + 3] = (byte)(n2 >> 24);
        }

        @Override
        public void setArgb(ByteBuffer byteBuffer, int n, int n2) {
            this.setArgbPre(byteBuffer, n, PixelUtils.NonPretoPre(n2));
        }

        @Override
        public void setArgbPre(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.put(n, (byte)n2);
            byteBuffer.put(n + 1, (byte)(n2 >> 8));
            byteBuffer.put(n + 2, (byte)(n2 >> 16));
            byteBuffer.put(n + 3, (byte)(n2 >> 24));
        }
    }
}

