/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Mutation;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.MultiMap;

public class MUTCodec
extends AsciiFeatureCodec<Mutation> {
    private static Logger log = Logger.getLogger(MUTCodec.class);
    private String path;
    private boolean isMAF;
    private String[] headers;
    private String[] samples;
    private Genome genome;
    private int chrColumn;
    private int startColumn;
    private int endColumn;
    private int sampleColumn;
    private int typeColumn;
    private int refAlleleColumn;
    private int tumorAllele1Column;
    private int tumorAllele2Column;
    private int errorCount = 0;

    public MUTCodec(String path, Genome genome) {
        super(Mutation.class);
        this.path = path;
        this.genome = genome;
        try {
            LineIteratorImpl reader = new LineIteratorImpl(new AsciiLineReader(ParsingUtils.openInputStream(path)));
            this.readActualHeader(reader);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public Void readActualHeader(LineIterator reader) {
        String nextLine = null;
        while (reader.hasNext()) {
            String[] tokens;
            nextLine = reader.peek();
            if (nextLine.startsWith("#")) {
                if (nextLine.startsWith("#samples")) {
                    tokens = Globals.whitespacePattern.split(nextLine, 2);
                    if (tokens.length < 2) {
                        log.error("Error parsing sample header in mutation file: " + this.path);
                    } else {
                        this.samples = Globals.commaPattern.split(tokens[1]);
                        for (int i = 0; i < this.samples.length; ++i) {
                            this.samples[i] = this.samples[i].trim();
                        }
                    }
                }
                reader.next();
                continue;
            }
            tokens = Globals.tabPattern.split(nextLine);
            if (tokens.length >= 5) {
                reader.next();
                this.headers = tokens;
                this.isMAF = this.headers.length >= 16 && this.headers[0].equalsIgnoreCase("Hugo_Symbol");
                this.setColumns(this.isMAF);
                return null;
            }
            throw new RuntimeException(String.format("Not enough columns in header line found in %s: %s", this.path, nextLine));
        }
        throw new RuntimeException("Unexpected end-of-file (no header line): " + this.path);
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getChrColumn() {
        return this.chrColumn;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    @Override
    public Mutation decode(String line) {
        int end;
        int start;
        if (line.startsWith("#") || line.startsWith("Hugo_Symbol")) {
            return null;
        }
        String[] tokens = Globals.tabPattern.split(line);
        String chr = this.genome == null ? tokens[this.chrColumn].trim() : this.genome.getCanonicalChrName(tokens[this.chrColumn].trim());
        try {
            start = Integer.parseInt(tokens[this.startColumn].trim());
        }
        catch (NumberFormatException e) {
            ++this.errorCount;
            if (this.errorCount > 100) {
                throw new DataLoadException("Column " + (this.startColumn + 1) + " must be a numeric value.", this.path);
            }
            log.info("Error parsing line: " + line);
            return null;
        }
        try {
            end = Integer.parseInt(tokens[this.endColumn].trim());
        }
        catch (NumberFormatException e) {
            ++this.errorCount;
            if (this.errorCount > 100) {
                throw new DataLoadException("Column " + (this.endColumn + 1) + " must be a numeric value.", this.path);
            }
            log.info("Error parsing line: " + line);
            return null;
        }
        if (this.isMAF || start == end) {
            --start;
        }
        String sampleId = tokens[this.sampleColumn].trim();
        String type = tokens[this.typeColumn].trim();
        MultiMap<String, String> attributes = new MultiMap<String, String>();
        int n = Math.min(this.headers.length, tokens.length);
        for (int i = 0; i < n; ++i) {
            String key = this.headers[i];
            String value = tokens[i];
            if (value.length() <= 0) continue;
            attributes.put(key, value);
        }
        Mutation mut = new Mutation(sampleId, chr, start, end, type);
        mut.setAttributes(attributes);
        if (this.refAlleleColumn > 0) {
            mut.setRefAllele(tokens[this.refAlleleColumn].trim());
        }
        if (this.tumorAllele1Column > 0) {
            mut.setAltAllele1(tokens[this.tumorAllele1Column].trim());
        }
        if (this.tumorAllele2Column > 0) {
            mut.setAltAllele2(tokens[this.tumorAllele2Column].trim());
        }
        return mut;
    }

    private void setColumns(boolean isMAF) {
        this.isMAF = isMAF;
        if (isMAF) {
            this.chrColumn = 4;
            this.startColumn = 5;
            this.endColumn = 6;
            this.sampleColumn = 15;
            this.typeColumn = 8;
            this.refAlleleColumn = 10;
            this.tumorAllele1Column = 11;
            this.tumorAllele2Column = 12;
        } else {
            this.chrColumn = 0;
            this.startColumn = 1;
            this.endColumn = 2;
            this.sampleColumn = 3;
            this.typeColumn = 4;
            this.refAlleleColumn = -1;
            this.tumorAllele1Column = -1;
            this.tumorAllele2Column = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMutationAnnotationFile(ResourceLocator locator) {
        String typeStringLC = locator.getTypeString().toLowerCase();
        if (typeStringLC.endsWith(".maf.annotated")) {
            return true;
        }
        String ext = ParsingUtils.getIGVExtension(typeStringLC);
        if (ext.equals("mut")) {
            return true;
        }
        if (ext.equals("maf")) {
            BufferedReader reader = null;
            String path = locator.getPath();
            try {
                String nextLine;
                reader = ParsingUtils.openBufferedReader(path);
                if (reader == null) {
                    boolean bl = false;
                    return bl;
                }
                while ((nextLine = reader.readLine()) != null && nextLine.startsWith("#")) {
                    if (!nextLine.startsWith("#")) continue;
                }
                String[] tokens = nextLine.split("\t");
                boolean bl = tokens.length > 15 && tokens[0].equalsIgnoreCase("Hugo_Symbol");
                return bl;
            }
            catch (IOException e) {
                log.error("Error reading: " + path, e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error("Error closing: " + path, e);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean canDecode(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.length() - 3);
        }
        return fn.endsWith(".narrowpeak") || fn.endsWith(".broadpeak");
    }
}

