/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.expression;

import java.util.HashMap;
import java.util.Map;
import org.broad.igv.data.Dataset;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;

public class ExpressionDataset
implements Dataset {
    private String name;
    private TrackType type = TrackType.GENE_EXPRESSION;
    private Genome genome;
    private String[] columnHeadings;
    private boolean normalized = false;
    private boolean logValues = false;
    private Map<String, Integer> headingIndexMap = new HashMap<String, Integer>();
    Map<String, int[]> startLocationMap = new HashMap<String, int[]>();
    Map<String, int[]> endLocationMap = new HashMap<String, int[]>();
    private Map<String, Integer> longestFeatureMap;
    Map<String, Map<String, float[]>> dataMap = new HashMap<String, Map<String, float[]>>();
    Map<String, String[]> featureNameMap = new HashMap<String, String[]>();
    private TrackProperties trackProperties = new TrackProperties();

    public ExpressionDataset(Genome genome) {
        this.genome = genome;
    }

    @Override
    public float getDataMin() {
        return -3.0f;
    }

    @Override
    public float getDataMax() {
        return 3.0f;
    }

    public void setColumnHeadings(String[] columnHeadings) {
        this.columnHeadings = columnHeadings;
        for (int i = 0; i < columnHeadings.length; ++i) {
            this.headingIndexMap.put(columnHeadings[i], i);
        }
    }

    @Override
    public String[] getTrackNames() {
        return this.columnHeadings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setType(TrackType type) {
        this.type = type;
    }

    @Override
    public TrackType getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.startLocationMap.isEmpty();
    }

    @Override
    public String[] getChromosomes() {
        return this.startLocationMap.keySet().toArray(new String[0]);
    }

    public void setFeatureNames(String chr, String[] names) {
        this.featureNameMap.put(chr, names);
    }

    @Override
    public String[] getFeatureNames(String chr) {
        return this.featureNameMap.get(chr);
    }

    public void setStartLocations(String chr, int[] startLocations) {
        this.startLocationMap.put(chr, startLocations);
    }

    @Override
    public int[] getStartLocations(String chr) {
        return this.startLocationMap.get(chr);
    }

    public void setEndLocations(String chr, int[] endLocations) {
        this.endLocationMap.put(chr, endLocations);
    }

    @Override
    public int[] getEndLocations(String chr) {
        if (chr.equals("All")) {
            return null;
        }
        return this.endLocationMap.get(chr);
    }

    @Override
    public boolean isLogNormalized() {
        return this.normalized;
    }

    public void setData(String heading, String chr, float[] data) {
        Map<String, float[]> tmp = this.dataMap.get(heading);
        if (tmp == null) {
            tmp = new HashMap<String, float[]>();
            this.dataMap.put(heading, tmp);
        }
        tmp.put(chr, data);
    }

    @Override
    public float[] getData(String heading, String chr) {
        Map<String, float[]> tmp = this.dataMap.get(heading);
        if (tmp != null) {
            return tmp.get(chr);
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLogValues() {
        return this.logValues;
    }

    public void setLogValues(boolean logValues) {
        this.logValues = logValues;
    }

    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public void setTrackLine(String trackLine) {
        ParsingUtils.parseTrackLine(trackLine, this.trackProperties);
    }

    @Override
    public Integer getLongestFeature(String chr) {
        return this.longestFeatureMap == null ? Integer.valueOf(1000) : (this.longestFeatureMap.containsKey(chr) ? this.longestFeatureMap.get(chr) : Integer.valueOf(1));
    }

    public void setLongestFeatureMap(Map<String, Integer> longestFeatureMap) {
        this.longestFeatureMap = longestFeatureMap;
    }
}

