/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.util.BitSet;

public class GenomicIndexUtil {
    public static final int BIN_GENOMIC_SPAN = 0x20000000;
    public static final int[] LEVEL_STARTS = new int[]{0, 1, 9, 73, 585, 4681};
    public static final int MAX_BINS = 37450;
    public static final int MAX_LINEAR_INDEX_SIZE = 37451 - LEVEL_STARTS[LEVEL_STARTS.length - 1];
    public static final int UNSET_GENOMIC_LOCATION = 0;

    public static int regionToBin(int beg, int end) {
        if (beg >> 14 == --end >> 14) {
            return 4681 + (beg >> 14);
        }
        if (beg >> 17 == end >> 17) {
            return 585 + (beg >> 17);
        }
        if (beg >> 20 == end >> 20) {
            return 73 + (beg >> 20);
        }
        if (beg >> 23 == end >> 23) {
            return 9 + (beg >> 23);
        }
        if (beg >> 26 == end >> 26) {
            return 1 + (beg >> 26);
        }
        return 0;
    }

    public static int regionToBin(int beg, int end, int minShift, int binDepth) {
        --end;
        int maxShift = minShift + 3 * (binDepth - 1);
        for (int binWidth = minShift; binWidth < maxShift; binWidth += 3) {
            if (beg >> binWidth != end >> binWidth) continue;
            return ((1 << maxShift - binWidth) - 1) / 7 + (beg >> binWidth);
        }
        return 0;
    }

    public static BitSet regionToBins(int startPos, int endPos) {
        int k;
        int end;
        int maxPos = 0x1FFFFFFF;
        int start = startPos <= 0 ? 0 : startPos - 1 & 0x1FFFFFFF;
        int n = end = endPos <= 0 ? 0x1FFFFFFF : endPos - 1 & 0x1FFFFFFF;
        if (start > end) {
            return null;
        }
        BitSet bitSet = new BitSet(37450);
        bitSet.set(0);
        for (k = 1 + (start >> 26); k <= 1 + (end >> 26); ++k) {
            bitSet.set(k);
        }
        for (k = 9 + (start >> 23); k <= 9 + (end >> 23); ++k) {
            bitSet.set(k);
        }
        for (k = 73 + (start >> 20); k <= 73 + (end >> 20); ++k) {
            bitSet.set(k);
        }
        for (k = 585 + (start >> 17); k <= 585 + (end >> 17); ++k) {
            bitSet.set(k);
        }
        for (k = 4681 + (start >> 14); k <= 4681 + (end >> 14); ++k) {
            bitSet.set(k);
        }
        return bitSet;
    }

    public static BitSet regionToBins(int startPos, int endPos, int minShift, int binDepth) {
        int end;
        int maxPos = (1 << minShift + 3 * (binDepth - 1)) - 1;
        int start = startPos <= 0 ? 0 : startPos - 1 & maxPos;
        int n = end = endPos <= 0 ? maxPos : endPos - 1 & maxPos;
        if (start > end) {
            return null;
        }
        int firstBinOnLevel = 1;
        int binWidth = minShift + 3 * (binDepth - 2);
        BitSet bitSet = new BitSet(((1 << 3 * binDepth) - 1) / 7);
        bitSet.set(0);
        for (int level = 1; level < binDepth; ++level) {
            for (int k = firstBinOnLevel + (start >> binWidth); k <= firstBinOnLevel + (end >> binWidth); ++k) {
                bitSet.set(k);
            }
            firstBinOnLevel += 1 << 3 * level;
            binWidth -= 3;
        }
        return bitSet;
    }
}

