/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class BetaIntegerCodec
extends AbstractBitCodec<Integer> {
    private final int offset;
    private final int bitsPerValue;
    private final long valueLimit;

    public BetaIntegerCodec(int offset, int bitsPerValue) {
        if (bitsPerValue <= 0) {
            throw new IllegalArgumentException("Number of bits per value must be positive");
        }
        if (bitsPerValue > 32) {
            throw new IllegalArgumentException("Number of bits per value must be 32 or lower");
        }
        this.offset = offset;
        this.bitsPerValue = bitsPerValue;
        this.valueLimit = 1L << bitsPerValue;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        return bitInputStream.readBits(this.bitsPerValue) - this.offset;
    }

    private int getAndCheckOffsetValue(int value) {
        int newValue = value + this.offset;
        if (newValue < 0) {
            String negative = String.format("Value %s plus offset %s must be positive", value, this.offset);
            throw new IllegalArgumentException(negative);
        }
        if ((long)newValue >= this.valueLimit) {
            String tooBig = String.format("Value %s plus offset %s is greater than or equal to limit %s", value, this.offset, this.valueLimit);
            throw new IllegalArgumentException(tooBig);
        }
        return newValue;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        bitOutputStream.write(this.getAndCheckOffsetValue(value), this.bitsPerValue);
        return this.bitsPerValue;
    }

    @Override
    public final long numberOfBits(Integer value) {
        return this.bitsPerValue;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

