/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.mupit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Component;
import java.io.IOException;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.HttpUtils;

public class Cravat {
    static Color lightGray = new Color(0.9, 0.9, 0.9, 0.5);

    public static void main(String[] args) throws IOException {
        Cravat.test();
    }

    static void test() throws IOException {
        String jsonString = HttpUtils.getInstance().getContentsAsJSON(HttpUtils.createURL("http://www.cravat.us/CRAVAT/rest/service/query?mutation=chr22_30421786_+_A_T"));
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(jsonString).getAsJsonObject();
        Cravat.openCravatView(obj);
    }

    static void openCravatView(JsonObject jsonObject) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Cravat");
            JFXPanel fxPanel = new JFXPanel();
            frame.add((Component)fxPanel);
            frame.setSize(800, 800);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(3);
            Platform.runLater(() -> Cravat.initFX(fxPanel, jsonObject));
        });
    }

    private static void initFX(JFXPanel fxPanel, JsonObject jsonObject) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        ScrollPane scrollPane = new ScrollPane((Node)gridPane);
        Scene scene = new Scene((Parent)scrollPane);
        int row = 1;
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            Label valueLabel;
            String key = entry.getKey();
            String value = entry.getValue().getAsString();
            Label keyLabel = new Label(key);
            if ("dbSNP".equals(key)) {
                String link = "https://www.ncbi.nlm.nih.gov/projects/SNP/snp_ref.cgi?searchType=adhoc_search&type=rs&rs=" + value;
                valueLabel = new Hyperlink(value);
                ((Hyperlink)valueLabel).setOnAction(event -> {
                    try {
                        BrowserLauncher.openURL(link);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            } else {
                valueLabel = new Label(value);
            }
            StackPane keyPane = new StackPane(new Node[]{keyLabel});
            keyPane.setAlignment(Pos.CENTER_LEFT);
            StackPane valuePane = new StackPane(new Node[]{valueLabel});
            valuePane.setAlignment(Pos.CENTER_LEFT);
            if (row % 2 == 0) {
                keyPane.setStyle("-fx-background-color: #FFFFFF;");
                valuePane.setStyle("-fx-background-color: #FFFFFF;");
            }
            gridPane.add((Node)keyPane, 1, row);
            gridPane.add((Node)valuePane, 2, row);
            ++row;
        }
        fxPanel.setScene(scene);
    }
}

