/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcRep;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.internal.EncTGSRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.TGSRep;
import sun.security.krb5.internal.TGSReq;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerValue;

public class KrbTgsRep
extends KrbKdcRep {
    private TGSRep rep;
    private Credentials creds;
    private Ticket secondTicket;
    private static final boolean DEBUG = Krb5.DEBUG;

    KrbTgsRep(byte[] byArray, KrbTgsReq krbTgsReq) throws KrbException, IOException {
        DerValue derValue = new DerValue(byArray);
        TGSReq tGSReq = krbTgsReq.getMessage();
        TGSRep tGSRep = null;
        try {
            tGSRep = new TGSRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            tGSRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = null;
            if (string != null && string.length() > 0) {
                string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            }
            KrbException krbException = string2 == null ? new KrbException(kRBError.getErrorCode()) : new KrbException(kRBError.getErrorCode(), string2);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
        byte[] byArray2 = tGSRep.encPart.decrypt(krbTgsReq.tgsReqKey, krbTgsReq.usedSubkey() ? 9 : 8);
        byte[] byArray3 = tGSRep.encPart.reset(byArray2);
        derValue = new DerValue(byArray3);
        EncTGSRepPart encTGSRepPart = new EncTGSRepPart(derValue);
        tGSRep.encKDCRepPart = encTGSRepPart;
        KrbTgsRep.check(false, tGSReq, tGSRep);
        this.creds = new Credentials(tGSRep.ticket, tGSRep.cname, tGSRep.ticket.sname, encTGSRepPart.key, encTGSRepPart.flags, encTGSRepPart.authtime, encTGSRepPart.starttime, encTGSRepPart.endtime, encTGSRepPart.renewTill, encTGSRepPart.caddr);
        this.rep = tGSRep;
        this.secondTicket = krbTgsReq.getSecondTicket();
    }

    public Credentials getCreds() {
        return this.creds;
    }

    sun.security.krb5.internal.ccache.Credentials setCredentials() {
        return new sun.security.krb5.internal.ccache.Credentials(this.rep, this.secondTicket);
    }
}

