/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;

public class GenomeListManager {
    static final String GENOME_ARCHIVE_VERSION_KEY = "version";
    static final String GENOME_ARCHIVE_PROPERTY_FILE_NAME = "property.txt";
    static final String GENOME_ARCHIVE_ID_KEY = "id";
    static final String GENOME_ARCHIVE_NAME_KEY = "name";
    private static Logger log = Logger.getLogger(GenomeManager.class);
    private static final String ACT_USER_DEFINED_GENOME_LIST_FILE = "user-defined-genomes.txt";
    public static final String TEST_USER_DEFINED_GENOME_LIST_FILE = GenomeManager.TEST_USER_DEFINED_GENOME_LIST_FILE;
    public static final GenomeListItem DEFAULT_GENOME = new GenomeListItem("Human (hg19)", "http://s3.amazonaws.com/igv.broadinstitute.org/genomes/hg19.genome", "hg19");
    private static GenomeListManager theInstance;
    private Map<String, GenomeListItem> genomeItemMap = new HashMap<String, GenomeListItem>();
    private Map<String, GenomeListItem> userDefinedGenomeMap;
    private Map<String, GenomeListItem> serverGenomeMap;
    boolean serverGenomeListUnreachable = false;
    private static GenomeListSorter sorter;

    public static synchronized GenomeListManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeListManager();
        }
        return theInstance;
    }

    private GenomeListManager() {
    }

    public Map<String, GenomeListItem> getGenomeItemMap() throws IOException {
        if (this.genomeItemMap.isEmpty()) {
            this.genomeItemMap.putAll(this.getUserDefinedGenomeMap());
            this.genomeItemMap.putAll(this.getCachedGenomeArchiveList());
            if (this.genomeItemMap.isEmpty()) {
                this.genomeItemMap.put(DEFAULT_GENOME.getId(), DEFAULT_GENOME);
            }
        }
        return this.genomeItemMap;
    }

    public List<GenomeListItem> getGenomeListItems() {
        ArrayList<GenomeListItem> items = new ArrayList<GenomeListItem>(this.genomeItemMap.values());
        items.sort(sorter);
        return items;
    }

    public void rebuildGenomeItemMap() throws IOException {
        this.genomeItemMap.clear();
        this.serverGenomeMap = null;
        this.userDefinedGenomeMap = null;
        this.getGenomeItemMap();
    }

    public void addGenomeItem(GenomeListItem genomeListItem, boolean userDefined) {
        this.genomeItemMap.put(genomeListItem.getId(), genomeListItem);
        if (userDefined) {
            if (this.userDefinedGenomeMap == null) {
                this.userDefinedGenomeMap = new HashMap<String, GenomeListItem>();
            }
            this.userDefinedGenomeMap.put(genomeListItem.getId(), genomeListItem);
            this.exportUserDefinedGenomeList();
        }
    }

    public void addServerGenomeItem(GenomeListItem genomeListItem) {
        this.addGenomeItem(genomeListItem, false);
    }

    public static GenomeListItem buildItemFromPath(String path) {
        String name;
        String id = path;
        if (HttpUtils.isRemoteURL(path)) {
            name = Utilities.getFileNameFromURL(path);
        } else {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            name = file.getName();
        }
        return new GenomeListItem(name, path, id);
    }

    public GenomeListItem getLoadedGenomeListItemById(String genomeId) {
        return this.genomeItemMap.get(genomeId);
    }

    public GenomeListItem getGenomeListItem(String genomeId) {
        GenomeListItem matchingItem = this.genomeItemMap.get(genomeId);
        if (matchingItem == null || System.currentTimeMillis() - matchingItem.getLastModified() > 604800000L) {
            matchingItem = this.getServerGenomeMap().get(genomeId);
            if (matchingItem != null) {
                return matchingItem;
            }
            try {
                this.rebuildGenomeItemMap();
            }
            catch (IOException e) {
                log.error("Error rebuilding genome item map", e);
            }
            matchingItem = this.genomeItemMap.get(genomeId);
        }
        return matchingItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, GenomeListItem> getCachedGenomeArchiveList() throws IOException {
        File[] files;
        HashMap<String, GenomeListItem> cachedGenomeArchiveList = new HashMap<String, GenomeListItem>();
        if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
            return cachedGenomeArchiveList;
        }
        for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
            if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
            ZipFile zipFile = null;
            FileInputStream fis = null;
            ZipInputStream zipInputStream = null;
            try {
                zipFile = new ZipFile(file);
                fis = new FileInputStream(file);
                zipInputStream = new ZipInputStream(new BufferedInputStream(fis));
                ZipEntry zipEntry = zipFile.getEntry(GENOME_ARCHIVE_PROPERTY_FILE_NAME);
                if (zipEntry == null) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Properties properties = new Properties();
                properties.load(inputStream);
                int version = 0;
                if (properties.containsKey(GENOME_ARCHIVE_VERSION_KEY)) {
                    try {
                        version = Integer.parseInt(properties.getProperty(GENOME_ARCHIVE_VERSION_KEY));
                    }
                    catch (Exception e) {
                        log.error("Error parsing genome version: " + version, e);
                    }
                }
                GenomeListItem item = new GenomeListItem(properties.getProperty(GENOME_ARCHIVE_NAME_KEY), file.getAbsolutePath(), properties.getProperty(GENOME_ARCHIVE_ID_KEY));
                long lastModified = file.lastModified();
                item.setLastModified(lastModified);
                cachedGenomeArchiveList.put(item.getId(), item);
            }
            catch (ZipException ex) {
                log.error("\nZip error unzipping cached genome.", ex);
                try {
                    file.delete();
                    zipInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (IOException ex) {
                log.warn("\nIO error unzipping cached genome.", ex);
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (zipInputStream != null) {
                        zipInputStream.close();
                    }
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    log.warn("Error closing genome zip stream!", ex);
                }
            }
        }
        return cachedGenomeArchiveList;
    }

    public Set<String> getServerGenomeIDs() {
        return this.getServerGenomeMap().keySet();
    }

    public Collection<String> getSelectableGenomeIDs() {
        return this.genomeItemMap.keySet();
    }

    public void removeAllItems(List<GenomeListItem> removedValuesList) {
        boolean updateImportFile = false;
        for (GenomeListItem genomeListItem : removedValuesList) {
            String id = genomeListItem.getId();
            this.genomeItemMap.remove(id);
            if (this.userDefinedGenomeMap == null || !this.userDefinedGenomeMap.containsKey(id)) continue;
            this.userDefinedGenomeMap.remove(id);
            updateImportFile = true;
        }
        if (updateImportFile) {
            this.exportUserDefinedGenomeList();
        }
    }

    public void removeGenomeListItem(GenomeListItem genomeListItem) {
        String id = genomeListItem.getId();
        this.genomeItemMap.remove(id);
        if (this.userDefinedGenomeMap != null && this.userDefinedGenomeMap.containsKey(id)) {
            this.userDefinedGenomeMap.remove(id);
            this.exportUserDefinedGenomeList();
        }
    }

    public List<GenomeListItem> getServerGenomeList() {
        ArrayList<GenomeListItem> items = new ArrayList<GenomeListItem>(this.getServerGenomeMap().values());
        items.sort(sorter);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GenomeListItem> getServerGenomeMap() {
        if (this.serverGenomeListUnreachable) {
            return Collections.emptyMap();
        }
        if (this.serverGenomeMap == null) {
            this.serverGenomeMap = new HashMap<String, GenomeListItem>();
            BufferedReader dataReader = null;
            InputStream inputStream = null;
            String genomeListURLString = "";
            try {
                String genomeRecord;
                genomeListURLString = PreferencesManager.getPreferences().getGenomeListURL();
                URL serverGenomeURL = HttpUtils.createURL(genomeListURLString);
                if (HttpUtils.isRemoteURL(genomeListURLString)) {
                    inputStream = HttpUtils.getInstance().openConnectionStream(serverGenomeURL);
                } else {
                    File file = new File(genomeListURLString.startsWith("file:") ? serverGenomeURL.getFile() : genomeListURLString);
                    inputStream = new FileInputStream(file);
                }
                dataReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((genomeRecord = dataReader.readLine()) != null) {
                    if (genomeRecord.startsWith("<") || genomeRecord.startsWith("(#") || genomeRecord == null) continue;
                    String[] fields = (genomeRecord = genomeRecord.trim()).split("\t");
                    if (fields != null && fields.length >= 3) {
                        String name = fields[0];
                        String url = fields[1];
                        String id = fields[2];
                        GenomeListItem item = new GenomeListItem(name, url, id);
                        this.serverGenomeMap.put(item.getId(), item);
                        continue;
                    }
                    log.error("Found invalid server genome list record: " + genomeRecord);
                }
            }
            catch (Exception e) {
                this.serverGenomeListUnreachable = true;
                this.serverGenomeMap = Collections.emptyMap();
                log.error("Error fetching genome list: ", e);
                ConfirmDialog.optionallyShowInfoDialog("Warning: could not connect to the genome server (" + genomeListURLString + ").    Only locally defined genomes will be available.", "SHOW_GENOME_SERVER_WARNING");
            }
            finally {
                if (dataReader != null) {
                    try {
                        dataReader.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
            }
        }
        if (IGVMenuBar.getInstance() != null) {
            IGVMenuBar.getInstance().notifyGenomeServerReachable(!this.serverGenomeListUnreachable);
        }
        return this.serverGenomeMap;
    }

    public Map<String, GenomeListItem> getUserDefinedGenomeMap() {
        if (this.userDefinedGenomeMap == null) {
            boolean updateClientGenomeListFile = false;
            this.userDefinedGenomeMap = new HashMap<String, GenomeListItem>();
            File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.getUserDefinedGenomeListFile());
            if (listFile.exists()) {
                BufferedReader reader = null;
                boolean mightBeProperties = false;
                try {
                    String nextLine;
                    reader = new BufferedReader(new FileReader(listFile));
                    while ((nextLine = reader.readLine()) != null) {
                        String file;
                        if (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                            mightBeProperties = true;
                            continue;
                        }
                        String[] fields = nextLine.split("\t");
                        if (fields.length < 3 && mightBeProperties && fields[0].contains("=")) {
                            fields = nextLine.split("\\\\t");
                            if (fields.length < 3) continue;
                            int idx = fields[0].indexOf("=");
                            fields[0] = fields[0].substring(idx + 1);
                        }
                        if (!FileUtils.resourceExists(file = fields[1])) {
                            updateClientGenomeListFile = true;
                            continue;
                        }
                        try {
                            GenomeListItem item = new GenomeListItem(fields[0], file, fields[2]);
                            this.userDefinedGenomeMap.put(item.getId(), item);
                        }
                        catch (Exception e) {
                            log.error("Error updating user genome list line '" + nextLine + "'", e);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    log.info(e);
                }
                catch (IOException e) {
                    log.error(e);
                    throw new RuntimeException(e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (updateClientGenomeListFile) {
                    this.exportUserDefinedGenomeList();
                }
            }
        }
        return this.userDefinedGenomeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUserDefinedGenomeList() {
        if (this.userDefinedGenomeMap == null) {
            return;
        }
        File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.getUserDefinedGenomeListFile());
        File backup = null;
        if (listFile.exists()) {
            backup = new File(listFile.getAbsolutePath() + ".bak");
            try {
                FileUtils.copyFile(listFile, backup);
            }
            catch (IOException e) {
                log.error("Error backing up user-defined genome list file", e);
                backup = null;
            }
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
            for (GenomeListItem genomeListItem : this.userDefinedGenomeMap.values()) {
                writer.print(genomeListItem.getDisplayableName());
                writer.print("\t");
                writer.print(genomeListItem.getPath());
                writer.print("\t");
                writer.println(genomeListItem.getId());
            }
        }
        catch (Exception e) {
            if (backup != null) {
                try {
                    FileUtils.copyFile(backup, listFile);
                }
                catch (IOException e1) {
                    log.error("Error restoring genome-list file from backup");
                }
            }
            MessageUtils.showErrorMessage("Error updating user-defined genome list " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (backup != null) {
                backup.delete();
            }
        }
    }

    private String getUserDefinedGenomeListFile() {
        if (Globals.isTesting()) {
            return TEST_USER_DEFINED_GENOME_LIST_FILE;
        }
        return ACT_USER_DEFINED_GENOME_LIST_FILE;
    }

    public void clearUserDefinedGenomes() {
        this.userDefinedGenomeMap = null;
        new File(TEST_USER_DEFINED_GENOME_LIST_FILE).delete();
    }

    static {
        sorter = new GenomeListSorter();
    }

    private static class GenomeListSorter
    implements Comparator<GenomeListItem> {
        private GenomeListSorter() {
        }

        @Override
        public int compare(GenomeListItem o1, GenomeListItem o2) {
            return o1.getDisplayableName().toLowerCase().compareTo(o2.getDisplayableName().toLowerCase());
        }
    }
}

