/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.util.List;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;

public class ArcRenderer
extends FeatureRenderer {
    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double pixelEnd;
        double pixelStart;
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color ARC_COLOR = new Color(150, 50, 50);
        double maxWidth = 1.0;
        if (featureList != null && featureList.size() > 0) {
            Object lastRect = null;
            boolean colorOverlay = IGV.getInstance().getSession().getColorOverlay();
            for (IGVFeature feature : featureList) {
                pixelStart = ((double)feature.getStart() - origin) / locScale;
                pixelEnd = ((double)feature.getEnd() - origin) / locScale;
                if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX()) || !(pixelEnd - pixelStart > maxWidth)) continue;
                maxWidth = pixelEnd - pixelStart;
            }
        }
        double f = (double)trackRectangle.height / maxWidth;
        for (IGVFeature feature : featureList) {
            pixelStart = ((double)feature.getStart() - origin) / locScale;
            pixelEnd = ((double)feature.getEnd() - origin) / locScale;
            if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX())) continue;
            Color color = feature.getColor();
            if (color == null) {
                color = track.getColor();
            }
            Graphics2D g = context.getGraphic2DForColor(color);
            g.setFont(FontManager.getDefaultFont());
            int w = (int)(pixelEnd - pixelStart);
            if (w < 3) {
                w = 3;
                pixelStart -= 1.0;
            }
            double h = Math.min((double)trackRectangle.height, f * (double)w);
            double y = (double)(trackRectangle.y + trackRectangle.height) - h;
            Arc2D.Double arcPath = new Arc2D.Double(pixelStart, y, w, 2.0 * h, 0.0, 180.0, 0);
            g.draw(arcPath);
        }
    }
}

