/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import com.google.common.base.Objects;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.IExon;
import org.broad.igv.feature.SequenceOntology;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.WindowFunction;

public class Exon
extends AbstractFeature
implements IExon {
    private int number;
    private int codingStart;
    private int codingEnd;
    private AminoAcidSequence aminoAcidSequence;
    private byte[] seqBytes;
    private boolean noncoding = false;
    private int mrnaBase = -1;

    public void setMrnaBase(int base) {
        this.mrnaBase = base;
    }

    public int getAminoAcidNumber(int genomeCoordinate) {
        if (this.mrnaBase < 0) {
            return -1;
        }
        if (genomeCoordinate < this.getStart() || genomeCoordinate > this.getEnd()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.getStrand() == Strand.POSITIVE) {
            int mrnaCoord = this.mrnaBase + (genomeCoordinate - this.codingStart);
            return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
        }
        if (this.getStrand() == Strand.NEGATIVE) {
            int mrnaCoord = this.mrnaBase + (this.codingEnd - 1 - genomeCoordinate);
            return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
        }
        return 0;
    }

    public Exon(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.codingStart = start;
        this.codingEnd = end;
    }

    public Exon(Exon bf) {
        this.start = bf.getStart();
        this.end = bf.getEnd();
        this.strand = bf.getStrand();
        this.codingStart = bf.getCdStart();
        this.codingEnd = bf.getCdEnd();
        this.chromosome = bf.getChr();
        this.type = bf.getType();
        this.color = bf.getColor();
        this.description = bf.getDescription();
        this.attributes = bf.getAttributes();
        this.name = bf.getName();
        this.readingFrame = bf.getReadingFrame();
        this.noncoding = this.type != null && SequenceOntology.utrTypes.contains(this.type);
    }

    public Exon(BasicFeature bf) {
        this.start = bf.getStart();
        this.end = bf.getEnd();
        this.strand = bf.getStrand();
        this.codingStart = bf.getThickStart();
        this.codingEnd = bf.getThickEnd();
        this.chromosome = bf.getChr();
        this.type = bf.getType();
        this.color = bf.getColor();
        this.description = bf.getDescription();
        this.attributes = bf.getAttributes();
        this.name = bf.getName();
        this.readingFrame = bf.getReadingFrame();
        this.noncoding = this.type != null && SequenceOntology.utrTypes.contains(this.type);
    }

    public void setNonCoding(boolean bool) {
        this.noncoding = bool;
        if (bool) {
            this.codingStart = this.getStrand() == Strand.POSITIVE ? (this.codingEnd = this.getEnd()) : (this.codingEnd = this.getStart());
        }
    }

    @Override
    public boolean isNonCoding() {
        return this.noncoding;
    }

    public void setCodingStart(int codingStart) {
        this.codingStart = Math.max(this.getStart(), codingStart);
    }

    public void setCodingEnd(int codingEnd) {
        this.codingEnd = Math.min(this.getEnd(), codingEnd);
    }

    @Override
    public int getCdStart() {
        return this.codingStart;
    }

    @Override
    public int getCdEnd() {
        return this.codingEnd;
    }

    public int getCodingLength() {
        return this.noncoding ? 0 : Math.max(0, this.codingEnd - this.codingStart);
    }

    public AminoAcidSequence getAminoAcidSequence(Genome genome, Exon prevExon, Exon nextExon) {
        if (this.aminoAcidSequence == null || !Objects.equal(this.aminoAcidSequence.getCodonTableKey(), AminoAcidManager.getInstance().getCodonTable().getKey())) {
            this.computeAminoAcidSequence(genome, prevExon, nextExon);
        }
        return this.aminoAcidSequence;
    }

    private void computeAminoAcidSequence(Genome genome, Exon prevExon, Exon nextExon) {
        if (this.noncoding) {
            return;
        }
        int start = this.getStart();
        int end = this.getEnd();
        String chr = this.getChr();
        if (this.readingFrame >= 0) {
            int readStart = this.codingStart > start ? this.codingStart : start;
            int readEnd = Math.min(end, this.codingEnd);
            if (readEnd > readStart + 3) {
                if (this.seqBytes == null) {
                    this.seqBytes = genome.getSequence(chr, readStart, readEnd);
                }
                if (this.seqBytes != null) {
                    if (this.strand == Strand.POSITIVE) {
                        int phase;
                        int diff;
                        if (this.readingFrame > 0 && prevExon != null) {
                            int diff2 = this.readingFrame;
                            byte[] d = genome.getSequence(chr, prevExon.getCdEnd() - diff2, prevExon.getCdEnd());
                            byte[] tmp = new byte[d.length + this.seqBytes.length];
                            System.arraycopy(d, 0, tmp, 0, diff2);
                            System.arraycopy(this.seqBytes, 0, tmp, diff2, this.seqBytes.length);
                            this.seqBytes = tmp;
                            readStart -= this.readingFrame;
                        }
                        if ((diff = 3 - (readEnd - (this.codingStart + (phase = (3 - this.readingFrame) % 3))) % 3) > 0 && nextExon != null) {
                            byte[] d = genome.getSequence(chr, nextExon.getCdStart(), nextExon.getCdStart() + diff);
                            byte[] tmp = new byte[d.length + this.seqBytes.length];
                            System.arraycopy(this.seqBytes, 0, tmp, 0, this.seqBytes.length);
                            System.arraycopy(d, 0, tmp, this.seqBytes.length, d.length);
                            this.seqBytes = tmp;
                        }
                    } else {
                        byte[] tmp;
                        byte[] d;
                        int diff;
                        if (this.readingFrame > 0 && nextExon != null) {
                            diff = this.readingFrame;
                            d = genome.getSequence(chr, nextExon.getCdStart(), nextExon.getCdStart() + diff);
                            tmp = new byte[d.length + this.seqBytes.length];
                            System.arraycopy(this.seqBytes, 0, tmp, 0, this.seqBytes.length);
                            System.arraycopy(d, 0, tmp, this.seqBytes.length, diff);
                            this.seqBytes = tmp;
                            readEnd += this.readingFrame;
                        }
                        if ((diff = (3 - (readEnd - this.codingStart) % 3) % 3) > 0 && prevExon != null) {
                            d = genome.getSequence(chr, prevExon.getCdEnd() - diff, prevExon.getCdEnd());
                            tmp = new byte[d.length + this.seqBytes.length];
                            System.arraycopy(d, 0, tmp, 0, diff);
                            System.arraycopy(this.seqBytes, 0, tmp, diff, this.seqBytes.length);
                            readStart -= diff;
                            this.seqBytes = tmp;
                        }
                    }
                    this.aminoAcidSequence = AminoAcidManager.getInstance().getAminoAcidSequence(this.getStrand(), readStart, new String(this.seqBytes));
                }
            }
        }
    }

    public Exon copy() {
        Exon copy = new Exon(this.getChr(), this.getStart(), this.getEnd(), this.getStrand());
        copy.seqBytes = this.seqBytes;
        copy.aminoAcidSequence = this.aminoAcidSequence;
        copy.codingEnd = this.codingEnd;
        copy.codingStart = this.codingStart;
        copy.name = this.name;
        copy.noncoding = this.noncoding;
        copy.mrnaBase = this.mrnaBase;
        return copy;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        int aaNumber;
        StringBuffer buffer = new StringBuffer();
        if (this.number > 0) {
            buffer.append("Exon number: " + this.number + "<br>");
        }
        if ((aaNumber = this.getAminoAcidNumber((int)position)) > 0) {
            buffer.append("Amino acid coding number: " + aaNumber + "<br>");
        }
        buffer.append(this.getLocusString());
        if (this.description != null) {
            buffer.append("<br>" + this.description);
        }
        if (this.attributes != null) {
            buffer.append(this.getAttributeString());
        }
        return buffer.toString();
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @Override
    public String getURL() {
        return null;
    }

    public static IExon getExonProxy(IExon exon) {
        ExonLocHandler handler = new ExonLocHandler(exon);
        IExon eProx = (IExon)Proxy.newProxyInstance(IExon.class.getClassLoader(), new Class[]{IExon.class}, (InvocationHandler)handler);
        return eProx;
    }

    private static class ExonLocHandler
    implements InvocationHandler {
        private IExon parent;
        private int hashCode = 0;

        public ExonLocHandler(IExon parent) {
            this.parent = parent;
        }

        private boolean equals(IExon parent, Object inother) {
            if (inother == null || !(inother instanceof IExon)) {
                return false;
            }
            IExon other = (IExon)inother;
            boolean eq = parent.getChr().equals(other.getChr());
            eq &= parent.getStart() == other.getStart();
            eq &= parent.getEnd() == other.getEnd();
            eq &= parent.getCdStart() == other.getCdStart();
            eq &= parent.getCdEnd() == other.getCdEnd();
            return eq &= parent.getStrand() == other.getStrand();
        }

        private int hashCode(IExon parent) {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            String conc = parent.getChr() + parent.getStrand().toString() + parent.getStart();
            conc = conc + parent.getEnd();
            conc = conc + parent.getCdStart();
            int hc = (conc = conc + parent.getCdEnd()).hashCode();
            if (hc == 0) {
                hc = 1;
            }
            this.hashCode = hc;
            return hc;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("hashCode")) {
                return this.hashCode(this.parent);
            }
            if (method.getName().equals("equals")) {
                return this.equals(this.parent, args[0]);
            }
            return method.invoke((Object)this.parent, args);
        }
    }
}

