/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.SamRecordTrackingBuffer;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.PhysicalLocationForMateCigarSet;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.markduplicates.util.ReadEndsForMateCigar;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class MarkQueue {
    private int toMarkQueueMinimumDistance = -1;
    private int numDuplicates = 0;
    private final TreeSet<ReadEndsForMateCigar> nonDuplicateReadEndsSet = new TreeSet<ReadEndsForMateCigar>(new MarkQueueComparator());
    private final TreeSet<ReadEndsForMateCigar> otherEndOfNonDuplicateReadEndsSet = new TreeSet<ReadEndsForMateCigar>(new MarkQueueComparator());
    private final Comparator<ReadEndsForMateCigar> comparator;
    private ReadEndsForMateCigar tmpReadEnds = null;

    public MarkQueue(DuplicateScoringStrategy.ScoringStrategy duplicateScoringStrategy) {
        this.comparator = new ReadEndsMCComparator(duplicateScoringStrategy);
    }

    public int getNumDuplicates() {
        return this.numDuplicates;
    }

    public int size() {
        return this.nonDuplicateReadEndsSet.size() + this.otherEndOfNonDuplicateReadEndsSet.size();
    }

    public boolean isEmpty() {
        return this.nonDuplicateReadEndsSet.isEmpty();
    }

    public void setToMarkQueueMinimumDistance(int toMarkQueueMinimumDistance) {
        this.toMarkQueueMinimumDistance = toMarkQueueMinimumDistance;
    }

    public int getToMarkQueueMinimumDistance() {
        return this.toMarkQueueMinimumDistance;
    }

    public boolean shouldBeInLocations(ReadEndsForMateCigar current) {
        return current.isPaired() && 0 == current.hasUnmapped;
    }

    public Set<ReadEnds> getLocations(ReadEndsForMateCigar current) {
        if (!this.shouldBeInLocations(current)) {
            throw new NotImplementedException();
        }
        Set<ReadEnds> locationSet = current.getReadEndSetForOpticalDuplicates();
        if (null == locationSet) {
            throw new PicardException("Locations was empty: unexpected error");
        }
        return locationSet;
    }

    public ReadEndsForMateCigar peek() {
        return this.nonDuplicateReadEndsSet.first();
    }

    private void updateDuplicationMetrics(ReadEndsForMateCigar duplicate, DuplicationMetrics metrics) {
        if (!duplicate.getRecord().getReadPairedFlag() || duplicate.getRecord().getMateUnmappedFlag()) {
            ++metrics.UNPAIRED_READ_DUPLICATES;
        } else {
            ++metrics.READ_PAIR_DUPLICATES;
        }
        ++this.numDuplicates;
    }

    public ReadEndsForMateCigar poll(SamRecordTrackingBuffer outputBuffer, SAMFileHeader header, OpticalDuplicateFinder opticalDuplicateFinder, LibraryIdGenerator libraryIdGenerator) {
        ReadEndsForMateCigar current = this.nonDuplicateReadEndsSet.pollFirst();
        if (current.isPaired()) {
            if (this.otherEndOfNonDuplicateReadEndsSet.contains(current)) {
                ReadEndsForMateCigar pair = (ReadEndsForMateCigar)this.otherEndOfNonDuplicateReadEndsSet.subSet(current, true, current, true).first();
                outputBuffer.setResultState(pair.getSamRecordIndex(), false);
                this.otherEndOfNonDuplicateReadEndsSet.remove(current);
            }
            if (null == this.tmpReadEnds) {
                this.tmpReadEnds = new ReadEndsForMateCigar(header, current.getSamRecordIndex(), opticalDuplicateFinder, current.libraryId);
                this.tmpReadEnds.read2Coordinate = -1;
                this.tmpReadEnds.read2ReferenceIndex = -1;
                this.tmpReadEnds.samRecordWithOrdinal = null;
            } else {
                this.tmpReadEnds.read1ReferenceIndex = current.read1ReferenceIndex;
                this.tmpReadEnds.read1Coordinate = current.read1Coordinate;
            }
            this.tmpReadEnds.orientation = current.orientation == 2 || current.orientation == 3 || current.orientation == 0 ? (byte)0 : 1;
            if (this.nonDuplicateReadEndsSet.contains(this.tmpReadEnds)) {
                NavigableSet<ReadEndsForMateCigar> sortedSet = this.nonDuplicateReadEndsSet.subSet(this.tmpReadEnds, true, this.tmpReadEnds, true);
                if (1 != sortedSet.size()) {
                    throw new PicardException("SortedSet should have size one (has size " + sortedSet.size() + " )");
                }
                ReadEndsForMateCigar duplicate = (ReadEndsForMateCigar)sortedSet.first();
                outputBuffer.setResultState(duplicate.getSamRecordIndex(), true);
                this.nonDuplicateReadEndsSet.remove(this.tmpReadEnds);
                this.updateDuplicationMetrics(duplicate, libraryIdGenerator.getMetricsByLibrary(LibraryIdGenerator.getLibraryName(header, duplicate.getRecord())));
            }
        }
        outputBuffer.setResultState(current.getSamRecordIndex(), false);
        return current;
    }

    public void add(ReadEndsForMateCigar other, SamRecordTrackingBuffer outputBuffer, DuplicationMetrics metrics) {
        PhysicalLocationForMateCigarSet locationSet = null;
        boolean addToLocationSet = true;
        ReadEndsForMateCigar duplicate = null;
        if (this.nonDuplicateReadEndsSet.contains(other)) {
            NavigableSet<ReadEndsForMateCigar> sortedSet = this.nonDuplicateReadEndsSet.subSet(other, true, other, true);
            if (1 != sortedSet.size()) {
                throw new PicardException("SortedSet should have size one (has size " + sortedSet.size() + " )");
            }
            ReadEndsForMateCigar current = (ReadEndsForMateCigar)sortedSet.first();
            String otherName = SAMUtils.getCanonicalRecordName(other.getRecord());
            String currentName = SAMUtils.getCanonicalRecordName(current.getRecord());
            int comparison = this.comparator.compare(current, other);
            if (currentName.equals(otherName)) {
                if (0 < comparison) {
                    this.nonDuplicateReadEndsSet.remove(current);
                    this.nonDuplicateReadEndsSet.add(other);
                    this.otherEndOfNonDuplicateReadEndsSet.add(current);
                    if (this.shouldBeInLocations(other)) {
                        locationSet = current.removeLocationSet();
                        locationSet.replace(current, other);
                        other.setLocationSet(locationSet);
                        addToLocationSet = false;
                    }
                } else {
                    this.otherEndOfNonDuplicateReadEndsSet.add(other);
                    if (this.shouldBeInLocations(current)) {
                        locationSet = current.getLocationSet();
                        addToLocationSet = false;
                    }
                }
            } else if (0 < comparison) {
                locationSet = this.shouldBeInLocations(current) ? current.removeLocationSet() : new PhysicalLocationForMateCigarSet();
                other.setLocationSet(locationSet);
                this.nonDuplicateReadEndsSet.remove(current);
                this.nonDuplicateReadEndsSet.add(other);
                if (this.otherEndOfNonDuplicateReadEndsSet.contains(current)) {
                    ReadEndsForMateCigar pair = (ReadEndsForMateCigar)this.otherEndOfNonDuplicateReadEndsSet.subSet(current, true, current, true).first();
                    this.otherEndOfNonDuplicateReadEndsSet.remove(current);
                    outputBuffer.setResultState(pair.getSamRecordIndex(), true);
                    this.updateDuplicationMetrics(pair, metrics);
                }
                duplicate = current;
            } else {
                if (this.shouldBeInLocations(current)) {
                    locationSet = current.getLocationSet();
                }
                duplicate = other;
            }
        } else {
            if (this.shouldBeInLocations(other)) {
                locationSet = new PhysicalLocationForMateCigarSet();
                other.setLocationSet(locationSet);
            }
            this.nonDuplicateReadEndsSet.add(other);
        }
        SAMRecord record = other.getRecord();
        if (record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag() && addToLocationSet) {
            if (null == locationSet) {
                throw new PicardException("location nonDuplicateReadEndsSet was null: " + record.getSAMString());
            }
            locationSet.add(other);
        }
        if (null != duplicate) {
            outputBuffer.setResultState(duplicate.getSamRecordIndex(), true);
            this.updateDuplicationMetrics(duplicate, metrics);
        }
    }

    class ReadEndsMCComparator
    implements Comparator<ReadEndsForMateCigar> {
        private final DuplicateScoringStrategy.ScoringStrategy duplicateScoringStrategy;

        public ReadEndsMCComparator(DuplicateScoringStrategy.ScoringStrategy duplicateScoringStrategy) {
            this.duplicateScoringStrategy = duplicateScoringStrategy;
        }

        @Override
        public int compare(ReadEndsForMateCigar lhs, ReadEndsForMateCigar rhs) {
            int retval = lhs.libraryId - rhs.libraryId;
            if (retval == 0) {
                retval = lhs.read1ReferenceIndex - rhs.read1ReferenceIndex;
            }
            if (retval == 0) {
                retval = lhs.read1Coordinate - rhs.read1Coordinate;
            }
            if (retval == 0) {
                retval = rhs.orientation - lhs.orientation;
            }
            if (retval == 0 && lhs.isPaired() != rhs.isPaired()) {
                return lhs.isPaired() ? -1 : 1;
            }
            if (retval == 0) {
                retval = lhs.hasUnmapped - rhs.hasUnmapped;
            }
            if (retval == 0) {
                retval = lhs.read2ReferenceIndex - rhs.read2ReferenceIndex;
            }
            if (retval == 0) {
                retval = lhs.read2Coordinate - rhs.read2Coordinate;
            }
            if (retval == 0) {
                retval = DuplicateScoringStrategy.compare(lhs.getRecord(), rhs.getRecord(), this.duplicateScoringStrategy, true);
            }
            if (retval == 0) {
                retval = lhs.getRecordReadName().compareTo(rhs.getRecordReadName());
            }
            if (retval == 0 && lhs.isPaired() && rhs.isPaired() && null != lhs.getSamRecordIndex()) {
                retval = lhs.getRecord().getFirstOfPairFlag() ? -1 : 1;
            }
            return retval;
        }
    }

    private class MarkQueueComparator
    implements Comparator<ReadEndsForMateCigar> {
        private MarkQueueComparator() {
        }

        @Override
        public int compare(ReadEndsForMateCigar lhs, ReadEndsForMateCigar rhs) {
            int retval = lhs.libraryId - rhs.libraryId;
            if (retval == 0) {
                retval = lhs.read1ReferenceIndex - rhs.read1ReferenceIndex;
            }
            if (retval == 0) {
                retval = lhs.read1Coordinate - rhs.read1Coordinate;
            }
            if (retval == 0) {
                retval = rhs.orientation - lhs.orientation;
            }
            if (retval == 0) {
                retval = lhs.read2ReferenceIndex - rhs.read2ReferenceIndex;
            }
            if (retval == 0) {
                retval = lhs.read2Coordinate - rhs.read2Coordinate;
            }
            return retval;
        }
    }
}

