/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import org.broad.igv.maf.MultipleAlignmentBlock;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;

public class MAFRenderer {
    public void renderGaps(List<MultipleAlignmentBlock.Gap> gaps, RenderContext context, Rectangle rect) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (locScale > 1.0) {
            return;
        }
        for (MultipleAlignmentBlock.Gap gap : gaps) {
            int pixelPosition = (int)((gap.position - origin) / locScale);
            Graphics2D g = context.getGraphic2DForColor(Color.BLACK);
            g.drawLine(pixelPosition, rect.y + rect.height - 5, pixelPosition, rect.y + rect.height);
            Rectangle textRect = new Rectangle(rect);
            textRect.x = pixelPosition - 6;
            textRect.width = 12;
            textRect.height = rect.height - 7;
            GraphicUtils.drawCenteredText(String.valueOf(gap.size), textRect, g);
        }
    }

    public void renderSequence(MultipleAlignmentBlock multipleAlignment, MultipleAlignmentBlock.Sequence alignedSequence, MultipleAlignmentBlock.Sequence reference, List<MultipleAlignmentBlock.Gap> gaps, RenderContext context, Rectangle trackRectangle, Track track) {
        Map<Character, Color> nucleotideColors = SequenceRenderer.getNucleotideColors();
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (locScale > 1.0) {
            return;
        }
        double pixelStart = ((double)multipleAlignment.getStart() - origin) / locScale;
        int w = Math.max(1, trackRectangle.width);
        int h = (int)Math.max(1.0, trackRectangle.getHeight() - 2.0);
        int y = (int)(trackRectangle.getY() + (trackRectangle.getHeight() - (double)h) / 2.0);
        Rectangle rect = new Rectangle((int)pixelStart, y, w, h);
        if (locScale < 1.0) {
            int pY = (int)rect.getY();
            int dY = (int)rect.getHeight();
            int dX = (int)(1.0 / locScale);
            Graphics2D g = context.getGraphics2D("SEQUENCE");
            if (dX >= 8) {
                Font f = FontManager.getFont(1, Math.min(dX, 12));
                g.setFont(f);
            }
            int windowStart = (int)origin - 1;
            int windowEnd = (int)context.getEndLocation() + 1;
            int start = Math.max(windowStart, multipleAlignment.getStart());
            int end = Math.min(windowEnd, multipleAlignment.getEnd());
            byte[] alignmentBytes = alignedSequence.getText().getBytes();
            byte[] refBytes = reference.getText().getBytes();
            for (int loc = start; loc < end; ++loc) {
                int pX0 = (int)(((double)loc - origin) / locScale);
                int idx = multipleAlignment.getGapAdjustedIndex(loc);
                int c = alignmentBytes[idx];
                char refBase = (char)refBytes[idx];
                boolean misMatch = Character.toUpperCase((char)c) != Character.toUpperCase(refBase);
                int charToDraw = misMatch || reference == alignedSequence ? c : 46;
                Color color = nucleotideColors.get(Character.valueOf((char)charToDraw));
                if (dX >= 8 && dY >= 12 || charToDraw == 46) {
                    if (charToDraw == 46) {
                        color = Color.LIGHT_GRAY;
                    } else if (color == null) {
                        color = Color.black;
                    }
                    g.setColor(color);
                    this.drawCenteredText(g, new char[]{charToDraw}, pX0, pY + 2, dX, dY - 2);
                    continue;
                }
                if (color == null) continue;
                g.setColor(color);
                g.fillRect(pX0, pY, dX - 1, dY);
            }
            if (gaps != null) {
                Graphics2D gapG = context.getGraphic2DForColor(Color.black);
                block1: for (MultipleAlignmentBlock.Gap gap : gaps) {
                    for (int idx = gap.startIdx; idx < gap.startIdx + gap.size; ++idx) {
                        if (alignmentBytes[idx] == 45) continue;
                        int pX0 = (int)((gap.position - origin) / locScale);
                        gapG.drawLine(pX0, pY, pX0, pY + dY);
                        continue block1;
                    }
                }
            }
        }
    }

    private void drawCenteredText(Graphics2D g, char[] chars, int x, int y, int w, int h) {
        FontMetrics fm = g.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h / 2 - descent / 2 + ascent / 2;
        g.drawChars(chars, 0, 1, msgX, msgY);
    }
}

