/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.List;
import org.broad.igv.feature.AminoAcid;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.Strand;

public class AminoAcidSequence {
    private final Strand strand;
    private final int start;
    private final List<AminoAcid> sequence;
    private boolean nonNullSequence;
    private final AminoAcidManager.CodonTableKey codonTableKey;

    public AminoAcidSequence(Strand strand, int startPosition, List<AminoAcid> sequence, AminoAcidManager.CodonTableKey codonTableKey) {
        this.strand = strand;
        this.start = startPosition;
        this.sequence = sequence;
        this.codonTableKey = codonTableKey;
        this.nonNullSequence = false;
        for (AminoAcid aa : sequence) {
            if (aa == null) continue;
            this.nonNullSequence = true;
            break;
        }
    }

    public Strand getStrand() {
        return this.strand;
    }

    public int getStart() {
        return this.start;
    }

    public List<AminoAcid> getSequence() {
        return this.sequence;
    }

    public boolean hasNonNullSequence() {
        return this.nonNullSequence;
    }

    public AminoAcidManager.CodonTableKey getCodonTableKey() {
        return this.codonTableKey;
    }
}

