/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class AbstractProgressLogger
implements ProgressLoggerInterface {
    private final int n;
    private final String verb;
    private final String noun;
    private long startTime;
    private final NumberFormat fmt = new DecimalFormat("#,###");
    private final NumberFormat timeFmt = new DecimalFormat("00");
    private long processed;
    private long lastStartTime;
    private String lastChrom;
    private int lastPos;

    protected AbstractProgressLogger(String noun, String verb, int n) {
        this.noun = noun;
        this.verb = verb;
        this.n = n;
        this.reset();
    }

    protected abstract void log(String ... var1);

    private synchronized void record() {
        long now = System.currentTimeMillis();
        long lastPeriodSeconds = (now - this.lastStartTime) / 1000L;
        this.lastStartTime = now;
        long seconds = (now - this.startTime) / 1000L;
        String elapsed = this.formatElapseTime(seconds);
        String period = this.pad(this.fmt.format(lastPeriodSeconds), 4);
        String processed = this.pad(this.fmt.format(this.processed), 13);
        String readInfo = this.lastChrom == null ? "*/*" : this.lastChrom + ":" + this.fmt.format(this.lastPos);
        long n = this.processed % (long)this.n == 0L ? (long)this.n : this.processed % (long)this.n;
        this.log(this.verb, " ", processed, " " + this.noun + ".  Elapsed time: ", elapsed, "s.  Time for last ", this.fmt.format(n), ": ", period, "s.  Last read position: ", readInfo);
    }

    public synchronized boolean log() {
        if (this.processed % (long)this.n != 0L) {
            this.record();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean record(String chrom, int pos) {
        this.lastChrom = chrom;
        this.lastPos = pos;
        if (this.lastStartTime == -1L) {
            this.lastStartTime = System.currentTimeMillis();
        }
        if (++this.processed % (long)this.n == 0L) {
            this.record();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean record(SAMRecord rec) {
        if ("*".equals(rec.getReferenceName())) {
            return this.record(null, 0);
        }
        return this.record(rec.getReferenceName(), rec.getAlignmentStart());
    }

    @Override
    public boolean record(SAMRecord ... recs) {
        boolean triggered = false;
        for (SAMRecord rec : recs) {
            triggered = this.record(rec) || triggered;
        }
        return triggered;
    }

    public synchronized long getCount() {
        return this.processed;
    }

    public long getElapsedSeconds() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    @Override
    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.processed = 0L;
        this.lastStartTime = -1L;
        this.lastChrom = null;
        this.lastPos = 0;
    }

    private String pad(String in, int length) {
        while (in.length() < length) {
            in = " " + in;
        }
        return in;
    }

    private String formatElapseTime(long seconds) {
        long s = seconds % 60L;
        long allMinutes = seconds / 60L;
        long m = allMinutes % 60L;
        long h = allMinutes / 60L;
        return this.timeFmt.format(h) + ":" + this.timeFmt.format(m) + ":" + this.timeFmt.format(s);
    }
}

