/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import picard.PicardException;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.util.BasicInputParser;

public class PosFileReader
extends AbstractIlluminaPositionFileReader {
    private final BasicInputParser parser;

    public PosFileReader(File posFile) {
        super(posFile);
        this.parser = new BasicInputParser(true, posFile);
    }

    @Override
    protected AbstractIlluminaPositionFileReader.PositionInfo unsafeNextInfo() {
        String[] strVals = (String[])this.parser.next();
        if (strVals.length != 2) {
            throw new PicardException("Pos file number of values != 2, found (" + strVals.length + ")" + this.makeExceptionMsg());
        }
        try {
            float xVal = Float.parseFloat(strVals[0]);
            float yVal = Float.parseFloat(strVals[1]);
            if (xVal < 0.0f || yVal < 0.0f) {
                throw new NumberFormatException("X and Y pos values cannot be negative!");
            }
            return new AbstractIlluminaPositionFileReader.PositionInfo(xVal, yVal, this.getLane(), this.getTile());
        }
        catch (NumberFormatException nfe) {
            throw new PicardException("Bad x or y value in " + this.makeExceptionMsg(), nfe);
        }
    }

    @Override
    protected String makeExceptionMsg() {
        return "pos file( " + this.parser.getFileName() + " ) on line number( " + this.parser.getCurrentLineNumber() + " ) with current line = " + this.parser.getCurrentLine();
    }

    @Override
    public boolean hasNext() {
        return this.parser.hasNext();
    }

    @Override
    public void close() {
        CloserUtil.close(this.parser);
    }
}

