/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.blat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import org.broad.igv.Globals;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.blat.BlatQueryWindow;

public class BlatClient {
    static int sleepTime = 15000;
    static String hgsid;
    static long lastQueryTime;

    public static void main(String[] args) throws IOException {
        if (args.length != 6) {
            BlatClient.Usage();
            System.exit(255);
        }
        String org = args[0];
        String db = args[1];
        String searchType = args[2];
        String sortOrder = args[3];
        String outputType = args[4];
        String userSeq = args[5];
        BlatClient.blat(org, db, searchType, sortOrder, outputType, userSeq);
    }

    static void Usage() {
        System.out.println("usage: BlatBot <organism> <db> <searchType> <sortOrder>");
        System.out.println(" <outputType> <querySequence>");
        System.out.println("\tSpecify organism using the common name with first letter");
        System.out.println("capitalized.");
        System.out.println("\te.g. Human, Mouse, Rat etc.");
        System.out.println("\tDb is database or assembly name e.g hg17, mm5, rn3 etc.");
        System.out.println("\tsearchType can be BLATGuess, DNA, RNA, transDNA or transRNA");
        System.out.println("\tsortOrder can be query,score; query,start; chrom,score");
        System.out.println("\tchrom,start; score.");
        System.out.println("\toutputType can be pslNoHeader, psl or hyperlink.");
        System.out.println("\tblats will be run in groups of $batchCount sequences, all");
    }

    public static List<String> blat(String org, String db, String userSeq) throws IOException {
        String searchType = "DNA";
        String sortOrder = "query,score";
        String outputType = "psl";
        List<String> blatRecords = BlatClient.blat(org, db, searchType, sortOrder, outputType, userSeq);
        return blatRecords;
    }

    public static List<String> blat(String org, String db, String searchType, String sortOrder, String outputType, String userSeq) throws IOException {
        long dt;
        if (searchType.equals("BLATGuess")) {
            searchType = "Blat's Guess";
        } else if (searchType.equals("transDNA")) {
            searchType = "translated DNA";
        } else if (searchType.equals("transRNA")) {
            searchType = "translated RNA";
        } else if (!searchType.equals("DNA") && !searchType.equals("RNA")) {
            System.out.println("ERROR: have not specified an acceptable search type - it should be BLATGuess, transDNA, transRNA, DNA or RNA.");
            BlatClient.Usage();
            System.exit(255);
        }
        if (outputType.equals("pslNoHeader")) {
            outputType = "psl no header";
        } else if (!outputType.equals("psl") && !outputType.equals("hyperlink")) {
            System.out.println("ERROR: have not specified an acceptable output type - it should be pslNoHeader, psl or hyperlink.");
            BlatClient.Usage();
            System.exit(255);
        }
        String $url = PreferencesManager.getPreferences().get("BLAT_URL");
        String urlString = $url + "?org=" + org + "&db=" + db + "&type=" + searchType + "&sort=" + sortOrder + "&output=" + outputType;
        if (hgsid != null) {
            urlString = urlString + "&hgsid=" + hgsid;
        }
        if ((dt = System.currentTimeMillis() - lastQueryTime) < (long)sleepTime) {
            try {
                Thread.sleep(dt);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        lastQueryTime = System.currentTimeMillis();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userSeq", userSeq);
        String result = HttpUtils.getInstance().doPost(HttpUtils.createURL(urlString), params);
        return BlatClient.parseResult(result);
    }

    static List<String> parseResult(String result) throws IOException {
        String line;
        ArrayList<String> records = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(result));
        int headerLineCount = 0;
        boolean header = false;
        boolean hgsidFound = false;
        boolean pslSectionFound = false;
        while ((line = br.readLine()) != null) {
            if (line.contains("hgsid=") && !hgsidFound) {
                int startIDX = line.indexOf("hgsid=") + 6;
                String sub = line.substring(startIDX);
                int endIDX = sub.indexOf("\"");
                if (endIDX < 0) {
                    endIDX = sub.indexOf("&");
                }
                if (endIDX > 0) {
                    hgsid = sub.substring(0, endIDX);
                    hgsidFound = true;
                }
            }
            if (line.trim().startsWith("<TT><PRE>")) {
                pslSectionFound = true;
                if (line.contains("psLayout") && line.contains("version")) {
                    header = true;
                    ++headerLineCount;
                }
            } else if (line.trim().startsWith("</PRE></TT>")) break;
            if (!pslSectionFound) continue;
            if (header && headerLineCount < 6) {
                ++headerLineCount;
                continue;
            }
            String[] tokens = Globals.whitespacePattern.split(line);
            if (tokens.length != 21) {
                System.err.println("Unexpected number of fields (" + tokens.length + ")");
                System.err.println(line);
                continue;
            }
            records.add(line);
        }
        return records;
    }

    public static void doBlatQuery(String chr, int start, int end, Strand strand) {
        if (end - start > 8000) {
            MessageUtils.showMessage("BLAT searches are limited to 8kb.  Please try a shorter sequence.");
            return;
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte[] seqBytes = genome.getSequence(chr, start, end);
        String userSeq = new String(seqBytes);
        if (strand == Strand.NEGATIVE) {
            userSeq = SequenceTrack.getReverseComplement(userSeq);
        }
        BlatClient.doBlatQuery(userSeq);
    }

    public static void doBlatQuery(final String userSeq) {
        LongRunningTask.submit(new NamedRunnable(){

            @Override
            public String getName() {
                return "Blat sequence";
            }

            @Override
            public void run() {
                try {
                    Genome genome = IGV.hasInstance() ? GenomeManager.getInstance().getCurrentGenome() : null;
                    PSLCodec codec = new PSLCodec(genome, true);
                    String db = genome.getId();
                    String species = genome.getSpecies();
                    if (species == null) {
                        MessageUtils.showMessage("Cannot determine species name for genome: " + genome.getDisplayName());
                        return;
                    }
                    List<String> tokensList = BlatClient.blat(species, db, userSeq);
                    ArrayList<PSLRecord> features = new ArrayList<PSLRecord>(tokensList.size());
                    for (String tokens : tokensList) {
                        PSLRecord f = codec.decode(tokens);
                        if (f == null) continue;
                        features.add(f);
                    }
                    if (features.isEmpty()) {
                        MessageUtils.showMessage("No features found");
                    } else {
                        FeatureCollectionSource source = new FeatureCollectionSource(features, genome);
                        FeatureTrack newTrack = new FeatureTrack("Blat", "Blat", (FeatureSource)source);
                        newTrack.setUseScore(true);
                        newTrack.setDisplayMode(Track.DisplayMode.SQUISHED);
                        IGV.getInstance().getTrackPanel("FeaturePanel").addTrack(newTrack);
                        BlatQueryWindow win = new BlatQueryWindow(IGV.getMainFrame(), userSeq, features);
                        win.setVisible(true);
                    }
                }
                catch (IOException e1) {
                    MessageUtils.showErrorMessage("Error running blat", e1);
                }
            }
        });
    }

    public static JMenuItem getMenuItem() {
        JMenuItem menuItem = new JMenuItem("BLAT ...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String blatSequence = MessageUtils.showInputDialog("Enter sequence to blat:");
                if (blatSequence != null) {
                    BlatClient.doBlatQuery(blatSequence);
                }
            }
        });
        return menuItem;
    }

    static {
        lastQueryTime = 0L;
    }
}

