/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.util.CompressionUtils;

public class BedToPeaks {
    private static Map<String, String> colorMap;
    private static CompressionUtils compressionUtils;

    public BedToPeaks() {
        compressionUtils = new CompressionUtils();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void createBinaryPeakFile(String factor, List<Integer> times, List<File> bedFiles, File outputDir, String root) throws IOException {
        c = BedToPeaks.colorMap.get(factor);
        if (c == null) {
            System.out.println("No color found for " + factor);
            c = "0,0,150";
        }
        peeksFileName = factor + ".peak.bin";
        peeksFile = new File(outputDir, peeksFileName);
        readers = new BufferedReader[bedFiles.size()];
        peakWriter = null;
        indexPosition = 0L;
        try {
            for (i = 0; i < bedFiles.size(); ++i) {
                readers[i] = new BufferedReader(new FileReader(bedFiles.get(i)));
            }
            peakWriter = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(peeksFile)));
            chrIndex = new LinkedHashMap<String, Long>();
            line = new String[readers.length];
            peakWriter.writeLong(0L);
            peakWriter.writeString("track name=" + factor + " sample=" + factor + " viewLimits=0:100 useScore=1 color=" + c);
            nTimePoints = times.size();
            peakWriter.writeInt(nTimePoints);
            for (i = 0; i < times.size(); ++i) {
                peakWriter.writeInt(times.get(i));
            }
            tdf = root + "/tdf/compressed/" + factor + ".merged.bam.tdf";
            peakWriter.writeString(tdf);
            for (int t : times) {
                peakWriter.writeString(root + "/tdf/timecourses/" + factor + "_" + t + "/" + factor + "_" + t + ".merged.bam.tdf");
            }
            currentChr = "";
            records = new ArrayList<PeakRecord>(20000);
            while (true) {
                for (i = 0; i < readers.length; ++i) {
                    line[i] = readers[i].readLine();
                    if (line[i] != null) continue;
                    if (records.size() <= 0) break;
                    BedToPeaks.writeChromosomeData((LittleEndianOutputStream)peakWriter, chrIndex, currentChr, records);
                    break;
                }
                if (line[0].startsWith("#") || line[0].startsWith("track")) ** continue;
                tokens = line[0].split("\t");
                chr = tokens[0];
                if (!chr.equals(currentChr) && records.size() > 0) {
                    BedToPeaks.writeChromosomeData((LittleEndianOutputStream)peakWriter, chrIndex, currentChr, records);
                }
                if (chr == null) break;
                currentChr = chr;
                start = Integer.parseInt(tokens[1]);
                end = Integer.parseInt(tokens[2]);
                score = Float.parseFloat(tokens[4]);
                timeScores = new float[nTimePoints];
                for (i = 0; i < nTimePoints; ++i) {
                    tokens = line[i + 1].split("\t");
                    if (!tokens[0].equals(chr) || Integer.parseInt(tokens[1]) != start || Integer.parseInt(tokens[2]) != end) {
                        throw new RuntimeException("Unordered files");
                    }
                    timeScores[i] = Float.parseFloat(tokens[4]);
                }
                records.add(new PeakRecord(start, end, score, timeScores));
            }
            indexPosition = peakWriter.getWrittenCount();
            peakWriter.writeInt(chrIndex.size());
            for (Map.Entry<String, Long> entry : chrIndex.entrySet()) {
                peakWriter.writeString(entry.getKey());
                peakWriter.writeLong(entry.getValue());
            }
        }
        finally {
            if (peakWriter != null) {
                peakWriter.close();
                BedToPeaks.writeIndexPosition(peeksFile, indexPosition);
            }
            for (BufferedReader reader : readers) {
                reader.close();
            }
        }
    }

    private static void writeChromosomeData(LittleEndianOutputStream peakWriter, LinkedHashMap<String, Long> chrIndex, String currentChr, List<PeakRecord> records) throws IOException {
        chrIndex.put(currentChr, peakWriter.getWrittenCount());
        BufferedByteWriter buffer = new BufferedByteWriter(100000);
        buffer.putNullTerminatedString(currentChr);
        buffer.putInt(records.size());
        for (PeakRecord record : records) {
            buffer.putInt(record.start);
            buffer.putInt(record.end);
            buffer.putFloat(record.score);
            for (int i = 0; i < record.timeScores.length; ++i) {
                buffer.putFloat(record.timeScores[i]);
            }
        }
        byte[] bytes = buffer.getBytes();
        bytes = compressionUtils.compress(bytes);
        peakWriter.writeInt(bytes.length);
        peakWriter.write(bytes);
        records.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeIndexPosition(File file, long indexPosition) throws IOException {
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(file, "rw");
            raf.getChannel().position(0L);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(indexPosition);
            raf.write(buffer.getBytes());
            raf.close();
        }
    }

    public static void convertAll(File rootDir, File destDir, String root) throws IOException {
        String factor;
        int[] allTimes = new int[]{0, 30, 60, 120};
        File factorFile = new File(rootDir, "factors.txt");
        BufferedReader reader = new BufferedReader(new FileReader(factorFile));
        while ((factor = reader.readLine()) != null) {
            factor = factor.trim();
            ArrayList<File> bedFiles = new ArrayList<File>();
            File bedFile = new File(rootDir, factor + ".peaks.filtered.by.fold.real.sorted.bed");
            if (bedFile.exists()) {
                bedFiles.add(bedFile);
            } else {
                System.out.println("Can't find " + bedFile.getName());
            }
            ArrayList<Integer> times = new ArrayList<Integer>();
            for (int i = 0; i < allTimes.length; ++i) {
                bedFile = new File(rootDir, factor + "_" + allTimes[i] + ".peaks.filtered.by.fold.real.sorted.bed");
                if (bedFile.exists()) {
                    bedFiles.add(bedFile);
                    times.add(allTimes[i]);
                    continue;
                }
                System.out.println("Can't find " + bedFile.getName());
            }
            BedToPeaks.createBinaryPeakFile(factor, times, bedFiles, destDir, root);
        }
        reader.close();
    }

    public static Map<String, String> loadColors(String file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split("\t");
            map.put(tokens[0], tokens[1]);
        }
        reader.close();
        return map;
    }

    public static void main(String[] args) throws IOException {
        File inputDir = new File(args[0] + "bed/");
        File destDir = new File(args[0] + args[1]);
        String root = args[2];
        colorMap = BedToPeaks.loadColors(args[0] + "colors.txt");
        BedToPeaks.convertAll(inputDir, destDir, root);
    }

    static class PeakRecord {
        int start;
        int end;
        float score;
        float[] timeScores;

        PeakRecord(int start, int end, float score, float[] timeScores) {
            this.start = start;
            this.end = end;
            this.score = score;
            this.timeScores = timeScores;
        }
    }
}

