/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.bedpe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.xml.bind.annotation.XmlAttribute;
import org.broad.igv.feature.bedpe.BedPEFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class InteractionTrack
extends AbstractTrack {
    @XmlAttribute
    Direction direction = Direction.DOWN;
    @XmlAttribute
    int thickness = 1;
    @XmlAttribute
    boolean hideLargeFeatures = false;
    private Map<String, List<BedPEFeature>> featureMap;
    private PEArcRenderer renderer;

    public InteractionTrack(ResourceLocator locator, List<BedPEFeature> featureList, Genome genome) {
        super(locator);
        this.init(featureList, genome);
        this.renderer = new PEArcRenderer();
        this.setHeight(250, true);
        this.setColor(new Color(180, 25, 137));
    }

    private void init(List<BedPEFeature> featureList, Genome genome) {
        this.featureMap = new HashMap<String, List<BedPEFeature>>();
        Collections.sort(featureList, (o1, o2) -> o1.getStart() - o2.getStart());
        for (BedPEFeature f : featureList) {
            String key = f.chr1.equals(f.chr2) ? (genome == null ? f.chr1 : genome.getCanonicalChrName(f.chr1)) : "OTHER";
            List<BedPEFeature> features = this.featureMap.get(key);
            if (features == null) {
                features = new ArrayList<BedPEFeature>();
                this.featureMap.put(key, features);
            }
            features.add(f);
        }
        if (this.featureMap.containsKey("OTHER")) {
            this.featureMap.put("All", this.createWGFeatures(this.featureMap.get("OTHER"), genome));
        }
    }

    private List<BedPEFeature> createWGFeatures(List<BedPEFeature> features, Genome genome) {
        ArrayList<BedPEFeature> wgFeatures = new ArrayList<BedPEFeature>(features.size());
        for (BedPEFeature f : features) {
            BedPEFeature wgFeature = new BedPEFeature();
            wgFeature.chr1 = "All";
            wgFeature.chr2 = "All";
            wgFeature.name = f.name;
            wgFeature.score = f.score;
            wgFeature.start1 = genome.getGenomeCoordinate(f.chr1, f.start1);
            wgFeature.end1 = genome.getGenomeCoordinate(f.chr1, f.end1);
            wgFeature.start2 = genome.getGenomeCoordinate(f.chr1, f.start2);
            wgFeature.end2 = genome.getGenomeCoordinate(f.chr1, f.end2);
            wgFeatures.add(wgFeature);
        }
        return wgFeatures;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return true;
    }

    @Override
    public void load(ReferenceFrame frame) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RenderContext context, Rectangle rect) {
        Graphics2D g2d = context.getGraphics();
        Rectangle clip = new Rectangle(g2d.getClip().getBounds());
        g2d.setClip(rect.intersection(clip.getBounds()));
        context.clearGraphicsCache();
        try {
            String chr = context.getReferenceFrame().getChrName();
            List<BedPEFeature> features = this.featureMap.get(chr);
            if (features != null) {
                this.renderer.render(features, context, rect, this);
            }
            context.clearGraphicsCache();
        }
        finally {
            g2d.setClip(clip);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        menu.add(TrackMenuUtils.getTrackRenameItem(Collections.singleton(this)));
        JMenuItem item = new JMenuItem("Set Track Height...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackHeight(Collections.singleton(this)));
        menu.add(item);
        item = new JMenuItem("Set Track Color...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackColor(Collections.singleton(this)));
        menu.add(item);
        item = new JMenuItem("Toggle Arc Direction");
        item.addActionListener(evt -> {
            this.direction = this.direction == Direction.UP ? Direction.DOWN : Direction.UP;
            IGV.getInstance().repaint();
        });
        menu.add(item);
        item = new JMenuItem("Set Line Thickness...");
        item.addActionListener(e -> {
            String t = MessageUtils.showInputDialog("Line thickness", String.valueOf(this.thickness));
            if (t != null) {
                try {
                    this.thickness = Integer.parseInt(t);
                    IGV.getInstance().repaint();
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showErrorMessage("Line thickness must be an integer", e1);
                }
            }
        });
        menu.add(item);
        return menu;
    }

    static class SagittusEstimate {
        static final double[] coa = new double[]{0.01570925532366355, 0.15838444032453644, 0.3249196962329063, 0.5095254494944288, 0.7265425280053609, 0.9999999999999999};
        static final double[] theta = new double[]{0.031415926535897934, 0.3141592653589793, 0.6283185307179586, 0.9424777960769379, 1.2566370614359172, 1.5707963267948966};

        SagittusEstimate() {
        }

        static double estimateTheta(double x) {
            int idx;
            for (idx = 0; idx < coa.length && !(coa[idx] > x); ++idx) {
            }
            double left = idx == 0 ? 0.0 : coa[idx - 1];
            double right = idx < coa.length ? coa[idx] : 1.0;
            double r = (x - left) / (right - left);
            double thetaLeft = idx == 0 ? 0.0 : theta[idx - 1];
            double thetaRight = idx < theta.length ? theta[idx] : 1.5707963267948966;
            return thetaLeft + r * (thetaRight - thetaLeft);
        }

        static void generateTable(String[] args) {
            for (double theta = 0.3141592653589793; theta <= 1.5707963267948966; theta += 0.3141592653589793) {
                double num = 1.0 - Math.cos(theta);
                double denom = Math.sin(theta);
                double coa = num / denom;
                System.out.println(coa + "\t" + theta);
            }
        }
    }

    public class PEArcRenderer {
        private Map<Color, Color> alphaColors = new HashMap<Color, Color>();
        double theta = Math.toRadians(45.0);
        double sinTheta = Math.sin(this.theta);
        double cosTheta = Math.cos(this.theta);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(List<BedPEFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
            double origin = context.getOrigin();
            double locScale = context.getScale();
            Graphics2D g = (Graphics2D)context.getGraphics().create();
            Color trackColor = track.getColor();
            try {
                for (BedPEFeature feature : featureList) {
                    Color fcolor;
                    double pixelStart = ((double)feature.getStart() - origin) / locScale;
                    double pixelEnd = ((double)feature.getEnd() - origin) / locScale;
                    double width = pixelEnd - pixelStart;
                    if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX())) continue;
                    int s = (feature.start1 + feature.end1) / 2;
                    int e = (feature.start2 + feature.end2) / 2;
                    double ps = ((double)s - origin) / locScale;
                    double pe = ((double)e - origin) / locScale;
                    Color color = fcolor = feature.color == null ? trackColor : feature.color;
                    if (fcolor != null && width > (double)trackRectangle.width) {
                        fcolor = this.getAlphaColor(fcolor);
                    }
                    if (fcolor != null) {
                        g.setColor(fcolor);
                    }
                    if (feature.thickness > 1) {
                        g.setStroke(new BasicStroke(feature.thickness));
                    }
                    this.drawArc(g, trackRectangle, track, ps, pe);
                }
            }
            finally {
                g.dispose();
            }
        }

        private Color getAlphaColor(Color fcolor) {
            Color ac = this.alphaColors.get(fcolor);
            if (ac == null) {
                float[] rgb = new float[3];
                rgb = fcolor.getRGBColorComponents(rgb);
                ac = new Color(rgb[0], rgb[1], rgb[2], 0.1f);
                this.alphaColors.put(fcolor, ac);
            }
            return ac;
        }

        private void drawArc(Graphics2D g, Rectangle trackRectangle, Track track, double x1, double x2) {
            int w;
            double pixelStart = Math.min(x1, x2);
            double pixelEnd = Math.max(x1, x2);
            if (InteractionTrack.this.thickness > 1) {
                g.setStroke(new BasicStroke(InteractionTrack.this.thickness));
            }
            if ((w = (int)(pixelEnd - pixelStart)) < 3) {
                w = 3;
                pixelStart -= 1.0;
            }
            double a = w / 2;
            double r = a / this.sinTheta;
            double b = this.cosTheta * r;
            double x = pixelStart + a;
            int trackBaseLine = trackRectangle.y + trackRectangle.height;
            double y = InteractionTrack.this.direction == Direction.UP ? (double)trackBaseLine + b : (double)trackRectangle.y - b;
            double angleSt = InteractionTrack.this.direction == Direction.UP ? 90.0 - Math.toDegrees(this.theta) : 270.0 - Math.toDegrees(this.theta);
            double ext = Math.toDegrees(2.0 * this.theta);
            Arc2D.Double arcPath = new Arc2D.Double();
            arcPath.setArcByCenter(x, y, r, angleSt, ext, 0);
            g.draw(arcPath);
        }
    }

    static enum Direction {
        UP,
        DOWN;

    }
}

