/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.awt.Color;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import org.broad.igv.Globals;
import org.broad.igv.feature.SeqLenAndBinnedPairs;
import org.broad.igv.feature.SeqLenAndPairs;
import org.broad.igv.feature.basepair.BasePairFeature;

public class BasePairFileUtils {
    static LinkedList<BasePairFeature> transformArcs(LinkedList<BasePairFeature> arcs, int seqLen, int newLeft, String strand) {
        LinkedList<BasePairFeature> transArcs = new LinkedList<BasePairFeature>();
        for (BasePairFeature arc : arcs) {
            int endRight;
            int endLeft;
            int startRight;
            int startLeft;
            String chr = arc.getChr();
            int colorIndex = arc.getColorIndex();
            if (strand == "+") {
                startLeft = arc.getStartLeft() + newLeft - 1;
                startRight = arc.getStartRight() + newLeft - 1;
                endLeft = arc.getEndLeft() + newLeft - 1;
                endRight = arc.getEndRight() + newLeft - 1;
            } else if (strand == "-") {
                startLeft = seqLen - arc.getEndRight() + newLeft;
                startRight = seqLen - arc.getEndLeft() + newLeft;
                endLeft = seqLen - arc.getStartRight() + newLeft;
                endRight = seqLen - arc.getStartLeft() + newLeft;
            } else {
                throw new RuntimeException("Unrecognized strand (options: \"+\",\"-\")");
            }
            BasePairFeature transArc = new BasePairFeature(chr, startLeft, startRight, endLeft, endRight, colorIndex);
            transArcs.add(transArc);
        }
        return transArcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SeqLenAndPairs loadDotBracket(String inFile) throws FileNotFoundException, IOException {
        ArrayList<Point> pairs = new ArrayList<Point>();
        int seqLen = 0;
        try (BufferedReader br = null;){
            int i;
            String nextLine;
            br = new BufferedReader(new FileReader(inFile));
            String struct = "";
            while ((nextLine = br.readLine()) != null) {
                String s;
                if (nextLine.startsWith(">") || nextLine.startsWith("#") || (s = nextLine.trim()).chars().allMatch(Character::isLetter)) continue;
                struct = struct + s;
            }
            String leftBrackets = "([{<";
            String rightBrackets = ")]}>";
            ArrayList openIndices = new ArrayList();
            for (i = 0; i < leftBrackets.length(); ++i) {
                openIndices.add(new LinkedList());
            }
            for (i = 0; i < struct.length(); ++i) {
                int n = leftBrackets.indexOf(struct.charAt(i));
                int k = rightBrackets.indexOf(struct.charAt(i));
                if (n >= 0) {
                    ((LinkedList)openIndices.get(n)).add(i);
                    continue;
                }
                if (k < 0) continue;
                int left = i + 1;
                int right = (Integer)((LinkedList)openIndices.get(k)).pollLast() + 1;
                pairs.add(new Point(left, right));
            }
            seqLen = struct.length();
        }
        return new SeqLenAndPairs(seqLen, pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SeqLenAndPairs loadConnectTable(String inFile) throws FileNotFoundException, IOException {
        ArrayList<Point> pairs = new ArrayList<Point>();
        int seqLen = 0;
        try (BufferedReader br = null;){
            String nextLine;
            br = new BufferedReader(new FileReader(inFile));
            seqLen = Integer.parseInt(Globals.whitespacePattern.split(br.readLine().trim())[0]);
            for (int n = 1; (nextLine = br.readLine()) != null && n <= seqLen; ++n) {
                String[] s = Globals.whitespacePattern.split(nextLine.trim());
                int left = Integer.parseInt(s[0]);
                int right = Integer.parseInt(s[4]);
                if (right <= left) continue;
                pairs.add(new Point(left, right));
            }
        }
        return new SeqLenAndPairs(seqLen, pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SeqLenAndBinnedPairs loadPairingProb(String inFile) throws FileNotFoundException, IOException {
        int i;
        ArrayList<ArrayList<Point>> binnedPairs = new ArrayList<ArrayList<Point>>();
        int seqLen = 0;
        double[] probThresh = new double[]{0.1, 0.3, 0.8};
        double[] negLogTenProbThresh = new double[]{0.0, 0.0, 0.0};
        for (i = 0; i < probThresh.length; ++i) {
            negLogTenProbThresh[i] = -Math.log10(probThresh[i]);
        }
        for (i = 0; i < probThresh.length; ++i) {
            binnedPairs.add(new ArrayList());
        }
        try (BufferedReader br = null;){
            String nextLine;
            br = new BufferedReader(new FileReader(inFile));
            seqLen = Integer.parseInt(Globals.whitespacePattern.split(br.readLine().trim())[0]);
            br.readLine();
            while ((nextLine = br.readLine()) != null) {
                String[] s = Globals.whitespacePattern.split(nextLine.trim());
                int left = Integer.parseInt(s[0]);
                int right = Integer.parseInt(s[1]);
                double negLogTenProb = Double.parseDouble(s[2]);
                int binIndex = -1;
                for (int i2 = probThresh.length - 1; i2 >= 0; --i2) {
                    if (!(negLogTenProb <= negLogTenProbThresh[i2])) continue;
                    binIndex = i2;
                    break;
                }
                if (binIndex == -1) continue;
                binnedPairs.get(binIndex).add(new Point(left, right));
            }
        }
        return new SeqLenAndBinnedPairs(seqLen, binnedPairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBasePairFile(String bpFile, ArrayList<Color> colors, ArrayList<String> colorLabels, ArrayList<LinkedList<BasePairFeature>> groupedArcs) throws IOException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(bpFile)));
            for (int i = 0; i < colors.size(); ++i) {
                Color color = colors.get(i);
                String label = "";
                try {
                    label = colorLabels.get(i);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                pw.println("color:\t" + color.getRed() + "\t" + color.getGreen() + "\t" + color.getBlue() + "\t" + label);
            }
            int colorIndex = 0;
            for (LinkedList<BasePairFeature> colorGroup : groupedArcs) {
                for (BasePairFeature arc : colorGroup) {
                    pw.println(arc.toString() + "\t" + colorIndex);
                }
                ++colorIndex;
            }
        }
    }

    static LinkedList<BasePairFeature> pairsToHelices(ArrayList<Point> pairs, String chromosome) {
        ArrayList<Point> bps = new ArrayList<Point>(pairs);
        LinkedList helixPairGroups = new LinkedList();
        while (bps.size() > 0) {
            int k;
            ArrayList<Point> tmpBps;
            Point bp = bps.get(0);
            LinkedList<Point> helixPairs = new LinkedList<Point>();
            boolean[] blArray = new boolean[bps.size()];
            helixPairs.add(bp);
            blArray[0] = true;
            boolean endOfList = false;
            int i = 1;
            int skippedCount = 0;
            if (i < bps.size()) {
                while (bps.get((int)i).x == bp.x) {
                    ++skippedCount;
                    if (++i < bps.size()) continue;
                    endOfList = true;
                    break;
                }
            } else {
                endOfList = true;
            }
            while (i < bps.size()) {
                if (bps.get((int)i).x - bp.x > 1) {
                    helixPairGroups.add(helixPairs);
                    tmpBps = new ArrayList();
                    for (k = 0; k < bps.size(); ++k) {
                        if (blArray[k]) continue;
                        tmpBps.add(bps.get(k));
                    }
                    bps = tmpBps;
                    break;
                }
                if (bps.get((int)i).y - bp.y == -1) {
                    bp = bps.get(i);
                    helixPairs.add(bp);
                    blArray[i] = true;
                }
                if (++i < bps.size()) continue;
                endOfList = true;
                break;
            }
            if (!endOfList) continue;
            helixPairGroups.add(helixPairs);
            tmpBps = new ArrayList<Point>();
            for (k = 0; k < bps.size(); ++k) {
                if (blArray[k]) continue;
                tmpBps.add(bps.get(k));
            }
            bps = tmpBps;
        }
        LinkedList<BasePairFeature> helices = new LinkedList<BasePairFeature>();
        for (LinkedList linkedList : helixPairGroups) {
            int startLeft = Integer.MAX_VALUE;
            int startRight = 0;
            int endLeft = Integer.MAX_VALUE;
            int endRight = 0;
            for (Point pair : linkedList) {
                if (pair.x < startLeft) {
                    startLeft = pair.x;
                }
                if (pair.x > startRight) {
                    startRight = pair.x;
                }
                if (pair.y < endLeft) {
                    endLeft = pair.y;
                }
                if (pair.y <= endRight) continue;
                endRight = pair.y;
            }
            helices.add(new BasePairFeature(chromosome, startLeft, startRight, endLeft, endRight, 0));
        }
        return helices;
    }

    public static void dotBracketToBasePairFile(String inFile, String bpFile, String chromosome, String strand, int left) throws FileNotFoundException, IOException {
        SeqLenAndPairs s = BasePairFileUtils.loadDotBracket(inFile);
        ArrayList<Point> pairs = s.pairs;
        int seqLen = s.seqLen;
        LinkedList<BasePairFeature> arcs = BasePairFileUtils.pairsToHelices(pairs, chromosome);
        arcs = BasePairFileUtils.transformArcs(arcs, seqLen, left, strand);
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.black);
        ArrayList<LinkedList<BasePairFeature>> groupedArcs = new ArrayList<LinkedList<BasePairFeature>>();
        groupedArcs.add(arcs);
        BasePairFileUtils.writeBasePairFile(bpFile, colors, null, groupedArcs);
    }

    public static void connectTableToBasePairFile(String inFile, String bpFile, String chromosome, String strand, int left) throws FileNotFoundException, IOException {
        SeqLenAndPairs s = BasePairFileUtils.loadConnectTable(inFile);
        ArrayList<Point> pairs = s.pairs;
        int seqLen = s.seqLen;
        LinkedList<BasePairFeature> arcs = BasePairFileUtils.pairsToHelices(pairs, chromosome);
        arcs = BasePairFileUtils.transformArcs(arcs, seqLen, left, strand);
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.black);
        ArrayList<LinkedList<BasePairFeature>> groupedArcs = new ArrayList<LinkedList<BasePairFeature>>();
        groupedArcs.add(arcs);
        BasePairFileUtils.writeBasePairFile(bpFile, colors, null, groupedArcs);
    }

    public static void pairingProbToBasePairFile(String inFile, String bpFile, String chromosome, String strand, int left) throws FileNotFoundException, IOException {
        SeqLenAndBinnedPairs s = BasePairFileUtils.loadPairingProb(inFile);
        ArrayList<ArrayList<Point>> binnedPairs = s.binnedPairs;
        int seqLen = s.seqLen;
        ArrayList<LinkedList<BasePairFeature>> groupedArcs = new ArrayList<LinkedList<BasePairFeature>>();
        for (ArrayList<Point> pairGroup : binnedPairs) {
            groupedArcs.add(BasePairFileUtils.transformArcs(BasePairFileUtils.pairsToHelices(pairGroup, chromosome), seqLen, left, strand));
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(255, 218, 125));
        colors.add(new Color(113, 195, 209));
        colors.add(new Color(51, 114, 38));
        ArrayList<String> colorLabels = new ArrayList<String>();
        colorLabels.add("PP 10 - 30%");
        colorLabels.add("PP 30 - 80%");
        colorLabels.add("Pairing probability > 80%");
        BasePairFileUtils.writeBasePairFile(bpFile, colors, colorLabels, groupedArcs);
    }
}

