/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamFileValidator;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Read a SAM or BAM file and report on its validity.", usageShort="Validates a SAM or BAM file", programGroup=SamOrBam.class)
public class ValidateSamFile
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM/BAM file")
    public File INPUT;
    @Option(shortName="O", doc="Output file or standard out if missing", optional=true)
    public File OUTPUT;
    @Option(shortName="M", doc="Mode of output")
    public Mode MODE = Mode.VERBOSE;
    @Option(doc="List of validation error types to ignore.")
    public List<SAMValidationError.Type> IGNORE = new ArrayList<SAMValidationError.Type>();
    @Option(shortName="MO", doc="The maximum number of lines output in verbose mode")
    public Integer MAX_OUTPUT = 100;
    @Option(shortName="R", doc="Reference sequence file, the NM tag check will be skipped if this is missing", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true, only report errors and ignore warnings.")
    public boolean IGNORE_WARNINGS = false;
    @Option(doc="If true and input is a BAM file with an index file, also validates the index.")
    public boolean VALIDATE_INDEX = true;
    @Option(shortName="BISULFITE", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads. If so, C->T is not counted as an error in computing the value of the NM tag.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(doc="Relevant for a coordinate-sorted file containing read pairs only. Maximum number of file handles to keep open when spilling mate info to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_OPEN_TEMP_FILES = 8000;

    public static void main(String[] args) {
        System.exit(new ValidateSamFile().instanceMain(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        boolean result;
        PrintWriter out;
        IOUtil.assertFileIsReadable(this.INPUT);
        ReferenceSequenceFile reference = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IOUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
            reference = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
        }
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable(this.OUTPUT);
            try {
                out = new PrintWriter(this.OUTPUT);
            }
            catch (FileNotFoundException e2) {
                throw new PicardException("Unexpected exception", e2);
            }
        } else {
            out = new PrintWriter(System.out);
        }
        ValidationStringency originalStringency = SAMFileReader.getDefaultValidationStringency();
        SAMFileReader.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
        try {
            SAMFileReader samReader = new SAMFileReader(this.INPUT);
            if (!samReader.isBinary()) {
                this.VALIDATE_INDEX = false;
            }
            if (this.VALIDATE_INDEX) {
                samReader.enableIndexCaching(true);
            }
            samReader.enableCrcChecking(true);
            SamFileValidator validator = new SamFileValidator(out, this.MAX_OPEN_TEMP_FILES);
            validator.setErrorsToIgnore(this.IGNORE);
            if (this.IGNORE_WARNINGS) {
                validator.setIgnoreWarnings(this.IGNORE_WARNINGS);
            }
            if (this.MODE == Mode.SUMMARY) {
                validator.setVerbose(false, 0);
            } else {
                validator.setVerbose(true, this.MAX_OUTPUT);
            }
            if (this.IS_BISULFITE_SEQUENCED) {
                validator.setBisulfiteSequenced(this.IS_BISULFITE_SEQUENCED);
            }
            if (this.VALIDATE_INDEX) {
                validator.setValidateIndex(this.VALIDATE_INDEX);
            }
            if (IOUtil.isRegularPath(this.INPUT)) {
                validator.validateBamFileTermination(this.INPUT);
            }
            result = false;
            switch (this.MODE) {
                case SUMMARY: {
                    result = validator.validateSamFileSummary(samReader, reference);
                    break;
                }
                case VERBOSE: {
                    result = validator.validateSamFileVerbose(samReader, reference);
                }
            }
            out.flush();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency((ValidationStringency)originalStringency);
        }
        return result ? 0 : 1;
    }

    public static enum Mode {
        VERBOSE,
        SUMMARY;

    }
}

