/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SecondaryOrSupplementarySkippingIterator;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.PositionalArguments;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="USAGE: CompareSAMS <SAMFile1> <SAMFile2>\nCompares the headers of the two input SAM or BAM files, and, if possible, the SAMRecords. For SAMRecords, compares only the readUnmapped flag, reference name, start position and strand. Reports the number of SAMRecords that match, differ in alignment, are mapped in only one input, or are missing in one of the files", usageShort="Compares two input SAM or BAM files", programGroup=SamOrBam.class)
public class CompareSAMs
extends CommandLineProgram {
    @PositionalArguments(minElements=2, maxElements=2)
    public List<File> samFiles;
    private final SAMFileReader[] samReaders = new SAMFileReader[2];
    private boolean sequenceDictionariesDiffer;
    private int mappingsMatch = 0;
    private int unmappedBoth = 0;
    private int unmappedLeft = 0;
    private int unmappedRight = 0;
    private int mappingsDiffer = 0;
    private int missingLeft = 0;
    private int missingRight = 0;
    private boolean areEqual;

    public static void main(String[] argv) {
        new CompareSAMs().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        for (int i2 = 0; i2 < this.samFiles.size(); ++i2) {
            this.samReaders[i2] = new SAMFileReader(this.samFiles.get(i2));
        }
        this.areEqual = this.compareHeaders();
        this.areEqual = this.compareAlignments() && this.areEqual;
        this.printReport();
        if (!this.areEqual) {
            System.out.println("SAM files differ.");
        } else {
            System.out.println("SAM files match.");
        }
        return 0;
    }

    private void printReport() {
        System.out.println("Match\t" + this.mappingsMatch);
        System.out.println("Differ\t" + this.mappingsDiffer);
        System.out.println("Unmapped_both\t" + this.unmappedBoth);
        System.out.println("Unmapped_left\t" + this.unmappedLeft);
        System.out.println("Unmapped_right\t" + this.unmappedRight);
        System.out.println("Missing_left\t" + this.missingLeft);
        System.out.println("Missing_right\t" + this.missingRight);
    }

    private boolean compareAlignments() {
        if (!this.compareValues(this.samReaders[0].getFileHeader().getSortOrder(), this.samReaders[1].getFileHeader().getSortOrder(), "Sort Order")) {
            System.out.println("Cannot compare alignments if sort orders differ.");
            return false;
        }
        switch (this.samReaders[0].getFileHeader().getSortOrder()) {
            case coordinate: {
                if (this.sequenceDictionariesDiffer) {
                    System.out.println("Cannot compare coordinate-sorted SAM files because sequence dictionaries differ.");
                    return false;
                }
                return this.compareCoordinateSortedAlignments();
            }
            case queryname: {
                return this.compareQueryNameSortedAlignments();
            }
            case unsorted: {
                return this.compareUnsortedAlignments();
            }
        }
        return false;
    }

    private boolean compareCoordinateSortedAlignments() {
        SecondaryOrSupplementarySkippingIterator itLeft = new SecondaryOrSupplementarySkippingIterator(this.samReaders[0].iterator());
        SecondaryOrSupplementarySkippingIterator itRight = new SecondaryOrSupplementarySkippingIterator(this.samReaders[1].iterator());
        HashMap<String, SAMRecord> leftUnmatched = new HashMap<String, SAMRecord>();
        HashMap<String, SAMRecord> rightUnmatched = new HashMap<String, SAMRecord>();
        boolean ret = true;
        while (itLeft.hasCurrent()) {
            SAMRecord right;
            SAMRecord nextLeft;
            SAMRecord left;
            if (!itRight.hasCurrent()) {
                while (itLeft.hasCurrent()) {
                    left = itLeft.getCurrent();
                    SAMRecord right2 = (SAMRecord)rightUnmatched.remove(left.getReadName());
                    if (right2 == null) {
                        ++this.missingRight;
                    } else {
                        this.tallyAlignmentRecords(left, right2);
                    }
                    itLeft.advance();
                }
                break;
            }
            left = itLeft.getCurrent();
            HashMap<String, SAMRecord> leftCurrentCoordinate = new HashMap<String, SAMRecord>();
            leftCurrentCoordinate.put(left.getReadName(), left);
            while (itLeft.advance() && this.compareAlignmentCoordinates(left, nextLeft = itLeft.getCurrent()) == 0) {
                leftCurrentCoordinate.put(nextLeft.getReadName(), nextLeft);
            }
            while (itRight.hasCurrent() && this.compareAlignmentCoordinates(left, itRight.getCurrent()) > 0) {
                right = itRight.getCurrent();
                rightUnmatched.put(right.getReadName(), right);
                itRight.advance();
            }
            while (itRight.hasCurrent() && this.compareAlignmentCoordinates(left, itRight.getCurrent()) == 0) {
                right = itRight.getCurrent();
                SAMRecord matchingLeft = (SAMRecord)leftCurrentCoordinate.remove(right.getReadName());
                if (matchingLeft != null) {
                    ret = this.tallyAlignmentRecords(matchingLeft, right) && ret;
                } else {
                    rightUnmatched.put(right.getReadName(), right);
                }
                itRight.advance();
            }
            for (SAMRecord samRecord : leftCurrentCoordinate.values()) {
                leftUnmatched.put(samRecord.getReadName(), samRecord);
            }
        }
        while (itRight.hasCurrent()) {
            SAMRecord right = itRight.getCurrent();
            SAMRecord left = (SAMRecord)leftUnmatched.remove(right.getReadName());
            if (left != null) {
                this.tallyAlignmentRecords(left, right);
            } else {
                ++this.missingLeft;
            }
            itRight.advance();
        }
        for (Map.Entry leftEntry : leftUnmatched.entrySet()) {
            String readName = (String)leftEntry.getKey();
            SAMRecord left = (SAMRecord)leftEntry.getValue();
            SAMRecord right = (SAMRecord)rightUnmatched.remove(readName);
            if (right == null) {
                ++this.missingRight;
                continue;
            }
            this.tallyAlignmentRecords(left, right);
        }
        this.missingLeft += rightUnmatched.size();
        if (ret && (this.missingLeft > 0 || this.missingRight > 0 || this.mappingsDiffer > 0 || this.unmappedLeft > 0 || this.unmappedRight > 0)) {
            ret = false;
        }
        return ret;
    }

    private int compareAlignmentCoordinates(SAMRecord left, SAMRecord right) {
        int rightReferenceIndex;
        String leftReferenceName = left.getReferenceName();
        String rightReferenceName = right.getReferenceName();
        if (leftReferenceName == null && rightReferenceName == null) {
            return 0;
        }
        if (leftReferenceName == null) {
            return 1;
        }
        if (rightReferenceName == null) {
            return -1;
        }
        int leftReferenceIndex = this.samReaders[0].getFileHeader().getSequenceIndex(leftReferenceName);
        if (leftReferenceIndex != (rightReferenceIndex = this.samReaders[0].getFileHeader().getSequenceIndex(rightReferenceName))) {
            return leftReferenceIndex - rightReferenceIndex;
        }
        return left.getAlignmentStart() - right.getAlignmentStart();
    }

    private boolean compareQueryNameSortedAlignments() {
        SecondaryOrSupplementarySkippingIterator it1 = new SecondaryOrSupplementarySkippingIterator(this.samReaders[0].iterator());
        SecondaryOrSupplementarySkippingIterator it2 = new SecondaryOrSupplementarySkippingIterator(this.samReaders[1].iterator());
        boolean ret = true;
        while (it1.hasCurrent()) {
            if (!it2.hasCurrent()) {
                this.missingRight += this.countRemaining(it1);
                return false;
            }
            int cmp = it1.getCurrent().getReadName().compareTo(it2.getCurrent().getReadName());
            if (cmp < 0) {
                ++this.missingRight;
                it1.advance();
                ret = false;
                continue;
            }
            if (cmp > 0) {
                ++this.missingLeft;
                it2.advance();
                ret = false;
                continue;
            }
            if (!this.tallyAlignmentRecords(it1.getCurrent(), it2.getCurrent())) {
                ret = false;
            }
            it1.advance();
            it2.advance();
        }
        if (it2.hasCurrent()) {
            this.missingLeft += this.countRemaining(it2);
            return false;
        }
        return ret;
    }

    private boolean compareUnsortedAlignments() {
        SecondaryOrSupplementarySkippingIterator it1 = new SecondaryOrSupplementarySkippingIterator(this.samReaders[0].iterator());
        SecondaryOrSupplementarySkippingIterator it2 = new SecondaryOrSupplementarySkippingIterator(this.samReaders[1].iterator());
        boolean ret = true;
        while (it1.hasCurrent()) {
            if (!it2.hasCurrent()) {
                this.missingRight += this.countRemaining(it1);
                return false;
            }
            SAMRecord s1 = it1.getCurrent();
            SAMRecord s2 = it2.getCurrent();
            if (!this.compareValues(s1.getReadName(), s2.getReadName(), "Read names")) {
                System.out.println("Read names cease agreeing in unsorted SAM files .  Comparison aborting.");
            }
            ret = this.tallyAlignmentRecords(s1, s2) && ret;
            it1.advance();
            it2.advance();
        }
        if (it2.hasCurrent()) {
            this.missingLeft += this.countRemaining(it2);
            return false;
        }
        return ret;
    }

    private int countRemaining(SecondaryOrSupplementarySkippingIterator it) {
        int i2 = 0;
        while (it.hasCurrent()) {
            it.advance();
            ++i2;
        }
        return i2;
    }

    private boolean tallyAlignmentRecords(SAMRecord s1, SAMRecord s2) {
        boolean ret;
        if (!s1.getReadName().equals(s2.getReadName())) {
            throw new PicardException("Read names do not match: " + s1.getReadName() + " : " + s2.getReadName());
        }
        if (s1.getReadUnmappedFlag() && s2.getReadUnmappedFlag()) {
            ++this.unmappedBoth;
            return true;
        }
        if (s1.getReadUnmappedFlag()) {
            ++this.unmappedLeft;
            return false;
        }
        if (s2.getReadUnmappedFlag()) {
            ++this.unmappedRight;
            return false;
        }
        boolean bl = ret = s1.getReferenceName().equals(s2.getReferenceName()) && s1.getAlignmentStart() == s2.getAlignmentStart() && s1.getReadNegativeStrandFlag() == s1.getReadNegativeStrandFlag();
        if (!ret) {
            ++this.mappingsDiffer;
        } else {
            ++this.mappingsMatch;
        }
        return ret;
    }

    private boolean compareHeaders() {
        SAMFileHeader h1 = this.samReaders[0].getFileHeader();
        SAMFileHeader h2 = this.samReaders[1].getFileHeader();
        boolean ret = this.compareValues(h1.getVersion(), h2.getVersion(), "File format version");
        ret = this.compareValues(h1.getCreator(), h2.getCreator(), "File creator") && ret;
        boolean bl = ret = this.compareValues(h1.getAttribute("SO"), h2.getAttribute("SO"), "Sort order") && ret;
        if (!this.compareSequenceDictionaries(h1, h2)) {
            ret = false;
            this.sequenceDictionariesDiffer = true;
        }
        ret = this.compareReadGroups(h1, h2) && ret;
        ret = this.compareProgramRecords(h1, h2) && ret;
        return ret;
    }

    private boolean compareProgramRecords(SAMFileHeader h1, SAMFileHeader h2) {
        List<SAMProgramRecord> l1 = h1.getProgramRecords();
        List<SAMProgramRecord> l2 = h2.getProgramRecords();
        if (!this.compareValues(l1.size(), l2.size(), "Number of program records")) {
            return false;
        }
        boolean ret = true;
        for (int i2 = 0; i2 < l1.size(); ++i2) {
            ret = this.compareProgramRecord(l1.get(i2), l2.get(i2)) && ret;
        }
        return ret;
    }

    private boolean compareProgramRecord(SAMProgramRecord programRecord1, SAMProgramRecord programRecord2) {
        String[] attributes;
        if (programRecord1 == null && programRecord2 == null) {
            return true;
        }
        if (programRecord1 == null) {
            this.reportDifference("null", programRecord2.getProgramGroupId(), "Program Record");
            return false;
        }
        if (programRecord2 == null) {
            this.reportDifference(programRecord1.getProgramGroupId(), "null", "Program Record");
            return false;
        }
        boolean ret = this.compareValues(programRecord1.getProgramGroupId(), programRecord2.getProgramGroupId(), "Program Name");
        for (String attribute : attributes = new String[]{"VN", "CL"}) {
            ret = this.compareValues(programRecord1.getAttribute(attribute), programRecord2.getAttribute(attribute), attribute + " Program Record attribute") && ret;
        }
        return ret;
    }

    private boolean compareReadGroups(SAMFileHeader h1, SAMFileHeader h2) {
        List<SAMReadGroupRecord> l1 = h1.getReadGroups();
        List<SAMReadGroupRecord> l2 = h2.getReadGroups();
        if (!this.compareValues(l1.size(), l2.size(), "Number of read groups")) {
            return false;
        }
        boolean ret = true;
        for (int i2 = 0; i2 < l1.size(); ++i2) {
            ret = this.compareReadGroup(l1.get(i2), l2.get(i2)) && ret;
        }
        return ret;
    }

    private boolean compareReadGroup(SAMReadGroupRecord samReadGroupRecord1, SAMReadGroupRecord samReadGroupRecord2) {
        String[] attributes;
        boolean ret = this.compareValues(samReadGroupRecord1.getReadGroupId(), samReadGroupRecord2.getReadGroupId(), "Read Group ID");
        ret = this.compareValues(samReadGroupRecord1.getSample(), samReadGroupRecord2.getSample(), "Sample for read group " + samReadGroupRecord1.getReadGroupId()) && ret;
        ret = this.compareValues(samReadGroupRecord1.getLibrary(), samReadGroupRecord2.getLibrary(), "Library for read group " + samReadGroupRecord1.getReadGroupId()) && ret;
        for (String attribute : attributes = new String[]{"DS", "PU", "PI", "CN", "DT", "PL"}) {
            ret = this.compareValues(samReadGroupRecord1.getAttribute(attribute), samReadGroupRecord2.getAttribute(attribute), attribute + " for read group " + samReadGroupRecord1.getReadGroupId()) && ret;
        }
        return ret;
    }

    private boolean compareSequenceDictionaries(SAMFileHeader h1, SAMFileHeader h2) {
        List<SAMSequenceRecord> s1 = h1.getSequenceDictionary().getSequences();
        List<SAMSequenceRecord> s2 = h2.getSequenceDictionary().getSequences();
        if (s1.size() != s2.size()) {
            this.reportDifference(s1.size(), s2.size(), "Length of sequence dictionaries");
            return false;
        }
        boolean ret = true;
        for (int i2 = 0; i2 < s1.size(); ++i2) {
            ret = this.compareSequenceRecord(s1.get(i2), s2.get(i2), i2 + 1) && ret;
        }
        return ret;
    }

    private boolean compareSequenceRecord(SAMSequenceRecord sequenceRecord1, SAMSequenceRecord sequenceRecord2, int which) {
        if (!sequenceRecord1.getSequenceName().equals(sequenceRecord2.getSequenceName())) {
            this.reportDifference(sequenceRecord1.getSequenceName(), sequenceRecord2.getSequenceName(), "Name of sequence record " + which);
            return false;
        }
        boolean ret = this.compareValues(sequenceRecord1.getSequenceLength(), sequenceRecord2.getSequenceLength(), "Length of sequence " + sequenceRecord1.getSequenceName());
        ret = this.compareValues(sequenceRecord1.getSpecies(), sequenceRecord2.getSpecies(), "Species of sequence " + sequenceRecord1.getSequenceName()) && ret;
        ret = this.compareValues(sequenceRecord1.getAssembly(), sequenceRecord2.getAssembly(), "Assembly of sequence " + sequenceRecord1.getSequenceName()) && ret;
        ret = this.compareValues(sequenceRecord1.getAttribute("M5"), sequenceRecord2.getAttribute("M5"), "MD5 of sequence " + sequenceRecord1.getSequenceName()) && ret;
        ret = this.compareValues(sequenceRecord1.getAttribute("UR"), sequenceRecord2.getAttribute("UR"), "URI of sequence " + sequenceRecord1.getSequenceName()) && ret;
        return ret;
    }

    private <T> boolean compareValues(T v1, T v2, String label) {
        if (v1 == null) {
            if (v2 == null) {
                return true;
            }
            this.reportDifference(v1, v2, label);
            return false;
        }
        if (v2 == null) {
            this.reportDifference(v1, v2, label);
            return false;
        }
        if (!v1.equals(v2)) {
            this.reportDifference(v1, v2, label);
            return false;
        }
        return true;
    }

    private void reportDifference(String s1, String s2, String label) {
        System.out.println(label + " differs.");
        System.out.println(this.samFiles.get(0) + ": " + s1);
        System.out.println(this.samFiles.get(1) + ": " + s2);
    }

    private void reportDifference(Object o1, Object o2, String label) {
        if (o1 == null) {
            o1 = "null";
        }
        if (o2 == null) {
            o2 = "null";
        }
        this.reportDifference(o1.toString(), o2.toString(), label);
    }

    public int getMappingsMatch() {
        return this.mappingsMatch;
    }

    public int getUnmappedBoth() {
        return this.unmappedBoth;
    }

    public int getUnmappedLeft() {
        return this.unmappedLeft;
    }

    public int getUnmappedRight() {
        return this.unmappedRight;
    }

    public int getMappingsDiffer() {
        return this.mappingsDiffer;
    }

    public int getMissingLeft() {
        return this.missingLeft;
    }

    public int getMissingRight() {
        return this.missingRight;
    }

    public boolean areEqual() {
        return this.areEqual;
    }
}

