/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class BestEndMapqPrimaryAlignmentStrategy
implements PrimaryAlignmentSelectionStrategy {
    private static final MapqComparator MAPQ_COMPARATOR = new MapqComparator();
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hits) {
        if (hits.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        Collections.sort(hits.firstOfPairOrFragment, MAPQ_COMPARATOR);
        Collections.sort(hits.secondOfPair, MAPQ_COMPARATOR);
        this.randomlySelectPrimaryFromBest(hits.firstOfPairOrFragment);
        this.randomlySelectPrimaryFromBest(hits.secondOfPair);
        hits.setPrimaryAlignment(0);
        if (!hits.isPaired()) {
            return;
        }
        if (hits.firstOfPairOrFragment.size() <= 1 || hits.secondOfPair.size() <= 1) {
            return;
        }
        int amountToSlide = hits.firstOfPairOrFragment.size() - 1;
        for (int i2 = 0; i2 < amountToSlide; ++i2) {
            hits.secondOfPair.add(1, null);
        }
    }

    private void randomlySelectPrimaryFromBest(List<SAMRecord> recs) {
        int i2;
        if (recs.isEmpty()) {
            return;
        }
        int bestMapq = recs.get(0).getMappingQuality();
        for (i2 = 1; i2 < recs.size() && recs.get(i2).getMappingQuality() == bestMapq; ++i2) {
        }
        int bestIndex = this.random.nextInt(i2);
        if (bestIndex == 0) {
            return;
        }
        SAMRecord tmp = recs.get(0);
        recs.set(0, recs.get(bestIndex));
        recs.set(bestIndex, tmp);
    }

    private static class MapqComparator
    implements Comparator<SAMRecord> {
        private MapqComparator() {
        }

        @Override
        public int compare(SAMRecord rec1, SAMRecord rec2) {
            if (rec1.getReadUnmappedFlag()) {
                if (rec2.getReadUnmappedFlag()) {
                    return 0;
                }
                return 1;
            }
            if (rec2.getReadUnmappedFlag()) {
                return -1;
            }
            return -SAMUtils.compareMapqs(rec1.getMappingQuality(), rec2.getMappingQuality());
        }
    }
}

