/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.GraphDelegator;
import org.jgrapht.util.ArrayUnenforcedSet;

public class AsUndirectedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
UndirectedGraph<V, E> {
    private static final long serialVersionUID = 3257845485078065462L;
    private static final String NO_EDGE_ADD = "this graph does not support edge addition";
    private static final String UNDIRECTED = "this graph only supports undirected operations";

    public AsUndirectedGraph(DirectedGraph<V, E> directedGraph) {
        super(directedGraph);
    }

    @Override
    public Set<E> getAllEdges(V v2, V v3) {
        Set set = super.getAllEdges(v2, v3);
        if (v2.equals(v3)) {
            return set;
        }
        Set set2 = super.getAllEdges(v3, v2);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet(set.size() + set2.size());
        arrayUnenforcedSet.addAll(set);
        arrayUnenforcedSet.addAll(set2);
        return arrayUnenforcedSet;
    }

    @Override
    public E getEdge(V v2, V v3) {
        Object e2 = super.getEdge(v2, v3);
        if (e2 != null) {
            return e2;
        }
        return super.getEdge(v3, v2);
    }

    @Override
    public E addEdge(V v2, V v3) {
        throw new UnsupportedOperationException(NO_EDGE_ADD);
    }

    @Override
    public boolean addEdge(V v2, V v3, E e2) {
        throw new UnsupportedOperationException(NO_EDGE_ADD);
    }

    @Override
    public int degreeOf(V v2) {
        return super.inDegreeOf(v2) + super.outDegreeOf(v2);
    }

    @Override
    public int inDegreeOf(V v2) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public Set<E> incomingEdgesOf(V v2) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public int outDegreeOf(V v2) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public Set<E> outgoingEdgesOf(V v2) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public String toString() {
        return super.toStringFromSets(this.vertexSet(), this.edgeSet(), false);
    }
}

