/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.permutation;

import java.util.Arrays;
import java.util.Iterator;
import org.jgrapht.experimental.permutation.ArrayPermutationsIter;

public class IntegerPermutationIter
implements Iterator,
ArrayPermutationsIter {
    private int[] Value;
    private int N;
    private long permutationCounter;
    private boolean endWasReached = false;
    private boolean wasNextValueCalculatedAlready = false;
    private int[] currentValueBackup;

    public IntegerPermutationIter(int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = i2;
        }
        this.init(nArray);
    }

    public IntegerPermutationIter(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray2);
        this.init(nArray2);
    }

    private void init(int[] nArray) {
        this.N = nArray.length;
        this.Value = nArray;
        this.currentValueBackup = this.Value;
        this.permutationCounter = 0L;
    }

    private void swap(int n2, int n3) {
        int n4 = this.Value[n2];
        this.Value[n2] = this.Value[n3];
        this.Value[n3] = n4;
    }

    private int[] arrayClone(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private int[] getNextStartingWith2() {
        ++this.permutationCounter;
        int n2 = this.N - 1;
        if (n2 <= 0) {
            this.endWasReached = true;
            return null;
        }
        while (this.Value[n2 - 1] >= this.Value[n2]) {
            if (--n2 != 0) continue;
            this.endWasReached = true;
            return null;
        }
        int n3 = this.N;
        while (this.Value[n3 - 1] <= this.Value[n2 - 1]) {
            --n3;
        }
        this.swap(n2 - 1, n3 - 1);
        ++n2;
        for (n3 = this.N; n2 < n3; ++n2, --n3) {
            this.swap(n2 - 1, n3 - 1);
        }
        return this.Value;
    }

    @Override
    public boolean hasNext() {
        if (this.permutationCounter == 0L || this.wasNextValueCalculatedAlready) {
            return true;
        }
        if (this.endWasReached) {
            return false;
        }
        boolean bl = true;
        this.getNextStartingWith2();
        this.wasNextValueCalculatedAlready = true;
        if (this.endWasReached) {
            return false;
        }
        return bl;
    }

    public Object next() {
        return this.getNext();
    }

    public int[] getNext() {
        int[] nArray;
        if (!this.hasNext()) {
            throw new RuntimeException("IntegerPermutationIter exceeds the total number of permutaions. Suggestion: do a check with hasNext() , or count till getTotalNumberOfPermutations before using getNext()");
        }
        if (this.permutationCounter == 0L) {
            ++this.permutationCounter;
            nArray = this.Value;
        } else if (this.wasNextValueCalculatedAlready) {
            nArray = this.Value;
            this.wasNextValueCalculatedAlready = false;
        } else {
            nArray = this.getNextStartingWith2();
            if (this.endWasReached) {
                return null;
            }
        }
        this.currentValueBackup = this.arrayClone(nArray);
        return this.arrayClone(nArray);
    }

    public int[] getCurrent() {
        return this.arrayClone(this.currentValueBackup);
    }

    public String toString(int[] nArray) {
        if (nArray.length <= 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
            stringBuffer.append(nArray[i2]).append(",");
        }
        stringBuffer.append(nArray[nArray.length - 1]).append("]");
        return stringBuffer.toString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] nextPermutation() {
        return (int[])this.next();
    }

    @Override
    public boolean hasNextPermutaions() {
        return this.hasNext();
    }
}

