/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.util.ModifiableInteger;

public class NeighborIndex<V, E>
implements GraphListener<V, E> {
    Map<V, Neighbors<V, E>> neighborMap = new HashMap<V, Neighbors<V, E>>();
    private Graph<V, E> graph;

    public NeighborIndex(Graph<V, E> graph) {
        this.graph = graph;
    }

    public Set<V> neighborsOf(V v2) {
        return this.getNeighbors(v2).getNeighbors();
    }

    public List<V> neighborListOf(V v2) {
        return this.getNeighbors(v2).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e2 = graphEdgeChangeEvent.getEdge();
        V v2 = this.graph.getEdgeSource(e2);
        V v3 = this.graph.getEdgeTarget(e2);
        if (this.neighborMap.containsKey(v2)) {
            this.getNeighbors(v2).addNeighbor(v3);
        } else {
            this.getNeighbors(v2);
        }
        if (this.neighborMap.containsKey(v3)) {
            this.getNeighbors(v3).addNeighbor(v2);
        } else {
            this.getNeighbors(v3);
        }
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e2 = graphEdgeChangeEvent.getEdge();
        V v2 = this.graph.getEdgeSource(e2);
        V v3 = this.graph.getEdgeTarget(e2);
        if (this.neighborMap.containsKey(v2)) {
            this.neighborMap.get(v2).removeNeighbor(v3);
        }
        if (this.neighborMap.containsKey(v3)) {
            this.neighborMap.get(v3).removeNeighbor(v2);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.neighborMap.remove(graphVertexChangeEvent.getVertex());
    }

    private Neighbors<V, E> getNeighbors(V v2) {
        Neighbors<V, E> neighbors = this.neighborMap.get(v2);
        if (neighbors == null) {
            neighbors = new Neighbors(v2, Graphs.neighborListOf(this.graph, v2));
            this.neighborMap.put((Neighbors<V, E>)v2, (Neighbors<Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }

    static class Neighbors<V, E> {
        private Map<V, ModifiableInteger> neighborCounts = new LinkedHashMap<V, ModifiableInteger>();
        private Set<V> neighborSet = Collections.unmodifiableSet(this.neighborCounts.keySet());

        public Neighbors(V v2, Collection<V> collection) {
            for (V v3 : collection) {
                this.addNeighbor(v3);
            }
        }

        public void addNeighbor(V v2) {
            ModifiableInteger modifiableInteger = this.neighborCounts.get(v2);
            if (modifiableInteger == null) {
                modifiableInteger = new ModifiableInteger(1);
                this.neighborCounts.put((ModifiableInteger)v2, modifiableInteger);
            } else {
                modifiableInteger.increment();
            }
        }

        public void removeNeighbor(V v2) {
            ModifiableInteger modifiableInteger = this.neighborCounts.get(v2);
            if (modifiableInteger == null) {
                throw new IllegalArgumentException("Attempting to remove a neighbor that wasn't present");
            }
            modifiableInteger.decrement();
            if (modifiableInteger.getValue() == 0) {
                this.neighborCounts.remove(v2);
            }
        }

        public Set<V> getNeighbors() {
            return this.neighborSet;
        }

        public List<V> getNeighborList() {
            ArrayList<V> arrayList = new ArrayList<V>();
            for (Map.Entry<V, ModifiableInteger> entry : this.neighborCounts.entrySet()) {
                V v2 = entry.getKey();
                int n2 = entry.getValue().intValue();
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(v2);
                }
            }
            return arrayList;
        }
    }
}

