/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.UndirectedSubgraph;

public abstract class EulerianCircuit {
    public static <V, E> boolean isEulerian(UndirectedGraph<V, E> undirectedGraph) {
        if (!new ConnectivityInspector<V, E>(undirectedGraph).isGraphConnected()) {
            return false;
        }
        for (Object v2 : undirectedGraph.vertexSet()) {
            if (undirectedGraph.degreeOf(v2) % 2 != 1) continue;
            return false;
        }
        return true;
    }

    public static <V, E> List<V> getEulerianCircuitVertices(UndirectedGraph<V, E> undirectedGraph) {
        if (!EulerianCircuit.isEulerian(undirectedGraph)) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        UndirectedSubgraph<Object, E> undirectedSubgraph = new UndirectedSubgraph<Object, E>(undirectedGraph, (Set<Object>)null, null);
        linkedList.add(undirectedSubgraph.vertexSet().iterator().next());
        while (undirectedSubgraph.edgeSet().size() > 0) {
            Object object = null;
            int n2 = 0;
            Iterator<Object> iterator = linkedList.iterator();
            while (iterator.hasNext() && undirectedSubgraph.degreeOf(object = (Object)iterator.next()) <= 0) {
                ++n2;
            }
            block2: while (undirectedSubgraph.degreeOf(object) > 0) {
                for (Object object2 : undirectedSubgraph.vertexSet()) {
                    if (!undirectedSubgraph.containsEdge(object, object2)) continue;
                    linkedList.add(n2, object2);
                    undirectedSubgraph.removeEdge(object, object2);
                    object = object2;
                    continue block2;
                }
            }
        }
        return linkedList;
    }
}

