/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.ibex.nestedvm.ClassFileCompiler;
import org.ibex.nestedvm.JavaSourceCompiler;
import org.ibex.nestedvm.Registers;
import org.ibex.nestedvm.util.ELF;
import org.ibex.nestedvm.util.Seekable;

public abstract class Compiler
implements Registers {
    ELF elf;
    final String fullClassName;
    String source = "unknown.mips.binary";
    boolean fastMem = true;
    int maxInsnPerMethod = 128;
    int maxBytesPerMethod;
    int methodMask;
    int methodShift;
    boolean pruneCases = true;
    boolean assumeTailCalls = true;
    boolean debugCompiler = false;
    boolean printStats = false;
    boolean runtimeStats = false;
    boolean supportCall = true;
    boolean nullPointerCheck = false;
    String runtimeClass = "org.ibex.nestedvm.Runtime";
    String hashClass = "java.util.Hashtable";
    boolean unixRuntime;
    boolean lessConstants;
    boolean singleFloat;
    int pageSize = 4096;
    int totalPages = 65536;
    int pageShift;
    boolean onePage;
    Hashtable jumpableAddresses;
    ELF.Symbol userInfo;
    ELF.Symbol gp;
    private boolean used;
    private static String[] options = new String[]{"fastMem", "Enable fast memory access - RuntimeExceptions will be thrown on faults", "nullPointerCheck", "Enables checking at runtime for null pointer accessses (slows things down a bit, only applicable with fastMem)", "maxInsnPerMethod", "Maximum number of MIPS instructions per java method (128 is optimal with Hotspot)", "pruneCases", "Remove unnecessary case 0xAABCCDD blocks from methods - may break some weird code", "assumeTailCalls", "Assume the JIT optimizes tail calls", "optimizedMemcpy", "Use an optimized java version of memcpy where possible", "debugCompiler", "Output information in the generated code for debugging the compiler - will slow down generated code significantly", "printStats", "Output some useful statistics about the compilation", "runtimeStats", "Keep track of some statistics at runtime in the generated code - will slow down generated code significantly", "supportCall", "Keep a stripped down version of the symbol table in the generated code to support the call() method", "runtimeClass", "Full classname of the Runtime class (default: Runtime) - use this is you put Runtime in a package", "hashClass", "Full classname of a Hashtable class (default: java.util.HashMap) - this must support get() and put()", "unixRuntime", "Use the UnixRuntime (has support for fork, wai, du, pipe, etc)", "pageSize", "The page size (must be a power of two)", "totalPages", "Total number of pages (total mem = pageSize*totalPages, must be a power of two)", "onePage", "One page hack (FIXME: document this better)", "lessConstants", "Use less constants at the cost of speed (FIXME: document this better)", "singleFloat", "Support single precision (32-bit) FP ops only"};
    static /* synthetic */ Class class$org$ibex$nestedvm$Compiler;
    static /* synthetic */ Class class$java$lang$String;

    public void setSource(String string) {
        this.source = string;
    }

    void maxInsnPerMethodInit() throws Exn {
        if ((this.maxInsnPerMethod & this.maxInsnPerMethod - 1) != 0) {
            throw new Exn("maxBytesPerMethod is not a power of two");
        }
        this.maxBytesPerMethod = this.maxInsnPerMethod * 4;
        this.methodMask = ~(this.maxBytesPerMethod - 1);
        while (this.maxBytesPerMethod >>> this.methodShift != 1) {
            ++this.methodShift;
        }
    }

    void pageSizeInit() throws Exn {
        if ((this.pageSize & this.pageSize - 1) != 0) {
            throw new Exn("pageSize not a multiple of two");
        }
        if ((this.totalPages & this.totalPages - 1) != 0) {
            throw new Exn("totalPages not a multiple of two");
        }
        while (this.pageSize >>> this.pageShift != 1) {
            ++this.pageShift;
        }
    }

    private static void usage() {
        System.err.println("Usage: java Compiler [-outfile output.java] [-o options] [-dumpoptions] <classname> <binary.mips>");
        System.err.println("-o takes mount(8) like options and can be specified multiple times");
        System.err.println("Available options:");
        for (int i2 = 0; i2 < options.length; i2 += 2) {
            System.err.print(options[i2] + ": " + Compiler.wrapAndIndent(options[i2 + 1], 16 - options[i2].length(), 18, 62));
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        int n2 = 0;
        while (stringArray.length - n2 > 0) {
            if (stringArray[n2].equals("-outfile")) {
                if (++n2 == stringArray.length) {
                    Compiler.usage();
                }
                string = stringArray[n2];
            } else if (stringArray[n2].equals("-d")) {
                if (++n2 == stringArray.length) {
                    Compiler.usage();
                }
                string2 = stringArray[n2];
            } else if (stringArray[n2].equals("-outformat")) {
                if (++n2 == stringArray.length) {
                    Compiler.usage();
                }
                string6 = stringArray[n2];
            } else if (stringArray[n2].equals("-o")) {
                if (++n2 == stringArray.length) {
                    Compiler.usage();
                }
                if (string3 == null || string3.length() == 0) {
                    string3 = stringArray[n2];
                } else if (stringArray[n2].length() != 0) {
                    string3 = string3 + "," + stringArray[n2];
                }
            } else if (stringArray[n2].equals("-dumpoptions")) {
                bl = true;
            } else if (string4 == null) {
                string4 = stringArray[n2];
            } else if (string5 == null) {
                string5 = stringArray[n2];
            } else {
                Compiler.usage();
            }
            ++n2;
        }
        if (string4 == null || string5 == null) {
            Compiler.usage();
        }
        Seekable.File file = new Seekable.File(string5);
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = null;
        Compiler compiler = null;
        if (string6 == null || string6.equals("class")) {
            if (string != null) {
                fileOutputStream = new FileOutputStream(string);
                compiler = new ClassFileCompiler((Seekable)file, string4, (OutputStream)fileOutputStream);
            } else if (string2 != null) {
                File file2 = new File(string2);
                if (!file2.isDirectory()) {
                    System.err.println(string2 + " doesn't exist or is not a directory");
                    System.exit(1);
                }
                compiler = new ClassFileCompiler((Seekable)file, string4, file2);
            } else {
                System.err.println("Refusing to write a classfile to stdout - use -outfile foo.class");
                System.exit(1);
            }
        } else if (string6.equals("javasource") || string6.equals("java")) {
            outputStreamWriter = string == null ? new OutputStreamWriter(System.out) : new FileWriter(string);
            compiler = new JavaSourceCompiler(file, string4, outputStreamWriter);
        } else {
            System.err.println("Unknown output format: " + string6);
            System.exit(1);
        }
        compiler.parseOptions(string3);
        compiler.setSource(string5);
        if (bl) {
            System.err.println("== Options ==");
            for (int i2 = 0; i2 < options.length; i2 += 2) {
                System.err.println(options[i2] + ": " + compiler.getOption(options[i2]).get());
            }
            System.err.println("== End Options ==");
        }
        try {
            compiler.go();
        }
        catch (Exn exn) {
            System.err.println("Compiler Error: " + exn.getMessage());
            System.exit(1);
        }
        finally {
            if (outputStreamWriter != null) {
                ((Writer)outputStreamWriter).close();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public Compiler(Seekable seekable, String string) throws IOException {
        this.fullClassName = string;
        this.elf = new ELF(seekable);
        if (this.elf.header.type != 2) {
            throw new IOException("Binary is not an executable");
        }
        if (this.elf.header.machine != 8) {
            throw new IOException("Binary is not for the MIPS I Architecture");
        }
        if (this.elf.ident.data != 2) {
            throw new IOException("Binary is not big endian");
        }
    }

    abstract void _go() throws Exn, IOException;

    public void go() throws Exn, IOException {
        if (this.used) {
            throw new RuntimeException("Compiler instances are good for one shot only");
        }
        this.used = true;
        if (this.onePage && this.pageSize <= 4096) {
            this.pageSize = 0x400000;
        }
        if (this.nullPointerCheck && !this.fastMem) {
            throw new Exn("fastMem must be enabled for nullPointerCheck to be of any use");
        }
        if (this.onePage && !this.fastMem) {
            throw new Exn("fastMem must be enabled for onePage to be of any use");
        }
        if (this.totalPages == 1 && !this.onePage) {
            throw new Exn("totalPages == 1 and onePage is not set");
        }
        if (this.onePage) {
            this.totalPages = 1;
        }
        this.maxInsnPerMethodInit();
        this.pageSizeInit();
        ELF.Symtab symtab = this.elf.getSymtab();
        if (symtab == null) {
            throw new Exn("Binary has no symtab (did you strip it?)");
        }
        this.userInfo = symtab.getGlobalSymbol("user_info");
        this.gp = symtab.getGlobalSymbol("_gp");
        if (this.gp == null) {
            throw new Exn("no _gp symbol (did you strip the binary?)");
        }
        if (this.pruneCases) {
            this.jumpableAddresses = new Hashtable();
            this.jumpableAddresses.put(new Integer(this.elf.header.entry), Boolean.TRUE);
            ELF.SHeader sHeader = this.elf.sectionWithName(".text");
            if (sHeader == null) {
                throw new Exn("No .text segment");
            }
            this.findBranchesInSymtab(symtab, this.jumpableAddresses);
            for (int i2 = 0; i2 < this.elf.sheaders.length; ++i2) {
                ELF.SHeader sHeader2 = this.elf.sheaders[i2];
                String string = sHeader2.name;
                if (sHeader2.addr == 0 || !string.equals(".data") && !string.equals(".sdata") && !string.equals(".rodata") && !string.equals(".ctors") && !string.equals(".dtors")) continue;
                this.findBranchesInData(new DataInputStream(sHeader2.getInputStream()), sHeader2.size, this.jumpableAddresses, sHeader.addr, sHeader.addr + sHeader.size);
            }
            this.findBranchesInText(sHeader.addr, new DataInputStream(sHeader.getInputStream()), sHeader.size, this.jumpableAddresses);
        }
        if (this.unixRuntime && this.runtimeClass.startsWith("org.ibex.nestedvm.")) {
            this.runtimeClass = "org.ibex.nestedvm.UnixRuntime";
        }
        for (int i3 = 0; i3 < this.elf.sheaders.length; ++i3) {
            String string = this.elf.sheaders[i3].name;
            if ((this.elf.sheaders[i3].flags & 2) == 0 || string.equals(".text") || string.equals(".data") || string.equals(".sdata") || string.equals(".rodata") || string.equals(".ctors") || string.equals(".dtors") || string.equals(".bss") || string.equals(".sbss")) continue;
            throw new Exn("Unknown section: " + string);
        }
        this._go();
    }

    private void findBranchesInSymtab(ELF.Symtab symtab, Hashtable hashtable) {
        ELF.Symbol[] symbolArray = symtab.symbols;
        int n2 = 0;
        for (int i2 = 0; i2 < symbolArray.length; ++i2) {
            ELF.Symbol symbol = symbolArray[i2];
            if (symbol.type != 2 || hashtable.put(new Integer(symbol.addr), Boolean.TRUE) != null) continue;
            ++n2;
        }
        if (this.printStats) {
            System.err.println("Found " + n2 + " additional possible branch targets in Symtab");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findBranchesInText(int n2, DataInputStream dataInputStream, int n3, Hashtable hashtable) throws IOException {
        int n4 = n3 / 4;
        int n5 = n2;
        int n6 = 0;
        int[] nArray = new int[32];
        int[] nArray2 = new int[32];
        block21: for (int i2 = 0; i2 < n4; ++i2, n5 += 4) {
            int n7 = dataInputStream.readInt();
            int n8 = n7 >>> 26 & 0xFF;
            int n9 = n7 >>> 21 & 0x1F;
            int n10 = n7 >>> 16 & 0x1F;
            int n11 = n7 << 16 >> 16;
            int n12 = n7 & 0xFFFF;
            int n13 = n11;
            int n14 = n7 & 0x3FFFFFF;
            int n15 = n7 & 0x3F;
            switch (n8) {
                case 0: {
                    switch (n15) {
                        case 9: {
                            if (hashtable.put(new Integer(n5 + 8), Boolean.TRUE) != null) break;
                            ++n6;
                            break;
                        }
                        case 12: {
                            if (hashtable.put(new Integer(n5 + 4), Boolean.TRUE) != null) break;
                            ++n6;
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: {
                    switch (n10) {
                        case 16: 
                        case 17: {
                            if (hashtable.put(new Integer(n5 + 8), Boolean.TRUE) == null) {
                                ++n6;
                            }
                        }
                        case 0: 
                        case 1: {
                            if (hashtable.put(new Integer(n5 + n13 * 4 + 4), Boolean.TRUE) != null) continue block21;
                            ++n6;
                            break;
                        }
                    }
                    continue block21;
                }
                case 3: {
                    if (hashtable.put(new Integer(n5 + 8), Boolean.TRUE) == null) {
                        ++n6;
                    }
                }
                case 2: {
                    if (hashtable.put(new Integer(n5 & 0xF0000000 | n14 << 2), Boolean.TRUE) != null) continue block21;
                    ++n6;
                    continue block21;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (hashtable.put(new Integer(n5 + n13 * 4 + 4), Boolean.TRUE) != null) continue block21;
                    ++n6;
                    continue block21;
                }
                case 9: {
                    if (n5 - nArray2[n9] > 128) continue block21;
                    int n16 = (nArray[n9] << 16) + n11;
                    if ((n16 & 3) == 0 && n16 >= n2 && n16 < n2 + n3 && hashtable.put(new Integer(n16), Boolean.TRUE) == null) {
                        ++n6;
                    }
                    if (n10 != n9) continue block21;
                    nArray2[n9] = 0;
                    continue block21;
                }
                case 15: {
                    nArray[n10] = n12;
                    nArray2[n10] = n5;
                    continue block21;
                }
                case 17: {
                    switch (n9) {
                        case 8: {
                            if (hashtable.put(new Integer(n5 + n13 * 4 + 4), Boolean.TRUE) != null) break;
                            ++n6;
                        }
                    }
                    continue block21;
                }
            }
        }
        dataInputStream.close();
        if (this.printStats) {
            System.err.println("Found " + n6 + " additional possible branch targets in Text segment");
        }
    }

    private void findBranchesInData(DataInputStream dataInputStream, int n2, Hashtable hashtable, int n3, int n4) throws IOException {
        int n5 = n2 / 4;
        int n6 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = dataInputStream.readInt();
            if ((n7 & 3) != 0 || n7 < n3 || n7 >= n4 || hashtable.put(new Integer(n7), Boolean.TRUE) != null) continue;
            ++n6;
        }
        dataInputStream.close();
        if (n6 > 0 && this.printStats) {
            System.err.println("Found " + n6 + " additional possible branch targets in Data segment");
        }
    }

    static final String toHex(int n2) {
        return "0x" + Long.toString((long)n2 & 0xFFFFFFFFL, 16);
    }

    static final String toHex8(int n2) {
        String string = Long.toString((long)n2 & 0xFFFFFFFFL, 16);
        StringBuffer stringBuffer = new StringBuffer("0x");
        for (int i2 = 8 - string.length(); i2 > 0; --i2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static final String toOctal3(int n2) {
        char[] cArray = new char[3];
        for (int i2 = 2; i2 >= 0; --i2) {
            cArray[i2] = (char)(48 + (n2 & 7));
            n2 >>= 3;
        }
        return new String(cArray);
    }

    private Option getOption(String string) {
        string = string.toLowerCase();
        try {
            for (int i2 = 0; i2 < options.length; i2 += 2) {
                if (!options[i2].toLowerCase().equals(string)) continue;
                return new Option(options[i2]);
            }
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public void parseOptions(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (string4.indexOf("=") != -1) {
                string3 = string4.substring(0, string4.indexOf("="));
                string2 = string4.substring(string4.indexOf("=") + 1);
            } else if (string4.startsWith("no")) {
                string3 = string4.substring(2);
                string2 = "false";
            } else {
                string3 = string4;
                string2 = "true";
            }
            Option option = this.getOption(string3);
            if (option == null) {
                System.err.println("WARNING: No such option: " + string3);
                continue;
            }
            if (option.getType() == (class$java$lang$String == null ? Compiler.class$("java.lang.String") : class$java$lang$String)) {
                option.set(string2);
                continue;
            }
            if (option.getType() == Integer.TYPE) {
                try {
                    option.set(Compiler.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("WARNING: " + string2 + " is not an integer");
                }
                continue;
            }
            if (option.getType() == Boolean.TYPE) {
                option.set(new Boolean(string2.toLowerCase().equals("true") || string2.toLowerCase().equals("yes")));
                continue;
            }
            throw new Error("Unknown type: " + option.getType());
        }
    }

    private static Integer parseInt(String string) {
        int n2 = 1;
        if (!(string = string.toLowerCase()).startsWith("0x") && string.endsWith("m")) {
            string = string.substring(0, string.length() - 1);
            n2 = 0x100000;
        } else if (!string.startsWith("0x") && string.endsWith("k")) {
            string = string.substring(0, string.length() - 1);
            n2 = 1024;
        }
        int n3 = string.length() > 2 && string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string);
        return new Integer(n3 * n2);
    }

    private static String wrapAndIndent(String string, int n2, int n3, int n4) {
        int n5;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuffer stringBuffer = new StringBuffer();
        for (n5 = 0; n5 < n2; ++n5) {
            stringBuffer.append(' ');
        }
        n5 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() + n5 + 1 > n4 && n5 > 0) {
                stringBuffer.append('\n');
                for (int i2 = 0; i2 < n3; ++i2) {
                    stringBuffer.append(' ');
                }
                n5 = 0;
            } else if (n5 > 0) {
                stringBuffer.append(' ');
                ++n5;
            }
            stringBuffer.append(string2);
            n5 += string2.length();
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    static String dateTime() {
        try {
            return new Date().toString();
        }
        catch (RuntimeException runtimeException) {
            return "<unknown>";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Option {
        private Field field;

        public Option(String string) throws NoSuchFieldException {
            this.field = string == null ? null : (class$org$ibex$nestedvm$Compiler == null ? (class$org$ibex$nestedvm$Compiler = Compiler.class$("org.ibex.nestedvm.Compiler")) : class$org$ibex$nestedvm$Compiler).getDeclaredField(string);
        }

        public void set(Object object) {
            if (this.field == null) {
                return;
            }
            try {
                this.field.set(Compiler.this, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
            }
        }

        public Object get() {
            if (this.field == null) {
                return null;
            }
            try {
                return this.field.get(Compiler.this);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
                return null;
            }
        }

        public Class getType() {
            return this.field == null ? null : this.field.getType();
        }
    }

    static class Exn
    extends Exception {
        public Exn(String string) {
            super(string);
        }
    }
}

