/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class XReadLines
implements Iterator<String>,
Iterable<String> {
    private final BufferedReader in;
    private String nextLine = null;
    private final boolean trimWhitespace;
    private final String commentPrefix;

    public XReadLines(File filename) throws FileNotFoundException {
        this(new FileReader(filename), true, null);
    }

    public XReadLines(File filename, boolean trimWhitespace) throws FileNotFoundException {
        this(new FileReader(filename), trimWhitespace, null);
    }

    public XReadLines(File filename, boolean trimWhitespace, String commentPrefix) throws FileNotFoundException {
        this(new FileReader(filename), trimWhitespace, commentPrefix);
    }

    public XReadLines(InputStream inputStream) throws FileNotFoundException {
        this(new InputStreamReader(inputStream), true, null);
    }

    public XReadLines(InputStream inputStream, boolean trimWhitespace) {
        this(new InputStreamReader(inputStream), trimWhitespace, null);
    }

    public XReadLines(InputStream inputStream, boolean trimWhitespace, String commentPrefix) {
        this(new InputStreamReader(inputStream), trimWhitespace, commentPrefix);
    }

    public XReadLines(Reader reader) {
        this(reader, true, null);
    }

    public XReadLines(Reader reader, boolean trimWhitespace) {
        this(reader, trimWhitespace, null);
    }

    public XReadLines(Reader reader, boolean trimWhitespace, String commentPrefix) {
        this.in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.trimWhitespace = trimWhitespace;
        this.commentPrefix = commentPrefix;
        try {
            this.nextLine = this.readNextLine();
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public List<String> readLines() {
        LinkedList<String> lines = new LinkedList<String>();
        for (String line : this) {
            lines.add(line);
        }
        return lines;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    private String readNextLine() throws IOException {
        String nextLine;
        while ((nextLine = this.in.readLine()) != null && (this.trimWhitespace && (nextLine = nextLine.trim()).length() == 0 || this.commentPrefix != null && nextLine.startsWith(this.commentPrefix))) {
        }
        return nextLine;
    }

    @Override
    public String next() {
        try {
            String result = this.nextLine;
            this.nextLine = this.readNextLine();
            if (this.nextLine == null) {
                this.in.close();
            }
            return result;
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

