/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import org.broadinstitute.gatk.utils.sam.ArtificialSAMIterator;
import org.broadinstitute.gatk.utils.sam.ArtificialSAMUtils;

public class ArtificialPatternedSAMIterator
extends ArtificialSAMIterator {
    private final PATTERN mPattern;
    private final int[] reads;
    private final int readCount;

    ArtificialPatternedSAMIterator(int startingChr, int endingChr, int readCount, int unmappedReadCount, SAMFileHeader header, PATTERN pattern) {
        super(startingChr, endingChr, readCount, unmappedReadCount, header);
        this.mPattern = pattern;
        this.readCount = readCount;
        this.reads = new int[readCount];
        for (int x2 = 0; x2 < readCount; ++x2) {
            this.reads[x2] = x2 + 1;
        }
        if (pattern == PATTERN.RANDOM_READS) {
            for (int y = 0; y < readCount; ++y) {
                int ranOne = (int)Math.round(Math.random() * (double)(readCount - 1));
                int ranTwo = (int)Math.round(Math.random() * (double)(readCount - 1));
                int temp = this.reads[ranOne];
                this.reads[ranOne] = this.reads[ranTwo];
                this.reads[ranTwo] = temp;
            }
            if (this.reads[0] < this.reads[this.reads.length - 1]) {
                int temp = this.reads[0];
                this.reads[0] = this.reads[this.reads.length - 1];
                this.reads[this.reads.length - 1] = temp;
            }
        }
    }

    @Override
    protected boolean createNextRead() {
        if (this.currentRead > this.rCount) {
            ++this.currentChromo;
            this.currentRead = 1;
        }
        if (this.currentChromo >= this.eChromosomeCount) {
            if (this.unmappedRemaining < 1) {
                this.next = null;
                return false;
            }
            ++this.totalReadCount;
            this.next = ArtificialSAMUtils.createArtificialRead(this.header, String.valueOf(this.totalReadCount), -1, 0, 50);
            --this.unmappedRemaining;
            return true;
        }
        ++this.totalReadCount;
        this.next = this.getNextRecord(this.currentRead);
        ++this.currentRead;
        return true;
    }

    private SAMRecord getNextRecord(int read) {
        if (read > this.readCount) {
            return ArtificialSAMUtils.createArtificialRead(this.header, String.valueOf(this.reads[this.readCount - 1]), this.currentChromo, this.reads[this.readCount - 1], 50);
        }
        return ArtificialSAMUtils.createArtificialRead(this.header, String.valueOf(this.reads[read - 1]), this.currentChromo, this.reads[read - 1], 50);
    }

    public static enum PATTERN {
        RANDOM_READS,
        IN_ORDER_READS;

    }
}

