/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.gatk.utils.QualityUtils;
import org.broadinstitute.gatk.utils.pairhmm.N2MemoryPairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMMModel;

public class LoglessPairHMM
extends N2MemoryPairHMM {
    protected static final double INITIAL_CONDITION = Math.pow(2.0, 1020.0);
    protected static final double INITIAL_CONDITION_LOG10 = Math.log10(INITIAL_CONDITION);
    protected static final double TRISTATE_CORRECTION = 3.0;

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            double initialValue = INITIAL_CONDITION / (double)haplotypeBases.length;
            for (int j2 = 0; j2 < this.paddedHaplotypeLength; ++j2) {
                this.deletionMatrix[0][j2] = initialValue;
            }
        }
        if (!this.constantsAreInitialized || recacheReadValues) {
            LoglessPairHMM.initializeProbabilities(this.transition, insertionGOP, deletionGOP, overallGCP);
            this.constantsAreInitialized = true;
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        for (int i2 = 1; i2 < this.paddedReadLength; ++i2) {
            for (int j3 = hapStartIndex + 1; j3 < this.paddedHaplotypeLength; ++j3) {
                this.matchMatrix[i2][j3] = this.prior[i2][j3] * (this.matchMatrix[i2 - 1][j3 - 1] * this.transition[i2][0] + this.insertionMatrix[i2 - 1][j3 - 1] * this.transition[i2][1] + this.deletionMatrix[i2 - 1][j3 - 1] * this.transition[i2][1]);
                this.insertionMatrix[i2][j3] = this.matchMatrix[i2 - 1][j3] * this.transition[i2][2] + this.insertionMatrix[i2 - 1][j3] * this.transition[i2][3];
                this.deletionMatrix[i2][j3] = this.matchMatrix[i2][j3 - 1] * this.transition[i2][4] + this.deletionMatrix[i2][j3 - 1] * this.transition[i2][5];
            }
        }
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = 0.0;
        for (int j4 = 1; j4 < this.paddedHaplotypeLength; ++j4) {
            finalSumProbabilities += this.matchMatrix[endI][j4] + this.insertionMatrix[endI][j4];
        }
        return Math.log10(finalSumProbabilities) - INITIAL_CONDITION_LOG10;
    }

    protected void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i2 = 0; i2 < readBases.length; ++i2) {
            byte x2 = readBases[i2];
            byte qual = readQuals[i2];
            for (int j2 = startIndex; j2 < haplotypeBases.length; ++j2) {
                byte y = haplotypeBases[j2];
                this.prior[i2 + 1][j2 + 1] = x2 == y || x2 == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual) / (this.doNotUseTristateCorrection ? 1.0 : 3.0);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    protected static void initializeProbabilities(double[][] transition, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        PairHMMModel.qualToTransProbs(transition, insertionGOP, deletionGOP, overallGCP);
    }

    protected void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior * (this.matchMatrix[indI - 1][indJ - 1] * transition[0] + this.insertionMatrix[indI - 1][indJ - 1] * transition[1] + this.deletionMatrix[indI - 1][indJ - 1] * transition[1]);
        this.insertionMatrix[indI][indJ] = this.matchMatrix[indI - 1][indJ] * transition[2] + this.insertionMatrix[indI - 1][indJ] * transition[3];
        this.deletionMatrix[indI][indJ] = this.matchMatrix[indI][indJ - 1] * transition[4] + this.deletionMatrix[indI][indJ - 1] * transition[5];
    }
}

