/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

public class SequenceComplexity {
    public static boolean[] findBasesInShortUnitRepeats(byte[] bases, int maxRepeatUnitLength, int minRepeatLengthInUnits) {
        int i2;
        boolean[] result = new boolean[bases.length];
        int[] repeatAbsoluteLengthCount = new int[maxRepeatUnitLength];
        for (i2 = 0; i2 < maxRepeatUnitLength; ++i2) {
            repeatAbsoluteLengthCount[i2] = i2 + 1;
        }
        for (i2 = 0; i2 < bases.length; ++i2) {
            for (int j2 = 1; j2 <= maxRepeatUnitLength; ++j2) {
                int prevI = i2 - j2;
                if (prevI < 0) continue;
                if (bases[prevI] == bases[i2]) {
                    int n2 = j2 - 1;
                    repeatAbsoluteLengthCount[n2] = repeatAbsoluteLengthCount[n2] + 1;
                    continue;
                }
                if (minRepeatLengthInUnits <= repeatAbsoluteLengthCount[j2 - 1] / j2) {
                    for (int k2 = i2 - repeatAbsoluteLengthCount[j2 - 1]; k2 < i2; ++k2) {
                        result[k2] = true;
                    }
                    repeatAbsoluteLengthCount[j2 - 1] = j2;
                    continue;
                }
                repeatAbsoluteLengthCount[j2 - 1] = j2;
            }
        }
        for (int j3 = 1; j3 <= maxRepeatUnitLength; ++j3) {
            if (minRepeatLengthInUnits > repeatAbsoluteLengthCount[j3 - 1] / j3) continue;
            for (int k3 = bases.length - repeatAbsoluteLengthCount[j3 - 1]; k3 < bases.length; ++k3) {
                result[k3] = true;
            }
        }
        return result;
    }
}

