/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import org.broadinstitute.gatk.tools.walkers.bqsr.BQSRGatherer;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class GatherBqsrReports
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Gathers scattered BQSR recalibration reports into a single file";
    @Option(shortName="I", doc="List of scattered BQSR files")
    public List<File> INPUT;
    @Option(shortName="O", doc="File to output the gathered file to")
    public File OUTPUT;

    public static void main(String[] args) {
        new GatherBqsrReports().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        for (File report : this.INPUT) {
            IOUtil.assertFileIsReadable(report);
        }
        IOUtil.assertFileIsWritable(this.OUTPUT);
        new BQSRGatherer().gather(this.INPUT, this.OUTPUT);
        return 0;
    }
}

