/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.util.ParsingUtils;

public class SequenceGC {
    private static int windowSize = 5;
    private static int windowStep = 1;
    private static String chromosome = "";
    private static Logger log = Logger.getLogger(SequenceGC.class);

    private static void printUsage() {
        System.err.println("Usage: SequenceGC [{-f, --file} a_path] [{-o,--output} a_out_path]\n                  [{-w,--window} a_integer] [{-s,--step} a_integer]");
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option inFile = parser.addStringOption('f', "file");
        CmdLineParser.Option outFile = parser.addStringOption('o', "output");
        CmdLineParser.Option window = parser.addIntegerOption('w', "window");
        CmdLineParser.Option step = parser.addIntegerOption('s', "step");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e2) {
            System.err.println(e2.getMessage());
            SequenceGC.printUsage();
            System.exit(2);
        }
        windowSize = (Integer)parser.getOptionValue(window, 5);
        windowStep = (Integer)parser.getOptionValue(step, 1);
        SequenceGC sequence = new SequenceGC();
        String inPath = (String)parser.getOptionValue(inFile);
        String outPath = (String)parser.getOptionValue(outFile);
        if (inPath != null) {
            sequence.ProcessPath(inPath, outPath);
        } else {
            SequenceGC.printUsage();
        }
    }

    public SequenceGC(int windowSize, int step) {
        SequenceGC.windowSize = windowSize;
        windowStep = step;
    }

    public SequenceGC(int windowSize) {
        SequenceGC.windowSize = windowSize;
    }

    private SequenceGC() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessPath(String inPath, String outPath) {
        block11: {
            File iPath = new File(inPath);
            File oPath = new File(outPath);
            try (PrintWriter pw = null;){
                String oFile = oPath.getAbsolutePath();
                if (!oFile.endsWith(".wig")) {
                    oFile = oFile + ".wig";
                }
                pw = new PrintWriter(new BufferedWriter(new FileWriter(oFile)));
                if (iPath.isDirectory()) {
                    for (File file : new File(inPath).listFiles()) {
                        if (!file.isFile()) continue;
                        if (file.getName().endsWith(".txt")) {
                            chromosome = file.getName().replace(".txt", "");
                            this.CalculatePercent(file.getAbsolutePath(), pw);
                            continue;
                        }
                        log.error("Could not load" + file.getAbsolutePath());
                    }
                    break block11;
                }
                if (iPath.isFile()) {
                    if (iPath.getName().endsWith(".txt")) {
                        chromosome = iPath.getName().replace(".txt", "");
                        this.CalculatePercent(iPath.getAbsolutePath(), pw);
                    }
                    break block11;
                }
                throw new DataLoadException("Unable to load files", inPath);
            }
        }
    }

    public void CalculatePercent(String inputFile, PrintWriter pw) {
        LinkedList<Character> sequenceWindow = new LinkedList<Character>();
        BufferedReader bfr = null;
        int startLocation = windowSize - windowSize / 2;
        try {
            int inRead;
            bfr = ParsingUtils.openBufferedReader(inputFile);
            pw.println("fixedStep chrom=" + chromosome + " start=" + startLocation + " step=" + windowStep);
            while ((inRead = bfr.read()) != -1) {
                char fRead = (char)inRead;
                if (fRead != 'A' && fRead != 'T' && fRead != 'C' && fRead != 'G' && fRead != 'N' && fRead != 'a' && fRead != 't' && fRead != 'c' && fRead != 'g' && fRead != 'n') continue;
                sequenceWindow.add(Character.valueOf(fRead));
                if (sequenceWindow.size() != windowSize) continue;
                int inWindow = 0;
                Iterator iterator = sequenceWindow.iterator();
                while (iterator.hasNext()) {
                    char aSequenceWindow = ((Character)iterator.next()).charValue();
                    if (aSequenceWindow != 'G' && aSequenceWindow != 'C') continue;
                    ++inWindow;
                }
                if (inWindow == 0) {
                    pw.println("0.0");
                } else {
                    double result = (double)inWindow / (double)windowSize * 100.0;
                    pw.println(String.format("%.2f", result));
                }
                for (int i2 = 0; i2 < windowStep; ++i2) {
                    sequenceWindow.remove();
                }
            }
        }
        catch (IOException e2) {
            throw new DataLoadException(e2.getMessage(), inputFile);
        }
        finally {
            try {
                bfr.close();
            }
            catch (IOException e3) {
                log.error("Error closing files", e3);
            }
        }
    }
}

