/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.legend.HeatmapLegendPanel;

public class LohLegendPanel
extends HeatmapLegendPanel {
    public LohLegendPanel() {
        super(TrackType.LOH);
    }

    @Override
    public void paintLegend(Graphics2D g2D) {
        g2D.setFont(FontManager.getFont(10));
        FontMetrics fm = g2D.getFontMetrics();
        int dh = fm.getHeight() / 2 + 3;
        int x2 = 0;
        int y = this.getHeight() / 2;
        String label = "Loss";
        int labelWidth = (int)fm.getStringBounds(label, g2D).getWidth();
        g2D.setColor(this.colorScale.getMaxColor());
        g2D.fillRect(x2, y, 10, 10);
        g2D.setColor(Color.BLACK);
        g2D.drawRect(x2, y, 10, 10);
        g2D.drawString(label, x2 + 20, y + dh);
        x2 += labelWidth + 60;
        label = "Retained";
        labelWidth = (int)fm.getStringBounds(label, g2D).getWidth();
        g2D.setColor(this.colorScale.getMidColor());
        g2D.fillRect(x2, y, 10, 10);
        g2D.setColor(Color.BLACK);
        g2D.drawRect(x2, y, 10, 10);
        g2D.drawString(label, x2 + 20, y + dh);
        x2 += labelWidth + 60;
        label = "Conflict";
        labelWidth = (int)fm.getStringBounds(label, g2D).getWidth();
        g2D.setColor(this.colorScale.getMinColor());
        g2D.fillRect(x2, y, 10, 10);
        g2D.setColor(Color.BLACK);
        g2D.drawRect(x2, y, 10, 10);
        g2D.drawString(label, x2 + 20, y + dh);
        x2 += labelWidth + 60;
    }
}

