/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.ui.util.UIUtilities;

public class GenomeSelectionDialog
extends JDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JTextArea textArea1;
    private JPanel filterPanel;
    private JLabel label1;
    private JTextField genomeFilter;
    private JScrollPane scrollPane1;
    private JList<GenomeListItem> genomeList;
    private JCheckBox downloadSequenceCB;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private boolean isCanceled = true;
    private GenomeListItem selectedValue = null;
    private List<GenomeListItem> allListItems;
    private DefaultListModel genomeListModel;

    public GenomeSelectionDialog(Frame parent, Collection<GenomeListItem> inputListItems) {
        super(parent);
        this.initComponents();
        UIUtilities.invokeAndWaitOnEventThread(() -> this.genomeList.setSelectionMode(0));
        this.initData(inputListItems);
        this.downloadSequenceCB.setVisible(true);
    }

    private void initData(Collection<GenomeListItem> inputListItems) {
        this.allListItems = new ArrayList<GenomeListItem>(inputListItems);
        this.rebuildGenomeList();
    }

    private void removeById(String id) {
        GenomeListItem gli;
        int ci;
        for (ci = 0; ci < this.allListItems.size() && !(gli = this.allListItems.get(ci)).getId().equals(id); ++ci) {
        }
        if (ci < this.allListItems.size()) {
            this.allListItems.remove(ci);
        }
    }

    private void rebuildGenomeList() {
        String filterText = this.genomeFilter.getText().trim().toLowerCase();
        this.rebuildGenomeList(filterText);
    }

    private void rebuildGenomeList(String filterText) {
        if (this.genomeListModel == null) {
            this.genomeListModel = new DefaultListModel();
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    GenomeSelectionDialog.this.genomeList.setModel(GenomeSelectionDialog.this.genomeListModel);
                }
            });
        }
        this.genomeListModel.clear();
        filterText = filterText.toLowerCase().trim();
        for (GenomeListItem listItem : this.allListItems) {
            if (!listItem.getDisplayableName().toLowerCase().contains(filterText)) continue;
            this.genomeListModel.addElement(listItem);
        }
    }

    private void genomeListMouseClicked(MouseEvent e2) {
        switch (e2.getClickCount()) {
            case 1: {
                List<GenomeListItem> selValues = this.genomeList.getSelectedValuesList();
                this.downloadSequenceCB.setEnabled(selValues != null && selValues.size() == 1);
                break;
            }
            case 2: {
                this.okButtonActionPerformed(null);
            }
        }
    }

    private void genomeEntryKeyReleased(KeyEvent e2) {
        this.rebuildGenomeList(this.genomeFilter.getText());
    }

    public GenomeListItem getSelectedValue() {
        return this.selectedValue;
    }

    public boolean downloadSequence() {
        return !this.isCanceled() && this.downloadSequenceCB.isEnabled() && this.downloadSequenceCB.isSelected();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = true;
        this.selectedValue = null;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = false;
        this.selectedValue = this.genomeList.getSelectedValue();
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.textArea1 = new JTextArea();
        this.filterPanel = new JPanel();
        this.label1 = new JLabel();
        this.genomeFilter = new JTextField();
        this.scrollPane1 = new JScrollPane();
        this.genomeList = new JList();
        this.downloadSequenceCB = new JCheckBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setModal(true);
        this.setTitle("Genomes to add to list");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(350, 500));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.textArea1.setText("Selected genome will be added to the genome dropdown list.");
        this.textArea1.setLineWrap(true);
        this.textArea1.setWrapStyleWord(true);
        this.textArea1.setBackground(UIManager.getColor("Button.background"));
        this.textArea1.setRows(2);
        this.textArea1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        this.textArea1.setRequestFocusEnabled(false);
        this.textArea1.setEditable(false);
        this.contentPanel.add(this.textArea1);
        this.filterPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 28));
        this.filterPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.filterPanel.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.filterPanel.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.filterPanel.getLayout()).columnWeights = new double[]{1.0, 1.0, 1.0E-4};
        ((GridBagLayout)this.filterPanel.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.label1.setText("Filter:");
        this.label1.setLabelFor(this.genomeFilter);
        this.label1.setRequestFocusEnabled(false);
        this.filterPanel.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.genomeFilter.setToolTipText("Filter genome list");
        this.genomeFilter.setPreferredSize(new Dimension(220, 28));
        this.genomeFilter.setMinimumSize(new Dimension(180, 28));
        this.genomeFilter.setAlignmentX(0.0f);
        this.genomeFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                GenomeSelectionDialog.this.genomeEntryKeyReleased(e2);
            }
        });
        this.filterPanel.add((Component)this.genomeFilter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add(this.filterPanel);
        this.genomeList.setSelectionMode(0);
        this.genomeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                GenomeSelectionDialog.this.genomeListMouseClicked(e2);
            }
        });
        this.scrollPane1.setViewportView(this.genomeList);
        this.contentPanel.add(this.scrollPane1);
        this.downloadSequenceCB.setText("Download Sequence");
        this.downloadSequenceCB.setAlignmentX(1.0f);
        this.downloadSequenceCB.setToolTipText("Download the full sequence for this organism. Note that these files can be very large (human is about 3 gigabytes)");
        this.downloadSequenceCB.setMaximumSize(new Dimension(1000, 23));
        this.downloadSequenceCB.setPreferredSize(new Dimension(300, 23));
        this.downloadSequenceCB.setMinimumSize(new Dimension(300, 23));
        this.contentPanel.add(this.downloadSequenceCB);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeSelectionDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeSelectionDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

