/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.util.BrowserLauncher;

public class VersionUpdateDialog
extends JDialog {
    private static Logger log = Logger.getLogger(VersionUpdateDialog.class);
    boolean skipVersion;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JCheckBox skipCB;
    private JEditorPane messagePane;
    private JPanel buttonBar;
    private JButton okButton;

    public VersionUpdateDialog(String versionString) {
        this.initComponents();
        this.messagePane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.messagePane.setEditable(false);
        this.messagePane.setText("<strong>A later version of IGV is available  (" + versionString + ").<p/>Download from <a href=" + Globals.downloadURL + ">" + Globals.downloadURL + "</a></strong>");
    }

    public boolean isSkipVersion() {
        return this.skipVersion;
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        this.skipVersion = this.skipCB.isSelected();
    }

    private void messagePaneHyperlinkUpdate2(HyperlinkEvent e2) {
        try {
            if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                BrowserLauncher.openURL(e2.getURL());
            }
        }
        catch (IOException ex) {
            log.error("Error opening browser", ex);
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.skipCB = new JCheckBox();
        this.messagePane = new JEditorPane();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout(0, 10));
        this.skipCB.setText("Skip this update");
        this.contentPanel.add((Component)this.skipCB, "South");
        this.messagePane.setFont(new Font("Lucida Grande", 1, 14));
        this.messagePane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e2) {
                VersionUpdateDialog.this.messagePaneHyperlinkUpdate2(e2);
            }
        });
        this.contentPanel.add((Component)this.messagePane, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VersionUpdateDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(540, 260);
        this.setLocationRelativeTo(null);
    }
}

