/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.ui.panel.ReferenceFrame;

public class RenderContext {
    private Graphics2D graphics;
    private Map<Object, Graphics2D> graphicCache;
    private ReferenceFrame referenceFrame;
    private JComponent panel;
    private Rectangle visibleRect;
    private boolean merged = false;
    public transient int translateX;
    private List<InsertionMarker> insertionMarkers;
    public boolean multiframe = false;

    public RenderContext(JComponent panel, Graphics2D graphics, ReferenceFrame referenceFrame, Rectangle visibleRect) {
        this.graphics = graphics;
        this.panel = panel;
        this.graphicCache = new HashMap<Object, Graphics2D>();
        this.referenceFrame = referenceFrame;
        this.visibleRect = visibleRect;
        if (PreferencesManager.getPreferences().getAsBoolean("ENABLE_ANTIALIASING") && graphics != null) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public RenderContext(RenderContext context) {
        this.graphics = context.getGraphics();
        this.graphicCache = new HashMap<Object, Graphics2D>();
        this.referenceFrame = new ReferenceFrame(context.referenceFrame);
        this.panel = context.panel;
        this.visibleRect = new Rectangle(context.visibleRect);
        if (PreferencesManager.getPreferences().getAsBoolean("ENABLE_ANTIALIASING") && this.graphics != null) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public void clearGraphicsCache() {
        this.graphicCache.clear();
    }

    public Graphics2D getGraphics2D(Object key) {
        Graphics2D g2 = this.graphicCache.get(key);
        if (g2 == null) {
            g2 = (Graphics2D)this.graphics.create();
            if (PreferencesManager.getPreferences().getAsBoolean("ENABLE_ANTIALIASING")) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.graphicCache.put(key, g2);
        }
        return g2;
    }

    public Graphics2D getGraphic2DForColor(Color color) {
        Graphics2D g2 = this.getGraphics2D(color);
        g2.setColor(color);
        return g2;
    }

    public Color getBackgroundColor() {
        return this.panel.getBackground();
    }

    public String getChr() {
        return this.referenceFrame.getChrName();
    }

    public double getOrigin() {
        return this.referenceFrame.getOrigin();
    }

    public double getEndLocation() {
        return this.referenceFrame.getEnd();
    }

    public double getScale() {
        return this.referenceFrame.getScale();
    }

    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public int getZoom() {
        return this.referenceFrame.getZoom();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        for (Graphics2D g2 : this.graphicCache.values()) {
            g2.dispose();
        }
        this.graphicCache.clear();
    }

    public void setInsertionMarkers(List<InsertionMarker> insertionMarkers) {
        this.insertionMarkers = insertionMarkers;
    }

    public List<InsertionMarker> getInsertionMarkers() {
        return this.insertionMarkers;
    }
}

