/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.util.stream.IGVSeekableBufferedStream;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class PairedUtils {
    private static HashSet<String> frTypes = new HashSet();
    private static HashSet<String> rfTypes;
    private static HashSet<String> ffTypes;
    private static HashSet<String> rrTypes;

    public static void main(String[] args) throws IOException {
        PairedUtils.extractUnexpectedPairs(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractInteractions(String alignmentFile, String outputFile, int binSize) {
        AlignmentReader reader = null;
        PrintWriter pw = null;
        CloseableIterator iter = null;
        HashMap<String, Integer> counts = new HashMap<String, Integer>(10000);
        try {
            reader = AlignmentReaderFactory.getReader(alignmentFile, false);
            iter = reader.iterator();
            while (iter != null && iter.hasNext()) {
                int o2;
                Alignment alignment = (Alignment)iter.next();
                if (!alignment.isPaired() || !alignment.getMate().isMapped() || alignment.getMappingQuality() <= 0 || !PairedUtils.interactionFilter(alignment)) continue;
                String chr1 = alignment.getChr();
                int bin1 = alignment.getAlignmentStart() / binSize;
                String chr2 = alignment.getMate().getChr();
                int bin2 = alignment.getMate().getStart() / binSize;
                int o1 = PairedUtils.getOrder(chr1);
                if (o1 > (o2 = PairedUtils.getOrder(chr2)) || o1 < 0 || o2 < 0) continue;
                String cell = chr1 + "_" + bin1 + ":" + chr2 + "_" + bin2;
                Integer count = (Integer)counts.get(cell);
                if (count == null) {
                    counts.put(cell, 1);
                    continue;
                }
                count = count + 1;
                counts.put(cell, count);
            }
            iter.close();
            Set entrySet = counts.entrySet();
            Iterator iter2 = entrySet.iterator();
            while (iter2.hasNext()) {
                if ((Integer)iter2.next().getValue() >= 5) continue;
                iter2.remove();
            }
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (Map.Entry entry : entrySet) {
                String cell = (String)entry.getKey();
                String[] tokens = cell.split(":");
                String[] t1 = tokens[0].split("_");
                String[] t2 = tokens[1].split("_");
                int bin1 = Integer.parseInt(t1[1]);
                int bin2 = Integer.parseInt(t2[1]);
                int gPos1 = (int)((double)bin1 + 0.5) * binSize;
                int gPos2 = (int)((double)bin2 + 0.5) * binSize;
                pw.println(cell + "\t" + t1[0] + "\t" + gPos1 + "\t" + t2[0] + "\t" + gPos2 + "\t" + (Integer)entry.getValue() / 2);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractUnexpectedPairs(String alignmentFile, String outputDir) throws IOException {
        Closeable reader = null;
        SAMFileWriter ffWriter = null;
        SAMFileWriter rfWriter = null;
        SAMFileWriter interWriter = null;
        SAMFileWriter frWriter = null;
        try {
            SamReaderFactory factory = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
            File f2 = new File("/Users/jrobinso/Downloads/human_g1k_v37_decoy.fasta");
            ReferenceSource rs = new ReferenceSource(f2);
            factory.referenceSource(rs);
            IGVSeekableBufferedStream ss = new IGVSeekableBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(alignmentFile), 128000);
            SamInputResource resource = SamInputResource.of(ss);
            reader = factory.open(resource);
            SAMFileHeader header = reader.getFileHeader();
            boolean preSorted = true;
            SAMFileWriterFactory wfactory = new SAMFileWriterFactory();
            String pre = new File(alignmentFile).getName().replace(".bam", "");
            ffWriter = wfactory.makeSAMOrBAMWriter(header, preSorted, new File(outputDir, pre + "_ff.bam"));
            rfWriter = wfactory.makeSAMOrBAMWriter(header, preSorted, new File(outputDir, pre + "_rf.bam"));
            frWriter = wfactory.makeSAMOrBAMWriter(header, preSorted, new File(outputDir, pre + "_fr.bam"));
            interWriter = wfactory.makeSAMOrBAMWriter(header, preSorted, new File(outputDir, pre + "_inter.bam"));
            SAMRecordIterator iter = reader.iterator();
            int count = 0;
            while (iter != null && iter.hasNext()) {
                Orientation orientation;
                SAMRecord record = (SAMRecord)iter.next();
                PicardAlignment alignment = new PicardAlignment(record);
                if (alignment.isPaired() && alignment.getMate().isMapped() && !alignment.isProperPair() && PairedUtils.funnyPairFilter(alignment) && (orientation = PairedUtils.getOrientation(alignment)) != null) {
                    switch (orientation) {
                        case FF: {
                            ffWriter.addAlignment(record);
                            break;
                        }
                        case RF: {
                            rfWriter.addAlignment(record);
                            break;
                        }
                        case FR: {
                            frWriter.addAlignment(record);
                            break;
                        }
                        case INTER: {
                            interWriter.addAlignment(record);
                        }
                    }
                }
                if (++count % 1000000 != 0) continue;
                System.out.println(count);
            }
            iter.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            ffWriter.close();
            rfWriter.close();
            frWriter.close();
            interWriter.close();
            reader.close();
        }
    }

    private static Orientation getOrientation(Alignment alignment) {
        if (!alignment.getChr().equals(alignment.getMate().getChr())) {
            return Orientation.INTER;
        }
        String pairOrientation = alignment.getPairOrientation();
        if (frTypes.contains(pairOrientation)) {
            return Orientation.FR;
        }
        if (rfTypes.contains(pairOrientation)) {
            return Orientation.RF;
        }
        if (ffTypes.contains(pairOrientation) || rrTypes.contains(pairOrientation)) {
            return Orientation.FF;
        }
        System.out.println(pairOrientation);
        return null;
    }

    private static int getOrder(String chr) {
        int order;
        try {
            order = Integer.parseInt(chr);
        }
        catch (NumberFormatException e2) {
            order = chr.contains("X") ? 23 : (chr.contains("Y") ? 24 : -1);
        }
        return order;
    }

    private static boolean interactionFilter(Alignment alignment) {
        return alignment.isPaired() && alignment.getMate().isMapped() && (Math.abs(alignment.getInferredInsertSize()) > 100000 || !alignment.getChr().equals(alignment.getMate().getChr()));
    }

    private static boolean funnyPairFilter(Alignment alignment) {
        if (!alignment.isPaired() || !alignment.getMate().isMapped() || alignment.getMappingQuality() <= 0) {
            return false;
        }
        if (!frTypes.contains(alignment.getPairOrientation())) {
            return true;
        }
        if (Math.abs(alignment.getInferredInsertSize()) > 1000) {
            return true;
        }
        return alignment.getMate().isMapped() && !alignment.getChr().equals(alignment.getMate().getChr());
    }

    static {
        frTypes.add("F1R2");
        frTypes.add("F2R1");
        frTypes.add("FR");
        frTypes.add("F R ");
        rfTypes = new HashSet();
        rfTypes.add("R2F1");
        rfTypes.add("R1F2");
        rfTypes.add("RF");
        rfTypes.add("R F ");
        ffTypes = new HashSet();
        ffTypes.add("F1F2");
        ffTypes.add("F2F1");
        ffTypes.add("FF");
        ffTypes.add("F F ");
        rrTypes = new HashSet();
        rrTypes.add("R1R2");
        rrTypes.add("R2R1");
        rrTypes.add("RR");
        rrTypes.add("R R ");
    }

    static enum Orientation {
        FF,
        RF,
        FR,
        INTER;

    }
}

