/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.CompositeScore;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.NamedScore;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.tdf.Accumulator;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

public class TDFDataSource
implements CoverageDataSource {
    private static Logger log = Logger.getLogger(TDFDataSource.class);
    TDFReader reader;
    int maxPrecomputedZoom = 6;
    private int trackNumber = 0;
    String trackName;
    Map<String, List<LocusScore>> summaryScoreCache = Collections.synchronizedMap(new HashMap());
    Genome genome;
    WindowFunction windowFunction = WindowFunction.mean;
    List<WindowFunction> availableFunctions;
    boolean normalizeCounts = false;
    int totalCount = 0;
    float normalizationFactor = 1.0f;
    private Map<String, String> chrNameMap = new HashMap<String, String>();
    private static HashSet<String> WELL_KNOWN_GENOMES = new HashSet<String>(Arrays.asList("hg18", "hg19", "mm8", "mm9"));

    public TDFDataSource(TDFReader reader, int trackNumber, String trackName, Genome genome) {
        this.genome = genome;
        this.trackNumber = trackNumber;
        this.trackName = trackName;
        this.reader = reader;
        this.init();
    }

    private void init() {
        this.availableFunctions = this.reader.getWindowFunctions();
        if (this.availableFunctions != null) {
            this.availableFunctions.add(WindowFunction.none);
        }
        TDFGroup rootGroup = this.reader.getGroup("/");
        try {
            this.maxPrecomputedZoom = Integer.parseInt(rootGroup.getAttribute("maxZoom"));
        }
        catch (Exception e2) {
            log.error("Error reading attribute 'maxZoom'", e2);
        }
        try {
            String e2 = rootGroup.getAttribute("genome");
        }
        catch (Exception e3) {
            log.error("Unknown genome " + rootGroup.getAttribute("genome"));
            throw new RuntimeException("Unknown genome " + rootGroup.getAttribute("genome"));
        }
        try {
            String totalCountString = rootGroup.getAttribute("totalCount");
            if (totalCountString != null) {
                this.totalCount = Integer.parseInt(totalCountString);
            }
        }
        catch (Exception e4) {
            log.error("Error reading attribute 'totalCount'", e4);
        }
        this.intChrMap();
        boolean normalizeCounts = PreferencesManager.getPreferences().getAsBoolean("NORMALIZE_COVERAGE");
        this.setNormalize(normalizeCounts);
    }

    public void updateGenome(Genome genome) {
        this.genome = genome;
        this.chrNameMap.clear();
        this.intChrMap();
    }

    private void intChrMap() {
        if (this.genome != null) {
            Set<String> chrNames = this.reader.getChromosomeNames();
            for (String chr : chrNames) {
                String igvChr = this.genome.getCanonicalChrName(chr);
                if (igvChr == null || igvChr.equals(chr)) continue;
                this.chrNameMap.put(igvChr, chr);
            }
        }
    }

    @Override
    public void setNormalize(boolean normalizeCounts) {
        this.setNormalizeCounts(normalizeCounts, 1000000.0f);
    }

    @Override
    public boolean getNormalize() {
        return this.normalizeCounts;
    }

    public void setNormalizeCounts(boolean normalizeCounts, float scalingFactor) {
        this.normalizeCounts = normalizeCounts;
        this.normalizationFactor = normalizeCounts && this.totalCount > 0 ? scalingFactor / (float)this.totalCount : 1.0f;
    }

    @Override
    public String getPath() {
        return this.reader == null ? null : this.reader.getPath();
    }

    @Override
    public double getDataMax() {
        return this.reader.getUpperLimit() * (double)this.normalizationFactor;
    }

    @Override
    public double getDataMin() {
        return this.reader.getLowerLimit() * (double)this.normalizationFactor;
    }

    private List<LocusScore> getCachedSummaryScores(String querySeq, int zoom, int tileNumber, double tileWidth) {
        String key = querySeq + "_" + zoom + "_" + tileNumber + "_" + this.windowFunction;
        List<LocusScore> scores = this.summaryScoreCache.get(key);
        if (scores == null) {
            int startLocation = (int)((double)tileNumber * tileWidth);
            int endLocation = (int)((double)(tileNumber + 1) * tileWidth);
            scores = this.getSummaryScores(querySeq, startLocation, endLocation, zoom);
            this.summaryScoreCache.put(key, scores);
        }
        return scores;
    }

    public List<LocusScore> getSummaryScores(String querySeq, int startLocation, int endLocation, int zoom) {
        List<LocusScore> scores;
        if (this.availableFunctions == null) {
            this.init();
        }
        if (zoom <= this.maxPrecomputedZoom && this.windowFunction != WindowFunction.none) {
            List<TDFTile> tiles = null;
            if (querySeq.equals("All") && !this.isChrOrderValid()) {
                TDFTile wgTile = this.reader.getWholeGenomeTile(this.genome, this.windowFunction);
                tiles = Arrays.asList(wgTile);
            } else {
                TDFDataset ds = this.reader.getDataset(querySeq, zoom, this.windowFunction);
                if (ds != null) {
                    tiles = ds.getTiles(startLocation, endLocation);
                }
            }
            scores = new ArrayList<LocusScore>(1000);
            if (tiles != null && tiles.size() > 0) {
                for (TDFTile tile : tiles) {
                    if (tile.getSize() <= 0) continue;
                    for (int i2 = 0; i2 < tile.getSize(); ++i2) {
                        float v2 = tile.getValue(this.trackNumber, i2);
                        if (Float.isNaN(v2)) continue;
                        scores.add(new BasicScore(tile.getStartPosition(i2), tile.getEndPosition(i2), v2 *= this.normalizationFactor));
                    }
                }
            }
        } else {
            scores = querySeq.equals("All") ? this.getWGRawScores() : this.getLocusScoresForChr(querySeq, startLocation, endLocation, zoom);
        }
        return scores;
    }

    private List<LocusScore> getLocusScoresForChr(String chr, int startLocation, int endLocation, int zoom) {
        List<LocusScore> scores;
        int chrLength = this.getChrLength(chr);
        if (chrLength == 0) {
            scores = Collections.emptyList();
        } else {
            endLocation = Math.min(endLocation, chrLength);
            int nTiles = (int)Math.pow(2.0, zoom);
            double binSize = Math.max(1.0, (double)chrLength / (double)nTiles / 700.0);
            scores = this.computeSummaryScores(chr, startLocation, endLocation, binSize);
        }
        return scores;
    }

    public int getChrLength(String chr) {
        if (chr.equals("All")) {
            return (int)(this.genome.getNominalLength() / 1000L);
        }
        Chromosome c2 = this.genome.getChromosome(chr);
        return c2 == null ? 0 : c2.getLength();
    }

    private List<LocusScore> getWGRawScores() {
        ArrayList<LocusScore> scores = new ArrayList<LocusScore>(10000);
        for (String chr : this.genome.getAllChromosomeNames()) {
            List<TDFTile> rawTiles;
            Chromosome c2 = this.genome.getChromosome(chr);
            String dsName = "/" + chr + "/raw";
            TDFDataset rawDataset = this.reader.getDataset(dsName);
            if (rawDataset == null || (rawTiles = rawDataset.getTiles(0, c2.getLength())).size() <= 0) continue;
            for (TDFTile rawTile : rawTiles) {
                if (rawTile == null || rawTile.getSize() <= 0) continue;
                for (int i2 = 0; i2 < rawTile.getSize(); ++i2) {
                    int s2 = this.genome.getGenomeCoordinate(chr, rawTile.getStartPosition(i2));
                    int e2 = this.genome.getGenomeCoordinate(chr, Math.max(s2, rawTile.getEndPosition(i2) - 1));
                    float v2 = rawTile.getValue(this.trackNumber, i2);
                    if (!Float.isNaN(v2)) {
                        v2 *= this.normalizationFactor;
                    }
                    scores.add(new BasicScore(s2, e2, v2));
                }
            }
        }
        return scores;
    }

    private List<LocusScore> computeSummaryScores(String chr, int startLocation, int endLocation, double scale) {
        ArrayList<LocusScore> scores;
        block11: {
            List<TDFTile> rawTiles;
            scores = new ArrayList<LocusScore>(1000);
            String dsName = "/" + chr + "/raw";
            TDFDataset rawDataset = this.reader.getDataset(dsName);
            if (rawDataset == null || (rawTiles = rawDataset.getTiles(startLocation, endLocation)).size() <= 0) break block11;
            if (this.windowFunction == WindowFunction.none) {
                block0: for (TDFTile rawTile : rawTiles) {
                    if (rawTile == null || rawTile.getSize() <= 0) continue;
                    for (int i2 = 0; i2 < rawTile.getSize(); ++i2) {
                        int s2 = rawTile.getStartPosition(i2);
                        int e2 = Math.max(s2, rawTile.getEndPosition(i2) - 1);
                        if (e2 < startLocation) continue;
                        if (s2 > endLocation) continue block0;
                        float v2 = rawTile.getValue(this.trackNumber, i2);
                        if (!Float.isNaN(v2)) {
                            v2 *= this.normalizationFactor;
                        }
                        scores.add(new BasicScore(s2, e2, v2));
                    }
                }
            } else {
                Accumulator accumulator = new Accumulator(this.windowFunction, 5);
                int accumulatedStart = -1;
                int accumulatedEnd = -1;
                int lastEndBin = 0;
                for (TDFTile rawTile : rawTiles) {
                    int size = rawTile.getSize();
                    if (rawTile == null || size <= 0) continue;
                    int[] starts = rawTile.getStart();
                    int[] ends = rawTile.getEnd();
                    String[] features = rawTile.getNames();
                    float[] values = rawTile.getData(this.trackNumber);
                    for (int i3 = 0; i3 < size && starts[i3] < endLocation; ++i3) {
                        int s3 = Math.max(startLocation, starts[i3]);
                        int e3 = ends == null ? s3 + 1 : Math.min(endLocation, ends[i3]);
                        float v3 = values[i3] * this.normalizationFactor;
                        if (e3 < startLocation || Float.isNaN(v3)) continue;
                        String probeName = features == null ? null : features[i3];
                        int endBin = (int)((double)(e3 - startLocation) / scale);
                        int startBin = (int)((double)(s3 - startLocation) / scale);
                        if ((endBin > lastEndBin || endBin > startBin) && accumulator.hasData()) {
                            scores.add(this.getCompositeScore(accumulator, accumulatedStart, accumulatedEnd));
                            accumulator = new Accumulator(this.windowFunction, 5);
                        }
                        if (endBin > startBin) {
                            scores.add(new NamedScore(s3, e3, v3, probeName));
                        } else if (!accumulator.hasData()) {
                            accumulatedStart = s3;
                            accumulatedEnd = e3;
                            accumulator.add(e3 - s3, v3, probeName);
                        }
                        lastEndBin = endBin;
                    }
                    if (!accumulator.hasData()) continue;
                    scores.add(this.getCompositeScore(accumulator, accumulatedStart, accumulatedEnd));
                }
            }
        }
        return scores;
    }

    private LocusScore getCompositeScore(Accumulator accumulator, int accumulatedStart, int accumulatedEnd) {
        LocusScore ls;
        if (accumulator.getNpts() == 1) {
            ls = new NamedScore(accumulatedStart, accumulatedEnd, accumulator.getRepData()[0], accumulator.getRepProbes()[0]);
        } else {
            float value = accumulator.getValue();
            ls = new CompositeScore(accumulatedStart, accumulatedEnd, value, accumulator.getRepData(), accumulator.getRepProbes(), this.windowFunction);
        }
        return ls;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        String tmp;
        Chromosome chromosome = this.genome.getChromosome(chr);
        if (chromosome != null) {
            endLocation = Math.min(chromosome.getLength(), endLocation);
        }
        String querySeq = (tmp = this.chrNameMap.get(chr)) == null ? chr : tmp;
        ArrayList<LocusScore> scores = new ArrayList<LocusScore>();
        int tileWidth = 0;
        if (chr.equals("All")) {
            tileWidth = (int)Math.ceil((double)this.genome.getNominalLength() / 1000.0);
        } else if (chromosome != null) {
            tileWidth = chromosome.getLength() / (int)Math.pow(2.0, zoom);
        }
        if (tileWidth == 0) {
            return null;
        }
        int startTile = startLocation / tileWidth;
        int endTile = (endLocation - 1) / tileWidth;
        block0: for (int t2 = startTile; t2 <= endTile; ++t2) {
            List<LocusScore> cachedScores = this.getCachedSummaryScores(querySeq, zoom, t2, tileWidth);
            if (cachedScores == null) continue;
            for (LocusScore s2 : cachedScores) {
                if (s2.getEnd() >= startLocation) {
                    scores.add(s2);
                    continue;
                }
                if (s2.getStart() <= endLocation) continue;
                continue block0;
            }
        }
        return scores;
    }

    @Override
    public TrackType getTrackType() {
        return this.reader.getTrackType();
    }

    @Override
    public void setWindowFunction(WindowFunction wf) {
        this.windowFunction = wf;
    }

    @Override
    public boolean isLogNormalized() {
        return this.getDataMin() < 0.0;
    }

    public void refreshData(long timestamp) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.availableFunctions;
    }

    @Override
    public void dispose() {
    }

    boolean isChrOrderValid() {
        if (this.reader.getVersion() >= 4) {
            ArrayList<String> fileChromos = null;
            try {
                TDFGroup rootGroup = this.reader.getGroup("/");
                String chromosomeNames = rootGroup.getAttribute("chromosomes");
                fileChromos = new ArrayList<String>(Arrays.asList(chromosomeNames.split(",")));
            }
            catch (Exception e2) {
                return false;
            }
            return TDFDataSource.checkChromoNameOrder(fileChromos, this.genome.getLongChromosomeNames());
        }
        if (this.genome != null) {
            String genomeId = this.genome.getId();
            return WELL_KNOWN_GENOMES.contains(genomeId);
        }
        return false;
    }

    static boolean checkChromoNameOrder(List<String> fileChromos, List<String> genomeChromos) {
        int chrCount = Math.min(fileChromos.size(), genomeChromos.size());
        for (int i2 = 0; i2 < chrCount; ++i2) {
            if (fileChromos.get(i2).equals(genomeChromos.get(i2))) continue;
            return false;
        }
        return true;
    }
}

