/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.synteny;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.synteny.AbstractMapping;
import org.broad.igv.synteny.Anchor;
import org.broad.igv.synteny.Mapping;
import org.broad.igv.synteny.Region;
import org.broad.igv.util.ParsingUtils;

public class SyntenyUtils {
    static final Pattern SPACE = Pattern.compile(" ");
    static final Pattern TAB = Pattern.compile("\t");
    static String usageString = "USAGE: java -jar synteny.jar <mapping> <inputFile.seg> <outputFile.seg>";
    static String mappingString = "Recognized mappings:  canFam2tohg18  mm9tohg18";

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println(usageString);
            System.exit(-1);
        }
        String mapping = args[0];
        String inputFile = args[1];
        String outputFile = args[2];
        if (!inputFile.endsWith(".seg")) {
            System.out.println("Input file type not supported (" + inputFile + ").  Currently only segmented files (.seg) are supported.");
            System.exit(-1);
        }
        if (!outputFile.endsWith(".seg")) {
            System.out.println("Output file type not supported (" + inputFile + ").  Currently only segmented files (.seg) are supported.");
            System.exit(-1);
        }
        String mappingFile = null;
        if (mapping.equals("canFam2tohg18")) {
            mappingFile = "/resources/canFam2/mapWithUn_ph_MA4_ML10K.map";
        } else if (mapping.equals("mm9tohg18")) {
            mappingFile = "/resources/mm9/mapWithUn_ph_MA4_ML10K.clean.map";
        } else {
            System.out.println("Unsupported mapping: " + mapping);
            System.out.println(mappingString);
            System.exit(-1);
        }
        SyntenyUtils.mapSegments(mapping, inputFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapCNFile(String path, String cnFile, String oFile) {
        Map<String, List<Mapping>> mappings = SyntenyUtils.loadMappings(path, true);
        System.out.println("Mappings loaded");
        int chrCol = 1;
        int posCol = 2;
        try {
            BufferedReader br = new BufferedReader(new FileReader(cnFile));
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(oFile)));
            String nextLine = br.readLine();
            pw.println(nextLine);
            String lastChr = "";
            while ((nextLine = br.readLine()) != null) {
                int toPos;
                Region region;
                List<Mapping> mList;
                String[] tokens = TAB.split(nextLine);
                String chr = tokens[chrCol];
                int position = Integer.parseInt(tokens[posCol]);
                if (!lastChr.equals(chr)) {
                    lastChr = chr;
                }
                if ((mList = mappings.get(chr)) == null || (region = (Region)SyntenyUtils.getMappingContaining(mList, position)) == null || (toPos = (int)region.mapPosition(position)) <= 0) continue;
                tokens[chrCol] = region.getToChr();
                tokens[posCol] = String.valueOf(toPos);
                int nTokens = tokens.length;
                pw.print(tokens[0]);
                for (int i2 = 1; i2 < nTokens; ++i2) {
                    pw.print("\t");
                    pw.print(tokens[i2]);
                }
                pw.println();
            }
            br.close();
            pw.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapSegments(String mappingFile, String iFile, String oFile) {
        Map<String, List<Mapping>> mappings = SyntenyUtils.loadMappings(mappingFile, true);
        int sampleColumn = 0;
        int chrColumn = 1;
        int startColumn = 2;
        int endColumn = 3;
        BufferedReader reader = null;
        PrintWriter pw = null;
        String nextLine = null;
        try {
            reader = new BufferedReader(new FileReader(iFile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(oFile)));
            nextLine = reader.readLine();
            while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                pw.println(nextLine);
                nextLine = reader.readLine();
            }
            pw.println(nextLine);
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                String[] tokens = TAB.split(nextLine);
                int nTokens = tokens.length;
                if (nextLine.startsWith("#") || nTokens <= 4) {
                    System.out.println(nextLine);
                    continue;
                }
                String sample = tokens[sampleColumn];
                String chr = tokens[chrColumn];
                int start = Integer.parseInt(tokens[startColumn].trim());
                int end = Integer.parseInt(tokens[endColumn].trim());
                String mappingChr = chr.startsWith("chr") ? chr : "chr" + chr;
                List<Mapping> tmp = mappings.get(mappingChr);
                if (tmp == null) {
                    System.out.println("No mappings for chr: " + chr);
                    continue;
                }
                List<Mapping> overlappingMappings = SyntenyUtils.getMappingsOverlapping(tmp, start, end);
                if (overlappingMappings == null) {
                    System.out.println("No mapping for: " + chr + ":" + start + "-" + end);
                    continue;
                }
                for (Mapping mapping : overlappingMappings) {
                    int adjustedStart = Math.max(start, mapping.getFromStart());
                    int adjustedEnd = Math.min(end, mapping.getFromEnd() - 1);
                    int p1 = (int)mapping.mapPosition(adjustedStart);
                    int p2 = (int)mapping.mapPosition(adjustedEnd);
                    if (p1 < 0 || p2 < 0) {
                        System.out.println("Unmapped position: " + chr + ":" + start + "-" + end + " -> (" + p1 + "  " + p2 + ")");
                    }
                    if (p1 == p2) {
                        System.out.println("Warning: start == end in mapped position " + mapping.toString());
                    }
                    int toStart = Math.min(p1, p2);
                    int toEnd = Math.max(p1, p2);
                    pw.print(sample + "\t" + mapping.getToChr() + "\t" + toStart + "\t" + toEnd);
                    for (int i2 = endColumn + 1; i2 < tokens.length; ++i2) {
                        pw.print("\t" + tokens[i2]);
                    }
                    pw.println();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (reader == null) {
                    reader.close();
                }
                if (pw != null) {
                    pw.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toBed(String mappingFile, String ofile) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            Map<String, List<Mapping>> mappings = SyntenyUtils.loadMappings(mappingFile, false);
            for (String chr : mappings.keySet()) {
                for (Mapping m2 : mappings.get(chr)) {
                    pw.println(((Region)m2).toBed());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<Mapping>> loadMappings(String path, boolean reverse) {
        BufferedReader reader = null;
        HashMap<String, ArrayList<AbstractMapping>> mappings = new HashMap<String, ArrayList<AbstractMapping>>();
        Region currentRegion = null;
        try {
            String nextLine;
            InputStream stream = ParsingUtils.openInputStream(path);
            reader = new BufferedReader(new InputStreamReader(stream));
            Pattern.compile("\t");
            while ((nextLine = reader.readLine()) != null) {
                if (!nextLine.startsWith("region") && !nextLine.startsWith("anchor")) continue;
                String[] tokens = SPACE.split(nextLine);
                String type = tokens[0];
                Class c2 = type.equals("region") ? Region.class : Anchor.class;
                String name = tokens[1];
                String fromChr = tokens[2];
                int fromStart = Integer.parseInt(tokens[3]);
                int fromEnd = Integer.parseInt(tokens[4]);
                String fromStrand = tokens[5];
                if (!fromStrand.equals("+")) {
                    System.out.println("Negative from strand");
                }
                String toChr = tokens[6];
                int toStart = Integer.parseInt(tokens[7]);
                int toEnd = Integer.parseInt(tokens[8]);
                String toStrand = tokens[9];
                AbstractMapping syntenyMapping = (AbstractMapping)c2.newInstance();
                if (reverse) {
                    syntenyMapping.setParameters(name, toChr, toStart, toEnd, toStrand, fromChr, fromStart, fromEnd, fromStrand);
                } else {
                    syntenyMapping.setParameters(name, fromChr, fromStart, fromEnd, fromStrand, toChr, toStart, toEnd, toStrand);
                }
                if (c2 == Region.class) {
                    currentRegion = (Region)syntenyMapping;
                    ArrayList<AbstractMapping> syntenyMappingList = (ArrayList<AbstractMapping>)mappings.get(syntenyMapping.getFromChr());
                    if (syntenyMappingList == null) {
                        syntenyMappingList = new ArrayList<AbstractMapping>(1000);
                        mappings.put(syntenyMapping.getFromChr(), syntenyMappingList);
                    }
                    syntenyMappingList.add(syntenyMapping);
                    continue;
                }
                currentRegion.addAnchor((Anchor)syntenyMapping);
            }
            for (List syntenyMappingList : mappings.values()) {
                SyntenyUtils.sortMappingList(syntenyMappingList);
            }
            HashMap<String, ArrayList<AbstractMapping>> hashMap = mappings;
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Map<String, List<Mapping>> map = null;
            return map;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Mapping getMappingContaining(List<Mapping> mappings, int fromPosition) {
        int idx;
        for (int i2 = idx = SyntenyUtils.getIndexBefore(mappings, fromPosition); i2 < mappings.size(); ++i2) {
            Mapping mapping = mappings.get(i2);
            if (!mapping.containsFromPosition(fromPosition)) continue;
            return mapping;
        }
        return null;
    }

    public static List<Mapping> getMappingsOverlapping(List<Mapping> mappings, int fromStart, int fromEnd) {
        int idx;
        ArrayList<Mapping> overlaps = new ArrayList<Mapping>();
        for (int i2 = idx = SyntenyUtils.getIndexBefore(mappings, fromStart); i2 < mappings.size(); ++i2) {
            AbstractMapping m2 = (AbstractMapping)mappings.get(i2);
            if (m2.getFromEnd() >= fromStart && m2.getFromStart() <= fromEnd) {
                overlaps.add(m2);
                continue;
            }
            if (m2.getFromStart() > fromEnd) break;
        }
        return overlaps;
    }

    private static void sortMappingList(List<Mapping> features) {
        Collections.sort(features, new Comparator<Mapping>(){

            @Override
            public int compare(Mapping o1, Mapping o2) {
                return o1.getFromStart() - o2.getFromStart();
            }
        });
    }

    private static int getIndexBefore(List<Mapping> values, int x2) {
        return SyntenyUtils.getIndexBefore(values, x2, 0, values.size());
    }

    private static int getIndexBefore(List<Mapping> values, int x2, int leftBound, int rightBound) {
        int idx = (leftBound + rightBound) / 2;
        if (idx == 0 || idx == values.size() - 1) {
            return idx;
        }
        if (((AbstractMapping)values.get(idx)).getFromStart() == x2) {
            return idx;
        }
        if (((AbstractMapping)values.get(idx)).getFromStart() < x2) {
            if (((AbstractMapping)values.get(idx + 1)).getFromStart() >= x2) {
                return idx;
            }
            leftBound = idx;
            return SyntenyUtils.getIndexBefore(values, x2, leftBound, rightBound);
        }
        if (((AbstractMapping)values.get(idx - 1)).getFromStart() <= x2) {
            return idx - 1;
        }
        rightBound = idx;
        return SyntenyUtils.getIndexBefore(values, x2, leftBound, rightBound);
    }
}

