/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.SAMQueryIterator;
import org.broad.igv.util.HttpUtils;

public class CGIAlignmentReader
implements AlignmentReader {
    private static Logger log = Logger.getLogger(CGIAlignmentReader.class);
    private final SamReaderFactory factory;
    String baseURL;
    String queryScript = "query.cgi";
    String headerScript = "samHeader.cgi";
    String seqNameScript = "getSequenceNames.cgi";
    String query;
    SAMFileHeader header;
    List<String> sequenceNames;

    public CGIAlignmentReader(String url) throws MalformedURLException {
        URL u2 = new URL(url);
        int port = u2.getPort();
        this.baseURL = u2.getProtocol() + "://" + u2.getHost();
        if (port > 0) {
            this.baseURL = this.baseURL + ":" + port;
        }
        this.baseURL = this.baseURL + u2.getPath();
        this.query = u2.getQuery();
        this.factory = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
        this.loadHeader();
    }

    String getHeaderURL() {
        return this.baseURL.replace(this.queryScript, this.headerScript) + "?" + this.query;
    }

    String getSequenceNamesURL() {
        return this.baseURL.replace(this.queryScript, this.seqNameScript) + "?" + this.query;
    }

    String getQueryURL() {
        return this.baseURL + "?" + this.query;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() {
        InputStream is = null;
        try {
            URL url = new URL(this.getHeaderURL());
            is = HttpUtils.getInstance().openConnectionStream(url);
            BufferedLineReader reader = new BufferedLineReader(is);
            SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
            this.header = codec.decode(reader, null);
        }
        catch (Exception ex) {
            log.info("Error loading header : " + ex.getMessage());
            this.header = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.error("Error closing url stream", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            InputStream is = null;
            try {
                String nextLine;
                URL url = new URL(this.getSequenceNamesURL());
                is = HttpUtils.getInstance().openConnectionStream(url);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                this.sequenceNames = new ArrayList<String>();
                while ((nextLine = br.readLine()) != null) {
                    String[] tokens;
                    for (String seq : tokens = nextLine.split("\\s+")) {
                        this.sequenceNames.add(seq);
                    }
                }
            }
            catch (IOException e2) {
                log.error("Error fetching sequence names", e2);
                List<String> list = null;
                return list;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        log.error(e3);
                    }
                }
            }
        }
        return this.sequenceNames;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    @Override
    public SAMFileHeader getFileHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    public CloseableIterator<PicardAlignment> iterator() {
        try {
            URL url = new URL(this.getQueryURL());
            InputStream is = HttpUtils.getInstance().openConnectionStream(url);
            BufferedInputStream stream = new BufferedInputStream(is, 500000);
            SamInputResource resource = SamInputResource.of(stream);
            SamReader reader = this.factory.open(resource);
            SAMRecordIterator iter = reader.iterator();
            return new SAMQueryIterator(iter);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public CloseableIterator<PicardAlignment> query(String sequence, int start, int end, boolean contained) throws IOException {
        try {
            String parameters = "&chr=" + sequence + "&start=" + start + "&end=" + end + "&contained=" + contained;
            URL url = new URL(this.getQueryURL() + parameters);
            InputStream is = HttpUtils.getInstance().openConnectionStream(url);
            BufferedInputStream stream = new BufferedInputStream(is, 500000);
            SamInputResource resource = SamInputResource.of(stream);
            SamReader reader = this.factory.open(resource);
            SAMRecordIterator iter = reader.iterator();
            return new SAMQueryIterator(sequence, start, end, contained, iter);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasIndex() {
        return false;
    }

    public static void main(String[] args) throws IOException {
        Globals.setHeadless(true);
        CGIAlignmentReader reader = new CGIAlignmentReader("http://philtest.batcave.net/query.cgi?file=input.sam");
        String chr = "gi|66043271|ref|NC_007005.1|";
        int start = 800;
        int end = 900;
        CloseableIterator<PicardAlignment> iter = reader.query(chr, start, end, false);
        while (iter.hasNext()) {
            Alignment a2 = (Alignment)iter.next();
            System.out.println(a2);
        }
    }
}

