/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.lite;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlockImpl;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.lite.BAMAlignment;
import org.broad.igv.sam.lite.BAMIndex;
import org.broad.igv.sam.lite.BGUnzip;
import org.broad.igv.sam.lite.CigarOperator;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BAMReader
implements AlignmentReader<Alignment> {
    private static Logger log = Logger.getLogger(BAMReader.class);
    private final String path;
    private final String indexPath;
    int BAM_MAGIC = 21840194;
    int BAI_MAGIC = 21578050;
    char[] SECRET_DECODER = new char[]{'=', 'A', 'C', 'x', 'G', 'x', 'x', 'x', 'T', 'x', 'x', 'x', 'x', 'x', 'x', 'N'};
    char[] CIGAR_DECODER = new char[]{'M', 'I', 'D', 'N', 'S', 'H', 'P', '=', 'X', '?', '?', '?', '?', '?', '?', '?'};
    int PAIRED_FLAG = 1;
    int READ_STRAND_FLAG = 16;
    int MATE_STRAND_FLAG = 32;
    int MATE_IS_MAPPED_FLAG = 8;
    int FIRST_OF_PAIR_FLAG = 64;
    int SECOND_OF_PAIR_FLAG = 128;
    int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    int DUPLICATE_READ_FLAG = 1024;
    int SUPPLEMENTARY_FLAG = 2048;
    int MAX_GZIP_BLOCK_SIZE = 65536;
    int DEFAULT_SAMPLING_WINDOW_SIZE = 100;
    int DEFAULT_SAMPLING_DEPTH = 50;
    int MAXIMUM_SAMPLING_DEPTH = 2500;
    BAMIndex bamIndex = null;
    Genome genome;
    Map<String, Integer> chrToIndex;
    private String[] indexToChr;

    public BAMReader(String path) {
        this.path = path;
        this.indexPath = path + ".bai";
        try {
            this.bamIndex = BAMIndex.loadIndex(this.indexPath, null);
            this.readHeader();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<String> getSequenceNames() throws IOException {
        return Arrays.asList(this.indexToChr);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return null;
    }

    @Override
    public Set<String> getPlatforms() {
        return null;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return null;
    }

    @Override
    public boolean hasIndex() {
        return this.bamIndex != null;
    }

    @Override
    public CloseableIterator<Alignment> query(String chr, int start, int end, boolean contained) throws IOException {
        return new CIterator(chr, start, end);
    }

    public List<Alignment> readAlignments(BAMIndex.Chunk c2, int chrId, int start, int end) throws IOException {
        ArrayList<Alignment> alignmentContainer = new ArrayList<Alignment>(10000);
        long fetchMin = c2.start.block;
        long fetchMax = c2.end.block + 65000L;
        SeekableStream ss = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
        ss.seek(fetchMin);
        byte[] buffer = new byte[(int)(fetchMax - fetchMin + 1L)];
        try {
            ss.readFully(buffer);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        byte[] unc = BGUnzip.blockUnzip(buffer);
        this.decodeBamRecords(unc, c2.start.offset, alignmentContainer, start, end, chrId);
        return alignmentContainer;
    }

    public List<Alignment> readAlignments(String chr, int bpStart, int bpEnd) throws IOException {
        Map<String, Integer> chrToIndex;
        Integer chrId;
        ArrayList<Alignment> alignmentContainer = new ArrayList<Alignment>(10000);
        if (this.chrToIndex == null) {
            this.readHeader();
        }
        if ((chrId = (chrToIndex = this.chrToIndex).get(chr)) == null) {
            return alignmentContainer;
        }
        List<BAMIndex.Chunk> chunks = this.bamIndex.chunksForRange(chrId, bpStart, bpEnd);
        if (chunks == null || chunks.isEmpty()) {
            return alignmentContainer;
        }
        for (BAMIndex.Chunk c2 : chunks) {
            long fetchMin = c2.start.block;
            long fetchMax = c2.end.block + 65000L;
            SeekableStream ss = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
            ss.seek(fetchMin);
            byte[] buffer = new byte[(int)(fetchMax - fetchMin + 1L)];
            try {
                ss.readFully(buffer);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            byte[] unc = BGUnzip.blockUnzip(buffer);
            this.decodeBamRecords(unc, c2.start.offset, alignmentContainer, bpStart, bpEnd, chrId);
        }
        return alignmentContainer;
    }

    void decodeBamRecords(byte[] ba, int offset, List<Alignment> alignmentContainer, int min, int max, int chrId) {
        while (offset < ba.length) {
            boolean isPaired;
            int blockSize = BAMReader.readInt(ba, offset);
            int blockEnd = offset + blockSize + 4;
            if (blockEnd > ba.length) {
                return;
            }
            int refID = BAMReader.readInt(ba, offset + 4);
            int pos = BAMReader.readInt(ba, offset + 8);
            if (refID < 0) {
                return;
            }
            if (refID > chrId || pos > max) {
                return;
            }
            if (refID < chrId) continue;
            int bmn = BAMReader.readInt(ba, offset + 12);
            int bin = (bmn & 0xFFFF0000) >> 16;
            int mq = (bmn & 0xFF00) >> 8;
            int nl = bmn & 0xFF;
            int flag_nc = BAMReader.readInt(ba, offset + 16);
            int flag = (flag_nc & 0xFFFF0000) >> 16;
            int nc = flag_nc & 0xFFFF;
            int lseq = BAMReader.readInt(ba, offset + 20);
            int mateRefID = BAMReader.readInt(ba, offset + 24);
            int matePos = BAMReader.readInt(ba, offset + 28);
            byte[] readNameBytes = Arrays.copyOfRange(ba, offset + 36, offset + 36 + nl);
            String readName = new String(readNameBytes);
            int p2 = offset + 36 + nl;
            byte[] cigarBytes = Arrays.copyOfRange(ba, p2, p2 + 4 * nc);
            p2 += 4 * nc;
            CigarOperator[] cigarArray = new CigarOperator[nc];
            int lengthOnRef = 0;
            for (int c2 = 0; c2 < nc; ++c2) {
                int cigop = BAMReader.readInt(cigarBytes, c2);
                int opLen = cigop >> 4;
                char opLtr = this.CIGAR_DECODER[cigop & 0xF];
                if (opLtr == 'M' || opLtr == 'X' || opLtr == 'D' || opLtr == 'N' || opLtr == '=') {
                    lengthOnRef += opLen;
                }
                cigarArray[c2] = new CigarOperator(opLen, opLtr);
            }
            if (pos + lengthOnRef < min) {
                offset = blockEnd;
                continue;
            }
            int seqSize = lseq + 1 >> 1;
            byte[] seqBytes = Arrays.copyOfRange(ba, p2, p2 + seqSize);
            byte[] sequence = new byte[lseq];
            for (int j2 = 0; j2 < seqSize; ++j2) {
                byte sb = seqBytes[j2];
                sequence[2 * j2] = (byte)this.SECRET_DECODER[(sb & 0xF0) >> 4];
                if (2 * j2 + 1 >= lseq) continue;
                int n2 = 2 * j2 + 1;
                sequence[n2] = (byte)(sequence[n2] + this.SECRET_DECODER[sb & 0xF]);
            }
            byte[] qualities = lseq == 1 && sequence[0] == 42 ? new byte[]{127} : Arrays.copyOfRange(ba, p2 += seqSize, p2 + lseq);
            p2 += lseq;
            ReadMate mate = null;
            boolean bl = isPaired = (flag & this.PAIRED_FLAG) != 0;
            if (isPaired) {
                boolean mateIsMapped = (flag & this.MATE_IS_MAPPED_FLAG) != 0;
                String mateChr = mateRefID > 0 ? this.indexToChr[mateRefID] : "";
                boolean mateIsNegativeStrand = (flag & this.MATE_STRAND_FLAG) != 0;
                mate = new ReadMate(mateChr, matePos, mateIsNegativeStrand, mateIsMapped);
            }
            byte[] tagBytes = Arrays.copyOfRange(ba, p2, blockEnd);
            if (pos + lengthOnRef >= min && pos <= max) {
                BAMAlignment alignment = new BAMAlignment();
                alignment.start = pos;
                alignment.flags = flag;
                alignment.fragmentLength = BAMReader.readInt(ba, offset + 32);
                alignment.cigarBytes = cigarBytes;
                alignment.lengthOnRef = lengthOnRef;
                alignment.sequence = sequence;
                alignment.mq = mq;
                alignment.readName = readName;
                alignment.chr = this.indexToChr[refID];
                alignment.qualities = qualities;
                alignment.mate = mate;
                alignment.tagBytes = tagBytes;
                this.makeBlocks(cigarArray, alignment);
                alignmentContainer.add(alignment);
            }
            offset = blockEnd;
        }
        return;
    }

    void readHeader() throws IOException {
        int len = (int)this.bamIndex.firstAlignmentBlock + this.MAX_GZIP_BLOCK_SIZE;
        SeekableStream ss = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
        byte[] buffer = new byte[len];
        try {
            ss.readFully(buffer);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        byte[] uncba = BGUnzip.blockUnzip(buffer);
        int magic = BAMReader.readInt(uncba, 0);
        int samHeaderLen = BAMReader.readInt(uncba, 4);
        String samHeader = new String(uncba, 8, samHeaderLen);
        int nRef = BAMReader.readInt(uncba, samHeaderLen + 8);
        int p2 = samHeaderLen + 12;
        HashMap<String, Integer> chrToIndex = new HashMap<String, Integer>();
        String[] indexToChr = new String[nRef];
        for (int i2 = 0; i2 < nRef; ++i2) {
            int lName = BAMReader.readInt(uncba, p2);
            String name = new String(uncba, p2 + 4, lName - 1);
            int lRef = BAMReader.readInt(uncba, p2 + lName + 4);
            if (this.genome != null) {
                name = this.genome.getCanonicalChrName(name);
            }
            chrToIndex.put(name, i2);
            indexToChr[i2] = name;
            p2 = p2 + 8 + lName;
        }
        this.chrToIndex = chrToIndex;
        this.indexToChr = indexToChr;
    }

    void makeBlocks(CigarOperator[] cigarArray, BAMAlignment alignment) {
        ArrayList<AlignmentBlockImpl> blocks = new ArrayList<AlignmentBlockImpl>();
        ArrayList<AlignmentBlockImpl> insertions = null;
        int seqOffset = 0;
        int pos = alignment.start;
        block9: for (CigarOperator c2 : cigarArray) {
            switch (c2.letter) {
                case 'H': {
                    continue block9;
                }
                case 'P': {
                    continue block9;
                }
                case 'S': {
                    seqOffset += c2.length;
                    int gapType = 83;
                    continue block9;
                }
                case 'N': {
                    pos += c2.length;
                    int gapType = 78;
                    continue block9;
                }
                case 'D': {
                    pos += c2.length;
                    int gapType = 68;
                    continue block9;
                }
                case 'I': {
                    byte[] blockQuals;
                    byte[] blockSeq = alignment.sequence.length == 1 ? alignment.sequence : Arrays.copyOfRange(alignment.sequence, seqOffset, seqOffset + c2.length);
                    byte[] byArray = blockQuals = alignment.qualities == null ? null : Arrays.copyOfRange(alignment.qualities, seqOffset, seqOffset + c2.length);
                    if (insertions == null) {
                        insertions = new ArrayList<AlignmentBlockImpl>();
                    }
                    insertions.add(new AlignmentBlockImpl(pos, blockSeq, blockQuals));
                    seqOffset += c2.length;
                    continue block9;
                }
                case '=': 
                case 'M': 
                case 'X': {
                    byte[] blockSeq = alignment.sequence.length == 1 ? alignment.sequence : Arrays.copyOfRange(alignment.sequence, seqOffset, seqOffset + c2.length);
                    byte[] blockQuals = alignment.qualities == null ? null : Arrays.copyOfRange(alignment.qualities, seqOffset, seqOffset + c2.length);
                    blocks.add(new AlignmentBlockImpl(pos, blockSeq, blockQuals));
                    seqOffset += c2.length;
                    pos += c2.length;
                    continue block9;
                }
                default: {
                    log.error("Error processing cigar element: " + c2.length + c2.letter);
                }
            }
        }
        alignment.alignmentBlocks = blocks.toArray(new AlignmentBlockImpl[0]);
        if (insertions != null) {
            alignment.insertions = insertions.toArray(new AlignmentBlockImpl[0]);
        }
    }

    public String readString(ByteBuffer ba) throws IOException {
        byte b2;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(100);
        while ((b2 = ba.get()) != 0) {
            if (b2 < 0) {
                throw new EOFException();
            }
            bis.write(b2);
        }
        return new String(bis.toByteArray());
    }

    public static int readInt(byte[] ba, int offset) {
        return (ba[offset + 3] << 24) + (ba[offset + 2] << 24 >>> 8) + (ba[offset + 1] << 24 >>> 16) + (ba[offset] << 24 >>> 24);
    }

    class CIterator
    implements CloseableIterator<Alignment> {
        String chr;
        Integer chrId;
        int start;
        int end;
        Iterator<BAMIndex.Chunk> chunks;
        Iterator<Alignment> currentChunkAlignments;
        Alignment nextAlignment;

        public CIterator(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.init();
        }

        private void init() {
            Map<String, Integer> chrToIndex = BAMReader.this.chrToIndex;
            this.chrId = chrToIndex.get(this.chr);
            if (this.chrId != null) {
                this.chunks = BAMReader.this.bamIndex.chunksForRange(this.chrId, this.start, this.end).iterator();
            }
            this.advance();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public Alignment next() {
            Alignment tmp = this.nextAlignment;
            this.advance();
            return tmp;
        }

        void advance() {
            this.nextAlignment = null;
            try {
                while (this.nextAlignment == null) {
                    if (this.currentChunkAlignments != null && this.currentChunkAlignments.hasNext()) {
                        this.nextAlignment = this.currentChunkAlignments.next();
                        continue;
                    }
                    if (this.chunks.hasNext()) {
                        BAMIndex.Chunk c2 = this.chunks.next();
                        this.currentChunkAlignments = BAMReader.this.readAlignments(c2, this.chrId, this.start, this.end).iterator();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
                this.nextAlignment = null;
            }
        }
    }
}

