/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.util.collections.DoubleArrayList;

public class ReadStats {
    private int readCount = 0;
    private int indelCount = 0;
    private int nCount = 0;
    private DoubleArrayList readLengths = new DoubleArrayList(10000);
    private DoubleArrayList refToReadRatios = new DoubleArrayList(10000);
    public double medianReadLength = 0.0;
    public double readLengthStdDev = 0.0;
    public double medianRefToReadRatio = 0.0;
    public double fracReadsWithIndels;
    public double fracReadsWithNs;

    public void addAlignment(Alignment alignment) {
        if (alignment.isMapped()) {
            ++this.readCount;
            int readLength = alignment.getReadSequence().length();
            char[] cigarString = alignment.getCigarString().toCharArray();
            this.readLengths.add(readLength);
            if (this.containsChar(cigarString, 'N')) {
                ++this.nCount;
                this.refToReadRatios.add((double)(alignment.getAlignmentEnd() - alignment.getAlignmentStart()) / (double)readLength);
            }
            if (this.containsChar(cigarString, 'D') || this.containsChar(cigarString, 'I')) {
                ++this.indelCount;
            }
        }
    }

    public void compute() {
        if (this.readLengths.size() > 0) {
            this.medianReadLength = StatUtils.percentile(this.readLengths.toArray(), 50.0);
            this.readLengthStdDev = Math.sqrt(StatUtils.variance(this.readLengths.toArray()));
        }
        if (this.refToReadRatios.size() > 0) {
            this.medianRefToReadRatio = StatUtils.percentile(this.refToReadRatios.toArray(), 50.0);
        }
        this.fracReadsWithIndels = (double)this.indelCount / (double)this.readCount;
        this.fracReadsWithNs = (double)this.nCount / (double)this.readCount;
    }

    private boolean containsChar(char[] charArray, char c2) {
        for (int i2 = 0; i2 < charArray.length; ++i2) {
            if (charArray[i2] != c2) continue;
            return true;
        }
        return false;
    }
}

