/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class EWigTrack
extends AbstractTrack {
    char[] nucleotides = new char[]{'A', 'C', 'G', 'T'};
    public static Color grey1 = new Color(230, 230, 230);
    Map<Character, TDFDataSource> baseSources;
    TDFDataSource tdfSource;
    private HashMap<String, LoadedInterval> loadedIntervalCache = new HashMap(200);

    public EWigTrack(ResourceLocator locator, Genome genome) {
        super(locator);
        TDFReader reader = TDFReader.getReader(locator.getPath());
        this.tdfSource = new TDFDataSource(reader, 4, "Pi", genome);
        this.setDataRange(new DataRange(0.0f, 0.0f, 10.0f));
        this.baseSources = new HashMap<Character, TDFDataSource>();
        for (int i2 = 0; i2 < 4; ++i2) {
            TDFDataSource src = new TDFDataSource(reader, i2, Character.toString(this.nucleotides[i2]), genome);
            this.baseSources.put(Character.valueOf(this.nucleotides[i2]), src);
        }
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        int zoom = frame.getZoom();
        LoadedInterval loadedInterval = this.loadedIntervalCache.get(frame.getName());
        return loadedInterval != null && loadedInterval.contains(chr, start, end, zoom);
    }

    @Override
    public void load(ReferenceFrame context) {
        String chr = context.getChrName();
        int start = (int)context.getOrigin();
        int end = (int)context.getEnd();
        int zoom = context.getZoom();
        int w2 = end - start;
        List<LocusScore> scores = this.tdfSource.getSummaryScoresForRange(chr, start -= w2 / 2, end += w2 / 2, zoom);
        HashMap<Character, List<LocusScore>> nScores = new HashMap<Character, List<LocusScore>>();
        char[] cArray = this.nucleotides;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Character c2 = Character.valueOf(cArray[i2]);
            nScores.put(c2, this.baseSources.get(c2).getSummaryScoresForRange(chr, start, end, zoom));
        }
        this.loadedIntervalCache.put(context.getName(), new LoadedInterval(chr, start, end, zoom, scores, nScores));
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.paint(context, rect);
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    private void paint(RenderContext context, Rectangle rect) {
        ReferenceFrame frame = context.getReferenceFrame();
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        int zoom = frame.getZoom();
        LoadedInterval loadedInterval = this.loadedIntervalCache.get(frame.getName());
        if (loadedInterval == null || !loadedInterval.contains(chr, start, end, zoom)) {
            return;
        }
        List scores = loadedInterval.scores;
        Map<Character, List<LocusScore>> nScores = loadedInterval.baseScores;
        Map<Character, Color> nucleotideColors = SequenceRenderer.getNucleotideColors();
        for (int idx = 0; idx < scores.size(); ++idx) {
            LocusScore score = (LocusScore)scores.get(idx);
            int startPosition = score.getStart();
            int endPosition = score.getEnd();
            int pX = (int)(rect.getX() + ((double)startPosition - context.getOrigin()) / context.getScale());
            int dX = Math.max(1, (int)(rect.getX() + ((double)endPosition - context.getOrigin()) / context.getScale()) - pX);
            if (dX > 4) {
                dX -= 2;
                ++pX;
            }
            if (pX + dX < 0) continue;
            if ((double)pX > context.getVisibleRect().getMaxX()) break;
            float totalCount = score.getScore();
            int pY = (int)rect.getMaxY() - 1;
            float dataMax = this.getDataRange().getMaximum();
            double height = (double)totalCount * rect.getHeight() / (double)dataMax;
            height = Math.min(height, (double)(rect.height - 1));
            for (char c2 : this.nucleotides) {
                try {
                    LocusScore ns = nScores.get(Character.valueOf(c2)).get(idx);
                    float count = ns.getScore() * totalCount;
                    Graphics2D tGraphics = context.getGraphic2DForColor(nucleotideColors.get(Character.valueOf(c2)));
                    int h2 = (int)Math.round((double)count * height / (double)totalCount);
                    h2 = Math.min(pY - rect.y, h2);
                    int baseY = pY - h2;
                    if (h2 > 0) {
                        tGraphics.fillRect(pX, baseY, dX, h2);
                    }
                    pY = baseY;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        context.getGraphic2DForColor(Color.gray).drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
    }

    public JPopupMenu getPopupMenu(MouseEvent evt) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmp));
        popupMenu.add(TrackMenuUtils.getChangeTrackHeightItem(tmp));
        popupMenu.add(TrackMenuUtils.getDataRangeItem(tmp));
        return popupMenu;
    }

    public static class LoadedInterval {
        Locus range;
        private List<LocusScore> scores;
        int zoom;
        Map<Character, List<LocusScore>> baseScores;

        public LoadedInterval(String chr, int start, int end, int zoom, List<LocusScore> scores, Map<Character, List<LocusScore>> baseScores) {
            this.range = new Locus(chr, start, end);
            this.zoom = zoom;
            this.scores = scores;
            this.baseScores = baseScores;
        }

        public boolean contains(String chr, int start, int end, int zoom) {
            return this.zoom == zoom && this.range.contains(chr, start, end);
        }
    }
}

