/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.Row;

public class AlignmentPacker {
    private static final Logger log = Logger.getLogger(AlignmentPacker.class);
    public static final int MIN_ALIGNMENT_SPACING = 2;
    private static final Comparator<Alignment> lengthComparator = new Comparator<Alignment>(){

        @Override
        public int compare(Alignment row1, Alignment row2) {
            return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
        }
    };
    private static final String NULL_GROUP_VALUE = "";
    public static final int tenMB = 10000000;

    public PackedAlignments packAlignments(AlignmentInterval interval, AlignmentTrack.RenderOptions renderOptions) {
        LinkedHashMap<String, List<Row>> packedAlignments = new LinkedHashMap<String, List<Row>>();
        List<Alignment> alList = interval.getAlignments();
        if (renderOptions.isLinkedReads()) {
            alList = this.linkByTag(alList, renderOptions.getLinkByTag());
        }
        if (renderOptions.getGroupByOption() == null) {
            ArrayList<Row> alignmentRows = new ArrayList<Row>(10000);
            this.pack(alList, renderOptions, alignmentRows);
            packedAlignments.put(NULL_GROUP_VALUE, alignmentRows);
        } else {
            HashMap<String, ArrayList<Alignment>> groupedAlignments = new HashMap<String, ArrayList<Alignment>>();
            for (Alignment alignment : alList) {
                ArrayList<Alignment> groupList;
                String groupKey = this.getGroupValue(alignment, renderOptions);
                if (groupKey == null) {
                    groupKey = NULL_GROUP_VALUE;
                }
                if ((groupList = (ArrayList<Alignment>)groupedAlignments.get(groupKey)) == null) {
                    groupList = new ArrayList<Alignment>(1000);
                    groupedAlignments.put(groupKey, groupList);
                }
                groupList.add(alignment);
            }
            ArrayList keys = new ArrayList(groupedAlignments.keySet());
            Comparator<String> groupComparator = this.getGroupComparator(renderOptions.getGroupByOption());
            Collections.sort(keys, groupComparator);
            for (String key : keys) {
                ArrayList<Row> alignmentRows = new ArrayList<Row>(10000);
                List group = (List)groupedAlignments.get(key);
                this.pack(group, renderOptions, alignmentRows);
                packedAlignments.put(key, alignmentRows);
            }
        }
        ArrayList<AlignmentInterval> tmp = new ArrayList<AlignmentInterval>();
        tmp.add(interval);
        return new PackedAlignments(tmp, packedAlignments);
    }

    private void pack(List<Alignment> alList, AlignmentTrack.RenderOptions renderOptions, List<Row> alignmentRows) {
        HashMap<String, PairedAlignment> pairs = null;
        boolean isPairedAlignments = renderOptions.isViewPairs();
        String linkByTag = renderOptions.getLinkByTag();
        if (isPairedAlignments) {
            pairs = new HashMap<String, PairedAlignment>(1000);
        }
        int totalCount = 0;
        if (alList == null || alList.size() == 0) {
            return;
        }
        Range curRange = this.getAlignmentListRange(alList);
        int bpLength = curRange.getLength();
        BucketCollection bucketCollection = bpLength < 10000000 ? new DenseBucketCollection(bpLength, curRange) : new SparseBucketCollection(curRange);
        int curRangeStart = curRange.getStart();
        for (Alignment al : alList) {
            int bucketNumber;
            if (!al.isMapped()) continue;
            Alignment alignment = al;
            if (isPairedAlignments && this.isPairable(al)) {
                String readName = al.getReadName();
                PairedAlignment pair = (PairedAlignment)pairs.get(readName);
                if (pair == null) {
                    pair = new PairedAlignment(al);
                    pairs.put(readName, pair);
                    alignment = pair;
                } else {
                    pair.setSecondAlignment(al);
                    pairs.remove(readName);
                    continue;
                }
            }
            if ((bucketNumber = Math.max(0, al.getStart() - curRangeStart)) < bucketCollection.getBucketCount()) {
                PriorityQueue<Alignment> bucket = bucketCollection.get(bucketNumber);
                if (bucket == null) {
                    bucket = new PriorityQueue<Alignment>(5, lengthComparator);
                    bucketCollection.set(bucketNumber, bucket);
                }
                bucket.add(alignment);
                ++totalCount;
                continue;
            }
            log.debug("Alignment out of bounds. name: " + alignment.getReadName() + " startPos:" + alignment.getStart());
        }
        bucketCollection.finishedAdding();
        long t0 = System.currentTimeMillis();
        int allocatedCount = 0;
        Row currentRow = new Row();
        while (allocatedCount < totalCount) {
            PriorityQueue<Alignment> bucket;
            curRange = bucketCollection.getRange();
            int nextStart = curRangeStart = curRange.getStart();
            ArrayList<Integer> emptyBuckets = new ArrayList<Integer>(100);
            do {
                int bucketNumber;
                if ((bucket = bucketCollection.getNextBucket(bucketNumber = nextStart - curRangeStart, emptyBuckets)) == null) continue;
                Alignment alignment = (Alignment)bucket.remove();
                currentRow.addAlignment(alignment);
                ++allocatedCount;
                nextStart = alignment.getEnd() + 2;
            } while (bucket != null && nextStart <= curRange.getEnd());
            bucketCollection.removeBuckets(emptyBuckets);
            emptyBuckets.clear();
            if (currentRow.alignments.size() > 0) {
                alignmentRows.add(currentRow);
            }
            currentRow = new Row();
        }
        if (log.isDebugEnabled()) {
            long dt = System.currentTimeMillis() - t0;
            log.debug("Packed alignments in " + dt);
        }
        if (currentRow != null && currentRow.alignments.size() > 0) {
            alignmentRows.add(currentRow);
        }
    }

    private boolean isPairable(Alignment al) {
        return al.isPrimary() && al.isPaired() && al.getMate().isMapped() && al.getMate().getChr().equals(al.getChr());
    }

    private List<Alignment> linkByTag(List<Alignment> alList, String tag) {
        ArrayList<Alignment> bcList = new ArrayList<Alignment>(alList.size() / 10);
        HashMap<Object, LinkedAlignment> map = new HashMap<Object, LinkedAlignment>(bcList.size() * 2);
        for (Alignment a2 : alList) {
            if (a2.isPrimary()) {
                Object bc;
                if ("READNAME".equals(tag)) {
                    bc = a2.getReadName();
                    if (a2.isPaired()) {
                        bc = bc + (a2.isFirstOfPair() ? "/1" : "/2");
                    }
                } else {
                    bc = a2.getAttribute(tag);
                }
                if (bc == null) {
                    bcList.add(a2);
                    continue;
                }
                LinkedAlignment linkedAlignment = (LinkedAlignment)map.get(bc);
                if (linkedAlignment == null) {
                    linkedAlignment = new LinkedAlignment(tag, bc.toString());
                    map.put(bc, linkedAlignment);
                    bcList.add(linkedAlignment);
                }
                linkedAlignment.addAlignment(a2);
                continue;
            }
            bcList.add(a2);
        }
        ArrayList<Alignment> delinkedList = new ArrayList<Alignment>(alList.size());
        for (Alignment a3 : bcList) {
            if (a3 instanceof LinkedAlignment) {
                List<Alignment> alignments = ((LinkedAlignment)a3).alignments;
                if (alignments.size() == 1) {
                    delinkedList.add(alignments.get(0));
                    continue;
                }
                a3.finish();
                delinkedList.add(a3);
                continue;
            }
            delinkedList.add(a3);
        }
        return delinkedList;
    }

    private Range getAlignmentListRange(List<Alignment> alignmentsList) {
        if (alignmentsList == null || alignmentsList.size() == 0) {
            return null;
        }
        Alignment firstAlignment = alignmentsList.get(0);
        int minStart = firstAlignment.getStart();
        int maxEnd = firstAlignment.getEnd();
        for (Alignment alignment : alignmentsList) {
            maxEnd = Math.max(maxEnd, alignment.getEnd());
        }
        return new Range(firstAlignment.getChr(), minStart, maxEnd);
    }

    private Comparator<String> getGroupComparator(AlignmentTrack.GroupOption groupByOption) {
        switch (groupByOption) {
            case PAIR_ORIENTATION: {
                return new PairOrientationComparator();
            }
        }
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1.equals(o2)) {
                    return 0;
                }
                if (AlignmentPacker.NULL_GROUP_VALUE.equals(o1)) {
                    return 1;
                }
                if (AlignmentPacker.NULL_GROUP_VALUE.equals(o2)) {
                    return -1;
                }
                return o1.compareToIgnoreCase(o2);
            }
        };
    }

    private String getGroupValue(Alignment al, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentTrack.GroupOption groupBy = renderOptions.getGroupByOption();
        String tag = renderOptions.getGroupByTag();
        Range pos = renderOptions.getGroupByPos();
        switch (groupBy) {
            case STRAND: {
                return al.isNegativeStrand() ? "-" : "+";
            }
            case SAMPLE: {
                return al.getSample();
            }
            case LIBRARY: {
                return al.getLibrary();
            }
            case READ_GROUP: {
                return al.getReadGroup();
            }
            case TAG: {
                Object tagValue = al.getAttribute(tag);
                return tagValue == null ? null : tagValue.toString();
            }
            case FIRST_OF_PAIR_STRAND: {
                Strand strand = al.getFirstOfPairStrand();
                String strandString = strand == Strand.NONE ? null : strand.toString();
                return strandString;
            }
            case PAIR_ORIENTATION: {
                PEStats peStats = AlignmentRenderer.getPEStats(al, renderOptions);
                AlignmentTrack.OrientationType type = AlignmentRenderer.getOrientationType(al, peStats);
                if (type == null) {
                    return AlignmentTrack.OrientationType.UNKNOWN.name();
                }
                return type.name();
            }
            case MATE_CHROMOSOME: {
                ReadMate mate = al.getMate();
                if (mate == null) {
                    return null;
                }
                if (!mate.isMapped()) {
                    return "UNMAPPED";
                }
                return mate.getChr();
            }
            case SUPPLEMENTARY: {
                return al.isSupplementary() ? "SUPPLEMENTARY" : NULL_GROUP_VALUE;
            }
            case BASE_AT_POS: {
                if (al.getChr().equals(pos.getChr()) && al.getAlignmentStart() <= pos.getStart() && al.getAlignmentEnd() > pos.getStart()) {
                    byte[] baseAtPos = new byte[]{al.getBase(pos.getStart())};
                    if (baseAtPos[0] == 0) {
                        return "2:";
                    }
                    return "1:" + new String(baseAtPos);
                }
                return "3:";
            }
        }
        return null;
    }

    private class PairOrientationComparator
    implements Comparator<String> {
        private final List<AlignmentTrack.OrientationType> orientationTypes = Arrays.asList(AlignmentTrack.OrientationType.values());

        @Override
        public int compare(String s0, String s1) {
            if (s0 != null && s1 != null) {
                AlignmentTrack.OrientationType t0 = AlignmentTrack.OrientationType.valueOf(s0);
                AlignmentTrack.OrientationType t1 = AlignmentTrack.OrientationType.valueOf(s1);
                return this.orientationTypes.indexOf((Object)t0) - this.orientationTypes.indexOf((Object)t1);
            }
            if (s0 == null ^ s1 == null) {
                return s0 == null ? 1 : -1;
            }
            return 0;
        }
    }

    static class SparseBucketCollection
    implements BucketCollection {
        Range range;
        boolean finished = false;
        List<Integer> keys;
        final HashMap<Integer, PriorityQueue<Alignment>> buckets;

        SparseBucketCollection(Range range) {
            this.range = range;
            this.buckets = new HashMap(1000);
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            if (this.finished) {
                log.error("Error: bucket added after finishAdding() called");
            }
            this.buckets.put(idx, bucket);
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.buckets.get(idx);
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            Integer key;
            PriorityQueue<Alignment> bucket = null;
            int min = 0;
            int max = this.keys.size() - 1;
            while (max - min > 5) {
                int mid = (max + min) / 2;
                key = this.keys.get(mid);
                if (key > bucketNumber) {
                    max = mid;
                    continue;
                }
                min = mid;
            }
            for (int i2 = min; i2 < this.keys.size(); ++i2) {
                key = this.keys.get(i2);
                if (key < bucketNumber) continue;
                bucket = this.buckets.get(key);
                if (bucket.isEmpty()) {
                    emptyBuckets.add(key);
                    bucket = null;
                    continue;
                }
                return bucket;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
            if (emptyBuckets.isEmpty()) {
                return;
            }
            for (Integer i2 : emptyBuckets) {
                this.buckets.remove(i2);
            }
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public void finishedAdding() {
            this.finished = true;
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public int getBucketCount() {
            return Integer.MAX_VALUE;
        }
    }

    static class DenseBucketCollection
    implements BucketCollection {
        Range range;
        int lastBucketNumber = -1;
        final PriorityQueue[] bucketArray;

        DenseBucketCollection(int bucketCount, Range range) {
            this.bucketArray = new PriorityQueue[bucketCount];
            this.range = range;
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            this.bucketArray[idx] = bucket;
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.bucketArray[idx];
        }

        @Override
        public int getBucketCount() {
            return this.bucketArray.length;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            if (bucketNumber == this.lastBucketNumber) {
                // empty if block
            }
            PriorityQueue bucket = null;
            while (bucketNumber < this.bucketArray.length) {
                if (bucketNumber < 0) {
                    log.info("Negative bucket number: " + bucketNumber);
                }
                if ((bucket = this.bucketArray[bucketNumber]) != null) {
                    if (bucket.isEmpty()) {
                        this.bucketArray[bucketNumber] = null;
                    } else {
                        return bucket;
                    }
                }
                ++bucketNumber;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
        }

        @Override
        public void finishedAdding() {
        }
    }

    static interface BucketCollection {
        public Range getRange();

        public void set(int var1, PriorityQueue<Alignment> var2);

        public PriorityQueue<Alignment> get(int var1);

        public PriorityQueue<Alignment> getNextBucket(int var1, Collection<Integer> var2);

        public void removeBuckets(Collection<Integer> var1);

        public void finishedAdding();

        public int getBucketCount();
    }
}

