/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public class LineplotRenderer
extends XYPlotRenderer {
    @Override
    public void renderScores(Track track, List<LocusScore> locusScores, RenderContext context, Rectangle arect) {
        Rectangle adjustedRect = this.calculateDrawingRect(arect);
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color posColor = track.getColor();
        Color negColor = track.getAltColor();
        Graphics2D gPos = context.getGraphic2DForColor(posColor);
        Graphics2D gNeg = context.getGraphic2DForColor(negColor);
        if (PreferencesManager.getPreferences().getAsBoolean("ENABLE_ANTIALIASING")) {
            gPos.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gNeg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        DataRange axisDefinition = track.getDataRange();
        float maxValue = axisDefinition.getMaximum();
        float baseValue = axisDefinition.getBaseline();
        float minValue = axisDefinition.getMinimum();
        double yScaleFactor = adjustedRect.getHeight() / (double)(maxValue - minValue);
        int lastPx = 0;
        int lastPy = Integer.MIN_VALUE;
        for (LocusScore score : locusScores) {
            double x2 = ((double)score.getStart() - origin) / locScale;
            double dx = (double)(score.getEnd() - score.getStart()) / locScale;
            float dataY = score.getScore();
            double y = adjustedRect.getY() + (double)(maxValue - dataY) * yScaleFactor;
            if (x2 + dx < 0.0 || lastPy == Integer.MIN_VALUE) {
                lastPx = (int)(x2 + dx);
                lastPy = (int)y;
                continue;
            }
            if (Float.isNaN(dataY)) continue;
            int pX = (int)x2;
            int pY = (int)y;
            double slope = ((double)pY - (double)lastPy) / (double)(pX - lastPx);
            int clippedLastPX = lastPx;
            int clippedLastPY = lastPy;
            if (lastPy < adjustedRect.y || lastPy > adjustedRect.y + adjustedRect.height) {
                clippedLastPY = lastPy < adjustedRect.y ? adjustedRect.y : adjustedRect.y + adjustedRect.height;
                clippedLastPX = lastPx + (int)((double)(clippedLastPY - lastPy) / slope);
            }
            int clippedPX = pX;
            int clippedPY = pY;
            if (pY < adjustedRect.y || pY > adjustedRect.y + adjustedRect.height) {
                clippedPY = (double)pY < adjustedRect.getMinY() ? adjustedRect.y : adjustedRect.y + adjustedRect.height;
                clippedPX = lastPx + (int)((double)(clippedPY - lastPy) / slope);
            }
            Graphics2D g2 = dataY >= 0.0f ? gPos : gNeg;
            g2.drawLine(clippedLastPX, clippedLastPY, clippedPX, clippedPY);
            if (dx >= 1.0 && clippedPY == pY) {
                g2.drawLine(pX, clippedPY, (int)((double)pX + dx), clippedPY);
            }
            lastPx = (int)((double)pX + dx);
            lastPy = pY;
            if (!((double)lastPx > adjustedRect.getMaxX())) continue;
            break;
        }
        gPos.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        gNeg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }
}

