/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.maf.MultipleAlignmentBlock;

public class MafChunk {
    String chr;
    int start;
    int end;
    LinkedHashMap<String, MultipleAlignmentBlock> blocks;

    public MafChunk(String chr, int start, int end, List<MultipleAlignmentBlock> blockList) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.blocks = new LinkedHashMap();
        for (MultipleAlignmentBlock b2 : blockList) {
            this.blocks.put(b2.getKey(), b2);
        }
    }

    public boolean overlaps(String chr, int start, int end) {
        if (!chr.equals(this.chr)) {
            return false;
        }
        return end >= this.start && start <= this.end;
    }

    public boolean contains(String chr, int start, int end) {
        if (!chr.equals(this.chr)) {
            return false;
        }
        return start >= this.start && end <= this.end;
    }

    public void addBlocks(int start, int end, List<MultipleAlignmentBlock> blockList) {
        if (start > this.end || end < this.start) {
            this.blocks.clear();
            for (MultipleAlignmentBlock b2 : blockList) {
                this.blocks.put(b2.getKey(), b2);
            }
        } else if (start < this.start) {
            MultipleAlignmentBlock b3;
            String key;
            LinkedHashMap<String, MultipleAlignmentBlock> tmp = this.blocks;
            this.blocks = new LinkedHashMap();
            Iterator<MultipleAlignmentBlock> b2 = blockList.iterator();
            while (b2.hasNext() && !this.blocks.containsKey(key = (b3 = b2.next()).getKey())) {
                this.blocks.put(key, b3);
            }
            this.blocks.putAll(tmp);
            this.start = start;
        } else {
            for (MultipleAlignmentBlock b4 : blockList) {
                String key = b4.getKey();
                if (this.blocks.containsKey(key)) continue;
                this.blocks.put(b4.getKey(), b4);
            }
            this.end = end;
        }
    }

    public void trimTo(int start, int end) {
        LinkedHashMap<String, MultipleAlignmentBlock> tmp = this.blocks;
        this.blocks = new LinkedHashMap();
        for (Map.Entry<String, MultipleAlignmentBlock> entry : tmp.entrySet()) {
            String key = entry.getKey();
            MultipleAlignmentBlock block = entry.getValue();
            if (block.getEnd() < start) continue;
            if (block.getStart() > end) break;
            this.blocks.put(key, block);
        }
    }
}

