/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ga4gh.Ga4ghDataset;
import org.broad.igv.ga4gh.Ga4ghProvider;
import org.broad.igv.ga4gh.Ga4ghReadset;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;

public class Ga4ghLoadDialog
extends JDialog {
    private static Logger log = Logger.getLogger(Ga4ghLoadDialog.class);
    private final DefaultTreeModel treeModel;
    Ga4ghProvider[] providers;
    String selectedId;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JTree selectionTree;
    private JPanel buttonBar;
    private JButton loadButton;
    private JButton cancelButton;
    private JLabel label1;

    public Ga4ghLoadDialog(Frame owner, Ga4ghProvider[] providers) {
        super(owner);
        this.initComponents();
        this.providers = providers;
        this.treeModel = new DefaultTreeModel(this.createNodes(providers));
        this.selectionTree.setModel(this.treeModel);
    }

    private DefaultMutableTreeNode createNodes(Ga4ghProvider[] providers) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Ga4gh");
        for (Ga4ghProvider provider : providers) {
            DefaultMutableTreeNode providerNode = new DefaultMutableTreeNode(provider.getName());
            top.add(providerNode);
            for (Ga4ghDataset dataset : provider.getDatasets()) {
                DefaultMutableTreeNode datasetNode = new DefaultMutableTreeNode(dataset.getName());
                providerNode.add(datasetNode);
                for (Ga4ghReadset readset : dataset.getReadsets()) {
                    DefaultMutableTreeNode readsetNode = new DefaultMutableTreeNode(new LeafNode(provider, readset));
                    datasetNode.add(readsetNode);
                }
            }
        }
        return top;
    }

    private void loadButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        LongRunningTask.submit(new Runnable(){

            @Override
            public void run() {
                TreePath[] paths;
                for (TreePath path : paths = Ga4ghLoadDialog.this.selectionTree.getSelectionPaths()) {
                    DefaultMutableTreeNode obj = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = obj.getUserObject();
                    if (!(userObject instanceof LeafNode)) continue;
                    Ga4ghProvider provider = ((LeafNode)userObject).provider;
                    Ga4ghReadset readSet = ((LeafNode)userObject).readset;
                    Ga4ghLoadDialog.this.setGenome(readSet.getGenomeId());
                    Ga4ghLoadDialog.this.loadTrack(readSet.getId(), provider, readSet.getName());
                }
            }
        });
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.selectedId = null;
        this.setVisible(false);
    }

    private void loadTrack(String readsetId, Ga4ghProvider provider, String name) {
        ResourceLocator locator = new ResourceLocator(readsetId);
        locator.setName(name);
        locator.setType("ga4gh");
        locator.setAttribute("provider", provider);
        IGV.getInstance().loadTracks(Arrays.asList(locator));
    }

    private void setGenome(String genomeId) {
        GenomeListItem item;
        if (genomeId != null && !genomeId.equals(GenomeManager.getInstance().getGenomeId()) && (item = GenomeListManager.getInstance().getGenomeListItem(genomeId)) != null) {
            try {
                GenomeManager.getInstance().loadGenomeById(genomeId);
            }
            catch (IOException e2) {
                MessageUtils.showErrorMessage("Error loading genome: " + genomeId, e2);
                log.error("Error loading genome: " + genomeId, e2);
            }
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.selectionTree = new JTree();
        this.buttonBar = new JPanel();
        this.loadButton = new JButton();
        this.cancelButton = new JButton();
        this.label1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("GA4GH Prototype");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.scrollPane1.setViewportView(this.selectionTree);
        this.contentPanel.add(this.scrollPane1);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Ga4ghLoadDialog.this.loadButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.loadButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Ga4ghLoadDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.label1.setText("Select a readset to load");
        this.dialogPane.add((Component)this.label1, "North");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(795, 690);
        this.setLocationRelativeTo(this.getOwner());
    }

    class LeafNode {
        Ga4ghProvider provider;
        Ga4ghReadset readset;

        LeafNode(Ga4ghProvider provider, Ga4ghReadset readset) {
            this.provider = provider;
            this.readset = readset;
        }

        public String toString() {
            return this.readset.getName();
        }
    }
}

