/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.util.StringUtils;

public class UCSCGeneTableCodec
extends UCSCCodec<BasicFeature> {
    private int nameColumn = 0;
    private int idColumn = 1;
    private int chrColumn = 2;
    private int strandColumn = 3;
    private int startColumn = 4;
    private int endColumn = 5;
    private int cdStartColumn = 6;
    private int cdEndColumn = 7;
    private int exonCountColumn = 8;
    private int startsBufferColumn = 9;
    private int endsBufferColumn = 10;
    private int frameBufferColumn = 15;
    private Genome genome;
    private Type type;

    public UCSCGeneTableCodec(Type type, Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
        this.type = type;
        switch (type) {
            case REFFLAT: {
                break;
            }
            case UCSCGENE: {
                this.idColumn = 0;
                this.chrColumn = 1;
                this.strandColumn = 2;
                this.startColumn = 3;
                this.endColumn = 4;
                this.cdStartColumn = 5;
                this.cdEndColumn = 6;
                this.exonCountColumn = 7;
                this.startsBufferColumn = 8;
                this.endsBufferColumn = 9;
                this.nameColumn = 10;
                break;
            }
            case GENEPRED: {
                this.nameColumn = 12;
            }
        }
    }

    @Override
    public BasicFeature decode(String line) {
        if (line.startsWith("#")) {
            this.readHeaderLine(line);
            return null;
        }
        String[] tokens = Globals.singleTabMultiSpacePattern.split(line = line.replaceAll("\"", ""));
        int tokenCount = tokens.length;
        if (tokenCount <= this.strandColumn) {
            return null;
        }
        String identifier = tokens[this.idColumn].trim();
        String name = null;
        if (tokenCount > this.nameColumn && tokens[this.nameColumn] != null) {
            name = tokens[this.nameColumn];
        }
        if (name == null || name.length() == this.nameColumn) {
            name = identifier;
        }
        String chrToken = tokens[this.chrColumn].trim();
        String chr = this.genome == null ? StringUtils.intern(chrToken) : this.genome.getCanonicalChrName(chrToken);
        int start = Integer.parseInt(tokens[this.startColumn]);
        int end = Integer.parseInt(tokens[this.endColumn]);
        String strandString = tokens[this.strandColumn];
        Strand strand = Strand.NONE;
        if (strandString != null) {
            if (strandString.trim().equals("+")) {
                strand = Strand.POSITIVE;
            } else if (strandString.trim().equals("-")) {
                strand = Strand.NEGATIVE;
            }
        }
        BasicFeature gene = new BasicFeature(chr, start, end, strand);
        gene.setRepresentation(line);
        gene.setName(name);
        gene.setIdentifier(identifier);
        if (tokenCount > 7) {
            gene.setThickStart(Integer.parseInt(tokens[6]));
            gene.setThickEnd(Integer.parseInt(tokens[7]));
        }
        if (tokenCount > 8) {
            this.createExons(tokens, tokenCount, gene, chr, strand);
        }
        if (tokenCount > 16) {
            gene.setAttribute("Standard Name", tokens[16]);
        }
        return gene;
    }

    @Override
    public boolean canDecode(String path) {
        return true;
    }

    private void createExons(String[] tokens, int tokenCount, BasicFeature gene, String chr, Strand strand) throws NumberFormatException {
        String[] endsBuffer;
        int cdStart = Integer.parseInt(tokens[this.cdStartColumn]);
        int cdEnd = Integer.parseInt(tokens[this.cdEndColumn]);
        int exonCount = Integer.parseInt(tokens[this.exonCountColumn]);
        String[] startsBuffer = Globals.commaPattern.split(tokens[this.startsBufferColumn]);
        if (startsBuffer.length == (endsBuffer = Globals.commaPattern.split(tokens[this.endsBufferColumn])).length) {
            int exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
            for (int i2 = 0; i2 < startsBuffer.length; ++i2) {
                int exonStart = Integer.parseInt(startsBuffer[i2]);
                int exonEnd = Integer.parseInt(endsBuffer[i2]);
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                exon.setCodingStart(cdStart);
                exon.setCodingEnd(cdEnd);
                gene.addExon(exon);
                exon.setNumber(exonNumber);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
        List<Exon> exons = gene.getExons();
        int start = strand == Strand.POSITIVE ? 0 : exonCount - 1;
        int end = strand == Strand.POSITIVE ? exonCount : -1;
        int increment = strand == Strand.POSITIVE ? 1 : -1;
        int mRNABase = 0;
        for (int i3 = start; i3 != end; i3 += increment) {
            Exon exon = exons.get(i3);
            exon.setMrnaBase(mRNABase);
            mRNABase += exon.getCodingLength();
        }
        if (this.type == Type.GENEPRED && tokenCount > 15) {
            try {
                String[] frameBuffer = Globals.commaPattern.split(tokens[this.frameBufferColumn]);
                for (int i4 = 0; i4 < frameBuffer.length; ++i4) {
                    int exonFrame = Integer.parseInt(frameBuffer[i4].trim());
                    if (exonFrame == -1) {
                        exons.get(i4).setNonCoding(true);
                        continue;
                    }
                    int phase = exonFrame == 0 ? 0 : 3 - exonFrame;
                    exons.get(i4).setPhase(phase);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum Type {
        REFFLAT,
        GENEPRED,
        UCSCGENE;

    }
}

