/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.bionano;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.bionano.SMAPFeature;
import org.broad.igv.feature.bionano.SMAPPairedFeature;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public class SMAPRenderer
extends FeatureRenderer {
    static final int BLOCK_HEIGHT = 14;

    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        for (IGVFeature feature : featureList) {
            double pixelStart = Math.max((double)trackRectangle.x, ((double)feature.getStart() - origin) / locScale);
            double pixelEnd = Math.min((double)(trackRectangle.x + trackRectangle.width), ((double)feature.getEnd() - origin) / locScale);
            if (pixelEnd < (double)trackRectangle.x) continue;
            if (pixelStart > (double)(trackRectangle.x + trackRectangle.width)) break;
            Color color = feature.getColor();
            if (color == null) {
                color = track.getColor();
            }
            Graphics2D g2 = context.getGraphic2DForColor(color);
            int y = trackRectangle.y + trackRectangle.height / 2;
            if (feature instanceof SMAPPairedFeature) {
                SMAPFeature feature1 = ((SMAPPairedFeature)feature).feature1;
                SMAPFeature feature2 = ((SMAPPairedFeature)feature).feature2;
                int x1 = (int)Math.max((double)trackRectangle.x, ((double)feature1.getEnd() - origin) / locScale);
                int x2 = (int)Math.min((double)(trackRectangle.x + trackRectangle.width), ((double)feature2.getStart() - origin) / locScale);
                g2.drawLine(x1, y, x2, y);
                this.drawSMapFeature(g2, trackRectangle, origin, locScale, y, feature1);
                this.drawSMapFeature(g2, trackRectangle, origin, locScale, y, feature2);
                continue;
            }
            this.drawSMapFeature(g2, trackRectangle, origin, locScale, y, feature);
        }
    }

    public void drawSMapFeature(Graphics2D g2, Rectangle trackRectangle, double origin, double locScale, int y, IGVFeature feature) {
        double pixelStart = Math.max((double)trackRectangle.x, ((double)feature.getStart() - origin) / locScale);
        double pixelEnd = Math.min((double)(trackRectangle.x + trackRectangle.width), ((double)feature.getEnd() - origin) / locScale);
        if (pixelEnd >= trackRectangle.getX() && pixelStart <= trackRectangle.getMaxX()) {
            int w2 = (int)(pixelEnd - pixelStart);
            if (w2 < 3) {
                w2 = 3;
                pixelStart -= 1.0;
            }
            g2.fillRect((int)pixelStart, y - 7, w2, 14);
        }
    }
}

